/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.lang.invoke.MethodHandle;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestRealOperators {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testTypeConstructor() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("REAL '12.2'")))).isEqualTo(Float.valueOf(12.2f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("REAL '-17.76'")))).isEqualTo(Float.valueOf(-17.76f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("REAL 'NaN'")))).isEqualTo(Float.valueOf(Float.NaN));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("REAL '-NaN'")))).isEqualTo(Float.valueOf(Float.NaN));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("REAL 'Infinity'")))).isEqualTo(Float.valueOf(Float.POSITIVE_INFINITY));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("REAL '-Infinity'")))).isEqualTo(Float.valueOf(Float.NEGATIVE_INFINITY));
    }

    @Test
    public void testAdd() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "REAL '12.34'", "REAL '56.78'")))).isEqualTo(Float.valueOf(69.119995f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "REAL '-17.34'", "REAL '-22.891'")))).isEqualTo(Float.valueOf(-40.231003f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "REAL '-89.123'", "REAL '754.0'")))).isEqualTo(Float.valueOf(664.877f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "REAL '-0.0'", "REAL '0.0'")))).isEqualTo(Float.valueOf(0.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "REAL 'NaN'", "REAL '1.23'")))).isEqualTo(Float.valueOf(Float.NaN));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "REAL '1.23'", "REAL 'NaN'")))).isEqualTo(Float.valueOf(Float.NaN));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "REAL 'NaN'", "REAL '-NaN'")))).isEqualTo(Float.valueOf(Float.NaN));
    }

    @Test
    public void testSubtract() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "REAL '12.34'", "REAL '56.78'")))).isEqualTo(Float.valueOf(-44.44f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "REAL '-17.34'", "REAL '-22.891'")))).isEqualTo(Float.valueOf(5.5510006f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "REAL '-89.123'", "REAL '754.0'")))).isEqualTo(Float.valueOf(-843.123f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "REAL '-0.0'", "REAL '0.0'")))).isEqualTo(Float.valueOf(-0.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "REAL 'NaN'", "REAL '1.23'")))).isEqualTo(Float.valueOf(Float.NaN));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "REAL '1.23'", "REAL 'NaN'")))).isEqualTo(Float.valueOf(Float.NaN));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "REAL 'NaN'", "REAL 'NaN'")))).isEqualTo(Float.valueOf(Float.NaN));
    }

    @Test
    public void testMultiply() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "REAL '12.34'", "REAL '56.78'")))).isEqualTo(Float.valueOf(700.6652f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "REAL '-17.34'", "REAL '-22.891'")))).isEqualTo(Float.valueOf(396.92996f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "REAL '-89.123'", "REAL '754.0'")))).isEqualTo(Float.valueOf(-67198.74f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "REAL '-0.0'", "REAL '0.0'")))).isEqualTo(Float.valueOf(-0.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "REAL '-17.71'", "REAL '-1.0'")))).isEqualTo(Float.valueOf(17.71f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "REAL 'NaN'", "REAL '1.23'")))).isEqualTo(Float.valueOf(Float.NaN));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "REAL '1.23'", "REAL 'NaN'")))).isEqualTo(Float.valueOf(Float.NaN));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "REAL 'NaN'", "REAL '-NaN'")))).isEqualTo(Float.valueOf(Float.NaN));
    }

    @Test
    public void testDivide() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "REAL '12.34'", "REAL '56.78'")))).isEqualTo(Float.valueOf(0.21733005f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "REAL '-17.34'", "REAL '-22.891'")))).isEqualTo(Float.valueOf(0.7575029f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "REAL '-89.123'", "REAL '754.0'")))).isEqualTo(Float.valueOf(-0.118200265f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "REAL '-0.0'", "REAL '0.0'")))).isEqualTo(Float.valueOf(Float.NaN));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "REAL '-17.71'", "REAL '-1.0'")))).isEqualTo(Float.valueOf(17.71f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "REAL 'NaN'", "REAL '1.23'")))).isEqualTo(Float.valueOf(Float.NaN));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "REAL '1.23'", "REAL 'NaN'")))).isEqualTo(Float.valueOf(Float.NaN));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "REAL 'NaN'", "REAL '-NaN'")))).isEqualTo(Float.valueOf(Float.NaN));
    }

    @Test
    public void testModulus() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "REAL '12.34'", "REAL '56.78'")))).isEqualTo(Float.valueOf(12.34f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "REAL '-17.34'", "REAL '-22.891'")))).isEqualTo(Float.valueOf(-17.34f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "REAL '-89.123'", "REAL '754.0'")))).isEqualTo(Float.valueOf(-89.123f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "REAL '-0.0'", "REAL '0.0'")))).isEqualTo(Float.valueOf(Float.NaN));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "REAL '-17.71'", "REAL '-1.0'")))).isEqualTo(Float.valueOf(-0.7099991f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "REAL 'NaN'", "REAL '1.23'")))).isEqualTo(Float.valueOf(Float.NaN));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "REAL '1.23'", "REAL 'NaN'")))).isEqualTo(Float.valueOf(Float.NaN));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "REAL 'NaN'", "REAL 'NaN'")))).isEqualTo(Float.valueOf(Float.NaN));
    }

    @Test
    public void testNegation() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.NEGATION, "REAL '12.34'")))).isEqualTo(Float.valueOf(-12.34f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.NEGATION, "REAL '-17.34'")))).isEqualTo(Float.valueOf(17.34f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.NEGATION, "REAL '-0.0'")))).isEqualTo(Float.valueOf(0.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.NEGATION, "REAL 'NaN'")))).isEqualTo(Float.valueOf(Float.NaN));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.NEGATION, "REAL '-NaN'")))).isEqualTo(Float.valueOf(Float.NaN));
    }

    @Test
    public void testEqual() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "REAL '12.34'", "REAL '12.34'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "REAL '12.340'", "REAL '12.34'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "REAL '-17.34'", "REAL '-17.34'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "REAL '71.17'", "REAL '23.45'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "REAL '-0.0'", "REAL '0.0'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "REAL 'NaN'", "REAL '1.23'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "REAL '1.23'", "REAL 'NaN'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "REAL 'NaN'", "REAL 'NaN'")))).isEqualTo(false);
    }

    @Test
    public void testNotEqual() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "REAL '12.34'").binding("b", "REAL '12.34'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "REAL '12.34'").binding("b", "REAL '12.340'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "REAL '-17.34'").binding("b", "REAL '-17.34'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "REAL '71.17'").binding("b", "REAL '23.45'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "REAL '-0.0'").binding("b", "REAL '0.0'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "REAL 'NaN'").binding("b", "REAL '1.23'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "REAL '1.23'").binding("b", "REAL 'NaN'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "REAL 'NaN'").binding("b", "REAL 'NaN'")))).isEqualTo(true);
    }

    @Test
    public void testLessThan() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "REAL '12.34'", "REAL '754.123'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "REAL '-17.34'", "REAL '-16.34'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "REAL '71.17'", "REAL '23.45'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "REAL '-0.0'", "REAL '0.0'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "REAL 'NaN'", "REAL '1.23'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "REAL '1.23'", "REAL 'NaN'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "REAL 'NaN'", "REAL 'NaN'")))).isEqualTo(false);
    }

    @Test
    public void testLessThanOrEqual() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "REAL '12.34'", "REAL '754.123'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "REAL '-17.34'", "REAL '-17.34'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "REAL '71.17'", "REAL '23.45'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "REAL '-0.0'", "REAL '0.0'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "REAL 'NaN'", "REAL '1.23'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "REAL '1.23'", "REAL 'NaN'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "REAL 'NaN'", "REAL 'NaN'")))).isEqualTo(false);
    }

    @Test
    public void testGreaterThan() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "REAL '12.34'").binding("b", "REAL '754.123'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "REAL '-17.34'").binding("b", "REAL '-17.34'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "REAL '71.17'").binding("b", "REAL '23.45'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "REAL '-0.0'").binding("b", "REAL '0.0'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "REAL 'NaN'").binding("b", "REAL '1.23'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "REAL '1.23'").binding("b", "REAL 'NaN'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "REAL 'NaN'").binding("b", "REAL 'NaN'")))).isEqualTo(false);
    }

    @Test
    public void testGreaterThanOrEqual() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "REAL '12.34'").binding("b", "REAL '754.123'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "REAL '-17.34'").binding("b", "REAL '-17.34'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "REAL '71.17'").binding("b", "REAL '23.45'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "REAL '-0.0'").binding("b", "REAL '0.0'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "REAL 'NaN'").binding("b", "REAL '1.23'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "REAL '1.23'").binding("b", "REAL 'NaN'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "REAL 'NaN'").binding("b", "REAL 'NaN'")))).isEqualTo(false);
    }

    @Test
    public void testBetween() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "REAL '12.34'").binding("low", "REAL '9.12'").binding("high", "REAL '25.89'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "REAL '-17.34'").binding("low", "REAL '-17.34'").binding("high", "REAL '-16.57'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "REAL '-17.34'").binding("low", "REAL '-18.98'").binding("high", "REAL '-17.34'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "REAL '0.0'").binding("low", "REAL '-1.2'").binding("high", "REAL '2.3'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "REAL '56.78'").binding("low", "REAL '12.34'").binding("high", "REAL '34.56'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "REAL '56.78'").binding("low", "REAL '78.89'").binding("high", "REAL '98.765'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "REAL 'NaN'").binding("low", "REAL '-1.2'").binding("high", "REAL '2.3'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "REAL '56.78'").binding("low", "REAL '-NaN'").binding("high", "REAL 'NaN'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "REAL '56.78'").binding("low", "REAL 'NaN'").binding("high", "REAL '-NaN'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "REAL '56.78'").binding("low", "REAL '56.78'").binding("high", "REAL 'NaN'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "REAL 'NaN'").binding("low", "REAL 'NaN'").binding("high", "REAL 'NaN'")))).isEqualTo(false);
    }

    @Test
    public void testCastToVarchar() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as VARCHAR)").binding("a", "REAL '754.1985'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("7.541985E2");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as VARCHAR)").binding("a", "REAL '-754.2008'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("-7.542008E2");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as VARCHAR)").binding("a", "REAL 'Infinity'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("Infinity");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS VARCHAR)").binding("a", "CAST(nan() AS REAL)")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("NaN");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as varchar(6))").binding("a", "REAL '12e2'")))).hasType((Type)VarcharType.createVarcharType((int)6)).isEqualTo("1.2E3");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as varchar(50))").binding("a", "REAL '12e2'")))).hasType((Type)VarcharType.createVarcharType((int)50)).isEqualTo("1.2E3");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as varchar(50))").binding("a", "REAL '12345678.9e0'")))).hasType((Type)VarcharType.createVarcharType((int)50)).isEqualTo("1.234568E7");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as varchar(3))").binding("a", "REAL 'NaN'")))).hasType((Type)VarcharType.createVarcharType((int)3)).isEqualTo("NaN");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as varchar(50))").binding("a", "REAL 'Infinity'")))).hasType((Type)VarcharType.createVarcharType((int)50)).isEqualTo("Infinity");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as varchar(5))").binding("a", "REAL '12e2'")))).hasType((Type)VarcharType.createVarcharType((int)5)).isEqualTo("1.2E3");
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as varchar(4))").binding("a", "REAL '12e2'").evaluate()).hasMessage("Value 1200.0 (1.2E3) cannot be represented as varchar(4)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as varchar(2))").binding("a", "REAL '0e0'").evaluate()).hasMessage("Value 0.0 (0E0) cannot be represented as varchar(2)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as varchar(3))").binding("a", "REAL '-0e0'").evaluate()).hasMessage("Value -0.0 (-0E0) cannot be represented as varchar(3)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("CAST(a AS varchar(2))").binding("a", "nan()").evaluate()).hasMessage("Value NaN (NaN) cannot be represented as varchar(2)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as varchar(7))").binding("a", "REAL 'Infinity'").evaluate()).hasMessage("Value Infinity (Infinity) cannot be represented as varchar(7)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
    }

    @Test
    public void testCastToBigInt() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BIGINT)").binding("a", "REAL '754.1985'")))).isEqualTo(754L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BIGINT)").binding("a", "REAL '-754.2008'")))).isEqualTo(-754L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BIGINT)").binding("a", "REAL '1.98'")))).isEqualTo(2L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BIGINT)").binding("a", "REAL '-0.0'")))).isEqualTo(0L);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as BIGINT)").binding("a", "REAL 'NaN'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
    }

    @Test
    public void testCastToInteger() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as INTEGER)").binding("a", "REAL '754.2008'")))).isEqualTo(754);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as INTEGER)").binding("a", "REAL '-754.1985'")))).isEqualTo(-754);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as INTEGER)").binding("a", "REAL '9.99'")))).isEqualTo(10);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as INTEGER)").binding("a", "REAL '-0.0'")))).isEqualTo(0);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as INTEGER)").binding("a", "REAL 'NaN'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
    }

    @Test
    public void testCastToSmallint() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as SMALLINT)").binding("a", "REAL '754.2008'")))).isEqualTo((short)754);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as SMALLINT)").binding("a", "REAL '-754.1985'")))).isEqualTo((short)-754);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as SMALLINT)").binding("a", "REAL '9.99'")))).isEqualTo((short)10);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as SMALLINT)").binding("a", "REAL '-0.0'")))).isEqualTo((short)0);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as SMALLINT)").binding("a", "REAL 'NaN'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
    }

    @Test
    public void testCastToTinyint() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as TINYINT)").binding("a", "REAL '127.45'")))).isEqualTo((byte)127);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as TINYINT)").binding("a", "REAL '-128.234'")))).isEqualTo((byte)-128);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as TINYINT)").binding("a", "REAL '9.99'")))).isEqualTo((byte)10);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as TINYINT)").binding("a", "REAL '-0.0'")))).isEqualTo((byte)0);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as TINYINT)").binding("a", "REAL 'NaN'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
    }

    @Test
    public void testCastToDouble() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DOUBLE)").binding("a", "REAL '754.1985'")))).isEqualTo(754.198486328125);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DOUBLE)").binding("a", "REAL '-754.2008'")))).isEqualTo(-754.2008056640625);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DOUBLE)").binding("a", "REAL '0.0'")))).isEqualTo(0.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DOUBLE)").binding("a", "REAL '-0.0'")))).isEqualTo(-0.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DOUBLE)").binding("a", "REAL 'NaN'")))).isEqualTo(Double.NaN);
    }

    @Test
    public void testCastToBoolean() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BOOLEAN)").binding("a", "REAL '754.1985'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BOOLEAN)").binding("a", "REAL '0.0'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BOOLEAN)").binding("a", "REAL '-0.0'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BOOLEAN)").binding("a", "REAL 'NaN'")))).isEqualTo(true);
    }

    @Test
    public void testIdentical() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IDENTICAL, "CAST(NULL AS REAL)", "CAST(NULL AS REAL)")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IDENTICAL, "REAL '37.7'", "REAL '37.7'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IDENTICAL, "REAL '37.7'", "REAL '37.8'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IDENTICAL, "NULL", "REAL '37.7'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IDENTICAL, "REAL '37.7'", "NULL")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IDENTICAL, "CAST(nan() AS REAL)", "CAST(nan() AS REAL)")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IDENTICAL, "REAL 'NaN'", "REAL '37.8'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IDENTICAL, "REAL '37.8'", "REAL 'NaN'")))).isEqualTo(false);
    }

    @Test
    public void testIndeterminate() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "cast(null as real)")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "REAL '-1.2'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "REAL '1.2'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "REAL '123'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "REAL 'NaN'")))).isEqualTo(false);
    }

    @Test
    public void testNanHash() throws Throwable {
        int[] nanRepresentations;
        for (int nanRepresentation : nanRepresentations = new int[]{Float.floatToIntBits(Float.NaN), -4194304, 2143289344, 2143294004, -4189644}) {
            Assertions.assertThat((boolean)Float.isNaN(Float.intBitsToFloat(nanRepresentation))).isTrue();
            Assertions.assertThat((long)this.executeHashOperator(nanRepresentation)).isEqualTo(this.executeHashOperator(nanRepresentations[0]));
            Assertions.assertThat((long)this.executeXxHas64hOperator(nanRepresentation)).isEqualTo(this.executeXxHas64hOperator(nanRepresentations[0]));
        }
    }

    @Test
    public void testZeroHash() throws Throwable {
        int[] zeroes;
        for (int zero : zeroes = new int[]{Float.floatToIntBits(0.0f), Float.floatToIntBits(-0.0f)}) {
            Assertions.assertThat((float)Float.intBitsToFloat(zero)).isEqualTo(0.0f);
            Assertions.assertThat((long)this.executeHashOperator(zero)).isEqualTo(this.executeHashOperator(zeroes[0]));
            Assertions.assertThat((long)this.executeXxHas64hOperator(zero)).isEqualTo(this.executeXxHas64hOperator(zeroes[0]));
        }
    }

    private long executeHashOperator(long value) throws Throwable {
        MethodHandle hashCodeOperator = this.assertions.getQueryRunner().getPlannerContext().getTypeManager().getTypeOperators().getHashCodeOperator((Type)RealType.REAL, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL}));
        return hashCodeOperator.invokeExact((long)Float.intBitsToFloat((int)value));
    }

    private long executeXxHas64hOperator(long value) throws Throwable {
        MethodHandle xxHash64Operator = this.assertions.getQueryRunner().getPlannerContext().getTypeManager().getTypeOperators().getXxHash64Operator((Type)RealType.REAL, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL}));
        return xxHash64Operator.invokeExact((long)Float.intBitsToFloat((int)value));
    }
}

