/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.trino.Session;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.SessionPropertyManager;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.Type;
import io.trino.sql.PlannerContext;
import io.trino.sql.SqlEnvironmentConfig;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.QualifiedName;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import me.xdrop.fuzzywuzzy.FuzzySearch;

public class SessionPropertyEvaluator {
    private final PlannerContext plannerContext;
    private final AccessControl accessControl;
    private final SessionPropertyManager sessionPropertyManager;
    private final Optional<TimeZoneKey> forcedSessionTimeZone;

    @Inject
    public SessionPropertyEvaluator(PlannerContext plannerContext, AccessControl accessControl, SessionPropertyManager sessionPropertyManager, SqlEnvironmentConfig environmentConfig) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        this.forcedSessionTimeZone = Objects.requireNonNull(environmentConfig, "environmentConfig is null").getForcedSessionTimeZone();
    }

    public String evaluate(Session session, QualifiedName name, Expression expression, Map<NodeRef<Parameter>, Expression> parameters) {
        List nameParts = name.getParts();
        if (nameParts.size() == 1) {
            PropertyMetadata<?> systemPropertyMetadata = this.sessionPropertyManager.getSystemSessionPropertyMetadata((String)nameParts.getFirst()).orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, (Node)expression, "Session property '%s' does not exist%s", name, SessionPropertyEvaluator.suggest(name, this.sessionPropertyManager.getSystemSessionPropertiesMetadata())));
            return this.evaluate(session, name, expression, parameters, systemPropertyMetadata);
        }
        if (nameParts.size() == 2) {
            String catalogName = (String)nameParts.getFirst();
            String propertyName = (String)nameParts.getLast();
            CatalogHandle catalogHandle = MetadataUtil.getRequiredCatalogHandle(this.plannerContext.getMetadata(), session, (Node)expression, catalogName);
            PropertyMetadata<?> connectorPropertyMetadata = this.sessionPropertyManager.getConnectorSessionPropertyMetadata(catalogHandle, propertyName).orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, (Node)expression, "Session property '%s' does not exist%s", name, SessionPropertyEvaluator.suggest(name, this.sessionPropertyManager.getConnectionSessionPropertiesMetadata(catalogHandle))));
            return this.evaluate(session, name, expression, parameters, connectorPropertyMetadata);
        }
        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, (Node)expression, "Invalid session property '%s'", name);
    }

    private String evaluate(Session session, QualifiedName name, Expression expression, Map<NodeRef<Parameter>, Expression> parameters, PropertyMetadata<?> propertyMetadata) {
        Object objectValue;
        if (propertyMetadata.getName().equals("time_zone_id") && this.forcedSessionTimeZone.isPresent()) {
            return SessionPropertyManager.serializeSessionProperty(propertyMetadata.getSqlType(), this.forcedSessionTimeZone.get().toString());
        }
        Type type = propertyMetadata.getSqlType();
        try {
            objectValue = SessionPropertyManager.evaluatePropertyValue(expression, type, session, this.plannerContext, this.accessControl, parameters);
        }
        catch (TrinoException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("Unable to set session property '%s' to '%s': %s", name, expression, e.getRawMessage()));
        }
        String value = SessionPropertyManager.serializeSessionProperty(type, objectValue);
        try {
            propertyMetadata.decode(objectValue);
        }
        catch (RuntimeException e) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, (Node)expression, "%s", e.getMessage());
        }
        return value;
    }

    public static List<PropertyMetadata<?>> findSimilar(String propertyName, Set<PropertyMetadata<?>> candidates, int count) {
        return (List)candidates.stream().filter(property -> !property.isHidden()).map(candidate -> new Match((PropertyMetadata<?>)candidate, FuzzySearch.ratio((String)candidate.getName(), (String)propertyName))).filter(match -> match.ratio() > 75).sorted(Comparator.comparingInt(Match::ratio).reversed()).limit(count).map(Match::metadata).collect(ImmutableList.toImmutableList());
    }

    private static String suggest(QualifiedName propertyName, Set<PropertyMetadata<?>> knownProperties) {
        List<PropertyMetadata<?>> suggestions = SessionPropertyEvaluator.findSimilar(propertyName.getSuffix(), knownProperties, 3);
        if (suggestions.isEmpty()) {
            return "";
        }
        return ". Did you mean to use " + (switch (suggestions.size()) {
            case 3 -> "'" + SessionPropertyEvaluator.formatSuggestion(propertyName, suggestions.get(0)) + "', '" + SessionPropertyEvaluator.formatSuggestion(propertyName, suggestions.get(1)) + "' or '" + SessionPropertyEvaluator.formatSuggestion(propertyName, suggestions.get(2)) + "'?";
            case 2 -> "'" + SessionPropertyEvaluator.formatSuggestion(propertyName, suggestions.get(0)) + "' or '" + SessionPropertyEvaluator.formatSuggestion(propertyName, suggestions.get(1)) + "'?";
            default -> "'" + SessionPropertyEvaluator.formatSuggestion(propertyName, suggestions.get(0)) + "'?";
        });
    }

    private static String formatSuggestion(QualifiedName name, PropertyMetadata<?> suggestion) {
        if (name.getParts().size() == 2) {
            return (String)name.getParts().getFirst() + "." + suggestion.getName();
        }
        return suggestion.getName();
    }

    private record Match(PropertyMetadata<?> metadata, int ratio) {
        public Match {
            Objects.requireNonNull(metadata, "metadata is null");
            Verify.verify((ratio >= 0 && ratio < 100 ? 1 : 0) != 0, (String)"ratio must be in the [0, 100) range", (Object[])new Object[0]);
        }
    }
}

