/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.buffer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.trino.execution.buffer.PipelinedOutputBuffers;
import java.util.Objects;

public class PipelinedBufferInfo {
    private final PipelinedOutputBuffers.OutputBufferId bufferId;
    private final long rowsAdded;
    private final long pagesAdded;
    private final int bufferedPages;
    private final long bufferedBytes;
    private final long pagesSent;
    private final boolean finished;

    @JsonCreator
    public PipelinedBufferInfo(@JsonProperty(value="bufferId") PipelinedOutputBuffers.OutputBufferId bufferId, @JsonProperty(value="rowsAdded") long rowsAdded, @JsonProperty(value="pagesAdded") long pagesAdded, @JsonProperty(value="bufferedPages") int bufferedPages, @JsonProperty(value="bufferedBytes") long bufferedBytes, @JsonProperty(value="pagesSent") long pagesSent, @JsonProperty(value="finished") boolean finished) {
        this.bufferId = Objects.requireNonNull(bufferId, "bufferId is null");
        Preconditions.checkArgument((rowsAdded >= 0L ? 1 : 0) != 0, (Object)"rowsAdded must be >= 0");
        this.rowsAdded = rowsAdded;
        Preconditions.checkArgument((pagesAdded >= 0L ? 1 : 0) != 0, (Object)"pagesAdded must be >= 0");
        this.pagesAdded = pagesAdded;
        Preconditions.checkArgument((bufferedPages >= 0 ? 1 : 0) != 0, (Object)"bufferedPages must be >= 0");
        this.bufferedPages = bufferedPages;
        Preconditions.checkArgument((bufferedBytes >= 0L ? 1 : 0) != 0, (Object)"bufferedBytes must be >= 0");
        this.bufferedBytes = bufferedBytes;
        Preconditions.checkArgument((pagesSent >= 0L ? 1 : 0) != 0, (Object)"pagesSent must be >= 0");
        this.pagesSent = pagesSent;
        this.finished = finished;
    }

    @JsonProperty
    public PipelinedOutputBuffers.OutputBufferId getBufferId() {
        return this.bufferId;
    }

    @JsonProperty
    public long getRowsAdded() {
        return this.rowsAdded;
    }

    @JsonProperty
    public long getPagesAdded() {
        return this.pagesAdded;
    }

    @JsonProperty
    public int getBufferedPages() {
        return this.bufferedPages;
    }

    @JsonProperty
    public long getBufferedBytes() {
        return this.bufferedBytes;
    }

    @JsonProperty
    public long getPagesSent() {
        return this.pagesSent;
    }

    @JsonProperty
    public boolean isFinished() {
        return this.finished;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipelinedBufferInfo that = (PipelinedBufferInfo)o;
        return this.rowsAdded == that.rowsAdded && this.pagesAdded == that.pagesAdded && this.bufferedPages == that.bufferedPages && this.bufferedBytes == that.bufferedBytes && this.pagesSent == that.pagesSent && this.finished == that.finished && Objects.equals(this.bufferId, that.bufferId);
    }

    public int hashCode() {
        return Objects.hash(this.bufferId, this.rowsAdded, this.pagesAdded, this.bufferedPages, this.bufferedBytes, this.pagesSent, this.finished);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("bufferId", (Object)this.bufferId).add("rowsAdded", this.rowsAdded).add("pagesAdded", this.pagesAdded).add("bufferedPages", this.bufferedPages).add("bufferedBytes", this.bufferedBytes).add("pagesSent", this.pagesSent).add("finished", this.finished).toString();
    }
}

