/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.MoreFutures;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.memory.context.MemoryTrackingContext;
import io.trino.operator.ChannelSet;
import io.trino.operator.OperatorFactory;
import io.trino.operator.ProcessorContext;
import io.trino.operator.SetBuilderOperator;
import io.trino.operator.WorkProcessor;
import io.trino.operator.WorkProcessorOperator;
import io.trino.operator.WorkProcessorOperatorAdapter;
import io.trino.operator.WorkProcessorOperatorFactory;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.plan.PlanNodeId;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;

public class HashSemiJoinOperator
implements WorkProcessorOperator {
    private final WorkProcessor<Page> pages;

    public static OperatorFactory createOperatorFactory(int operatorId, PlanNodeId planNodeId, SetBuilderOperator.SetSupplier setSupplier, List<? extends Type> probeTypes, int probeJoinChannel, Optional<Integer> probeJoinHashChannel) {
        return WorkProcessorOperatorAdapter.createAdapterOperatorFactory(new Factory(operatorId, planNodeId, setSupplier, probeTypes, probeJoinChannel, probeJoinHashChannel));
    }

    private HashSemiJoinOperator(WorkProcessor<Page> sourcePages, SetBuilderOperator.SetSupplier channelSetFuture, int probeJoinChannel, Optional<Integer> probeHashChannel, MemoryTrackingContext memoryTrackingContext) {
        this.pages = sourcePages.transform(new SemiJoinPages(channelSetFuture, probeJoinChannel, probeHashChannel, memoryTrackingContext.aggregateUserMemoryContext()));
    }

    @Override
    public WorkProcessor<Page> getOutputPages() {
        return this.pages;
    }

    private static <T> ListenableFuture<Void> asVoid(ListenableFuture<T> future) {
        return Futures.transform(future, v -> null, (Executor)MoreExecutors.directExecutor());
    }

    private static class Factory
    implements WorkProcessorOperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final SetBuilderOperator.SetSupplier setSupplier;
        private final List<Type> probeTypes;
        private final int probeJoinChannel;
        private final Optional<Integer> probeJoinHashChannel;
        private boolean closed;

        private Factory(int operatorId, PlanNodeId planNodeId, SetBuilderOperator.SetSupplier setSupplier, List<? extends Type> probeTypes, int probeJoinChannel, Optional<Integer> probeJoinHashChannel) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.setSupplier = setSupplier;
            this.probeTypes = ImmutableList.copyOf(probeTypes);
            Preconditions.checkArgument((probeJoinChannel >= 0 ? 1 : 0) != 0, (Object)"probeJoinChannel is negative");
            this.probeJoinChannel = probeJoinChannel;
            this.probeJoinHashChannel = probeJoinHashChannel;
        }

        @Override
        public WorkProcessorOperator create(ProcessorContext processorContext, WorkProcessor<Page> sourcePages) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            return new HashSemiJoinOperator(sourcePages, this.setSupplier, this.probeJoinChannel, this.probeJoinHashChannel, processorContext.getMemoryTrackingContext());
        }

        @Override
        public int getOperatorId() {
            return this.operatorId;
        }

        @Override
        public PlanNodeId getPlanNodeId() {
            return this.planNodeId;
        }

        @Override
        public String getOperatorType() {
            return HashSemiJoinOperator.class.getSimpleName();
        }

        @Override
        public void close() {
            this.closed = true;
        }

        @Override
        public Factory duplicate() {
            return new Factory(this.operatorId, this.planNodeId, this.setSupplier, this.probeTypes, this.probeJoinChannel, this.probeJoinHashChannel);
        }
    }

    private static class SemiJoinPages
    implements WorkProcessor.Transformation<Page, Page> {
        private static final int NO_PRECOMPUTED_HASH_CHANNEL = -1;
        private final int probeJoinChannel;
        private final int probeHashChannel;
        private final ListenableFuture<ChannelSet> channelSetFuture;
        private final LocalMemoryContext localMemoryContext;
        @Nullable
        private ChannelSet channelSet;

        public SemiJoinPages(SetBuilderOperator.SetSupplier channelSetFuture, int probeJoinChannel, Optional<Integer> probeHashChannel, AggregatedMemoryContext aggregatedMemoryContext) {
            Preconditions.checkArgument((probeJoinChannel >= 0 ? 1 : 0) != 0, (Object)"probeJoinChannel is negative");
            this.channelSetFuture = channelSetFuture.getChannelSet();
            this.probeJoinChannel = probeJoinChannel;
            this.probeHashChannel = probeHashChannel.orElse(-1);
            this.localMemoryContext = aggregatedMemoryContext.newLocalMemoryContext(SemiJoinPages.class.getSimpleName());
        }

        @Override
        public WorkProcessor.TransformationState<Page> process(Page inputPage) {
            if (inputPage == null) {
                return WorkProcessor.TransformationState.finished();
            }
            if (this.channelSet == null) {
                if (!this.channelSetFuture.isDone()) {
                    this.localMemoryContext.setBytes(inputPage.getSizeInBytes());
                    return WorkProcessor.TransformationState.blocked(HashSemiJoinOperator.asVoid(this.channelSetFuture));
                }
                MoreFutures.checkSuccess(this.channelSetFuture, (String)"ChannelSet building failed");
                this.channelSet = (ChannelSet)MoreFutures.getFutureValue(this.channelSetFuture);
                this.localMemoryContext.setBytes(0L);
            }
            ChannelSet channelSet = Objects.requireNonNull(this.channelSet, "channelSet is null");
            BlockBuilder blockBuilder = BooleanType.BOOLEAN.createFixedSizeBlockBuilder(inputPage.getPositionCount());
            Block probeBlock = inputPage.getBlock(this.probeJoinChannel).copyRegion(0, inputPage.getPositionCount());
            boolean probeMayHaveNull = probeBlock.mayHaveNull();
            Block hashBlock = this.probeHashChannel >= 0 ? inputPage.getBlock(this.probeHashChannel).copyRegion(0, inputPage.getPositionCount()) : null;
            for (int position = 0; position < inputPage.getPositionCount(); ++position) {
                boolean contains;
                if (probeMayHaveNull && probeBlock.isNull(position)) {
                    if (channelSet.isEmpty()) {
                        BooleanType.BOOLEAN.writeBoolean(blockBuilder, false);
                        continue;
                    }
                    blockBuilder.appendNull();
                    continue;
                }
                if (hashBlock != null) {
                    long rawHash = BigintType.BIGINT.getLong(hashBlock, position);
                    contains = channelSet.contains(probeBlock, position, rawHash);
                } else {
                    contains = channelSet.contains(probeBlock, position);
                }
                if (!contains && channelSet.containsNull()) {
                    blockBuilder.appendNull();
                    continue;
                }
                BooleanType.BOOLEAN.writeBoolean(blockBuilder, contains);
            }
            return WorkProcessor.TransformationState.ofResult(inputPage.appendColumn(blockBuilder.build()));
        }
    }
}

