/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Verify;
import io.trino.operator.SpoolingController;

public class OperatorSpoolingController
implements SpoolingController {
    private long currentSpooledSegmentTarget;
    private final long maximumSpooledSegmentTarget;
    private final long maximumInlinedPositions;
    private final long maximumInlinedSize;
    private final ActionMetrics spooled = new ActionMetrics();
    private final ActionMetrics inlined = new ActionMetrics();
    private final ActionMetrics buffered = new ActionMetrics();
    private SpoolingController.Mode currentMode;

    public OperatorSpoolingController(boolean inlineInitialRows, long maximumInlinedPositions, long maximumInlinedSize, long initialSpooledSegmentTarget, long maximumSpooledSegmentTarget) {
        this.currentSpooledSegmentTarget = initialSpooledSegmentTarget;
        this.maximumSpooledSegmentTarget = maximumSpooledSegmentTarget;
        this.maximumInlinedPositions = maximumInlinedPositions;
        this.maximumInlinedSize = maximumInlinedSize;
        this.currentMode = inlineInitialRows ? SpoolingController.Mode.INLINE : SpoolingController.Mode.SPOOL;
    }

    @Override
    public SpoolingController.Mode nextMode(int positions, long size) {
        return switch (this.currentMode) {
            default -> throw new MatchException(null, null);
            case SpoolingController.Mode.INLINE -> {
                MetricSnapshot snapshot = this.inlined.snapshot();
                if (snapshot.positions() + (long)positions >= this.maximumInlinedPositions) {
                    this.currentMode = SpoolingController.Mode.SPOOL;
                    yield this.nextMode(positions, size);
                }
                if (snapshot.size() + size >= this.maximumInlinedSize) {
                    this.currentMode = SpoolingController.Mode.SPOOL;
                    yield this.nextMode(positions, size);
                }
                Verify.verify((boolean)this.buffered.isEmpty(), (String)"There should be no buffered pages when streaming", (Object[])new Object[0]);
                yield this.execute(SpoolingController.Mode.INLINE, positions, size);
            }
            case SpoolingController.Mode.SPOOL, SpoolingController.Mode.BUFFER -> {
                MetricSnapshot snapshot = this.buffered.snapshot();
                if (snapshot.size() + size >= this.currentSpooledSegmentTarget) {
                    yield this.execute(SpoolingController.Mode.SPOOL, positions, size);
                }
                yield this.execute(SpoolingController.Mode.BUFFER, positions, size);
            }
        };
    }

    @Override
    public SpoolingController.Mode execute(SpoolingController.Mode mode, long positions, long size) {
        this.currentMode = mode;
        switch (mode) {
            case BUFFER: {
                this.buffered.recordPage(positions, size);
                break;
            }
            case INLINE: {
                this.inlined.recordPage(positions, size);
                break;
            }
            case SPOOL: {
                MetricSnapshot snapshot = this.buffered.snapshot();
                this.buffered.reset();
                this.spooled.recordPage(positions + snapshot.positions(), size + snapshot.size());
                this.currentSpooledSegmentTarget = Math.min(this.currentSpooledSegmentTarget * 2L, this.maximumSpooledSegmentTarget);
            }
        }
        return this.currentMode;
    }

    public MetricSnapshot spooledMetrics() {
        return this.spooled.snapshot();
    }

    public MetricSnapshot inlinedMetrics() {
        return this.inlined.snapshot();
    }

    public MetricSnapshot bufferedMetrics() {
        return this.buffered.snapshot();
    }

    public long getCurrentSpooledSegmentTarget() {
        return this.currentSpooledSegmentTarget;
    }

    private static class ActionMetrics {
        private long pages;
        private long size;
        private long positions;

        private ActionMetrics() {
        }

        public void recordPage(long positions, long size) {
            Verify.verify((positions > 0L ? 1 : 0) != 0, (String)"Expected positions to be non-negative", (Object[])new Object[0]);
            Verify.verify((size > 0L ? 1 : 0) != 0, (String)"Expected size to be non-negative", (Object[])new Object[0]);
            ++this.pages;
            this.positions += positions;
            this.size += size;
        }

        public void reset() {
            this.pages = 0L;
            this.size = 0L;
            this.positions = 0L;
        }

        public boolean isEmpty() {
            return this.pages == 0L && this.size == 0L && this.positions == 0L;
        }

        public MetricSnapshot snapshot() {
            return new MetricSnapshot(this.positions, this.size, this.pages);
        }
    }

    public record MetricSnapshot(long positions, long size, long pages) {
        public MetricSnapshot {
            Verify.verify((positions >= 0L ? 1 : 0) != 0, (String)"Positions are expected to be non-negative", (Object[])new Object[0]);
            Verify.verify((size >= 0L ? 1 : 0) != 0, (String)"Size is expected to be non-negative", (Object[])new Object[0]);
            Verify.verify((pages >= 0L ? 1 : 0) != 0, (String)"Pages are expected to be non-negative", (Object[])new Object[0]);
        }
    }
}

