/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import io.trino.operator.OperatorInfo;
import io.trino.spi.Mergeable;
import io.trino.spi.connector.CatalogHandle;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SplitOperatorInfo
implements OperatorInfo,
Mergeable<SplitOperatorInfo> {
    private final CatalogHandle catalogHandle;
    private final Map<String, String> splitInfo;

    @JsonCreator
    public SplitOperatorInfo(@JsonProperty(value="catalogHandle") CatalogHandle catalogHandle, @JsonProperty(value="splitInfo") Map<String, String> splitInfo) {
        this.catalogHandle = Objects.requireNonNull(catalogHandle, "catalogHandle is null");
        this.splitInfo = splitInfo;
    }

    @Override
    public boolean isFinal() {
        return true;
    }

    @JsonProperty
    public Map<String, String> getSplitInfo() {
        return this.splitInfo;
    }

    @JsonProperty
    public CatalogHandle getCatalogHandle() {
        return this.catalogHandle;
    }

    public SplitOperatorInfo mergeWith(SplitOperatorInfo other) {
        return this.mergeWith((List)List.of(other));
    }

    public SplitOperatorInfo mergeWith(List<SplitOperatorInfo> others) {
        return new SplitOperatorInfo(this.catalogHandle, (Map)this.splitInfo.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> (String)e.getValue() + " (" + others.size() + " more)")));
    }
}

