/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.operator.AggregationMetrics;
import io.trino.operator.OperatorFactory;
import io.trino.operator.PagesHashStrategy;
import io.trino.operator.ProcessorContext;
import io.trino.operator.WorkProcessor;
import io.trino.operator.WorkProcessorOperator;
import io.trino.operator.WorkProcessorOperatorAdapter;
import io.trino.operator.WorkProcessorOperatorFactory;
import io.trino.operator.aggregation.Aggregator;
import io.trino.operator.aggregation.AggregatorFactory;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.metrics.Metrics;
import io.trino.spi.type.Type;
import io.trino.sql.gen.JoinCompiler;
import io.trino.sql.planner.plan.PlanNodeId;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public class StreamingAggregationOperator
implements WorkProcessorOperator {
    private final WorkProcessor<Page> pages;
    private final AggregationMetrics aggregationMetrics = new AggregationMetrics();

    public static OperatorFactory createOperatorFactory(int operatorId, PlanNodeId planNodeId, List<Type> sourceTypes, List<Type> groupByTypes, List<Integer> groupByChannels, List<AggregatorFactory> aggregatorFactories, JoinCompiler joinCompiler) {
        return WorkProcessorOperatorAdapter.createAdapterOperatorFactory(new Factory(operatorId, planNodeId, sourceTypes, groupByTypes, groupByChannels, aggregatorFactories, joinCompiler));
    }

    private StreamingAggregationOperator(ProcessorContext processorContext, WorkProcessor<Page> sourcePages, List<Type> sourceTypes, List<Type> groupByTypes, List<Integer> groupByChannels, List<AggregatorFactory> aggregatorFactories, JoinCompiler joinCompiler) {
        this.pages = sourcePages.transform(new StreamingAggregation(processorContext, sourceTypes, groupByTypes, groupByChannels, aggregatorFactories, joinCompiler, this.aggregationMetrics));
    }

    @Override
    public WorkProcessor<Page> getOutputPages() {
        return this.pages;
    }

    @Override
    public Metrics getMetrics() {
        return this.aggregationMetrics.getMetrics();
    }

    private static class Factory
    implements WorkProcessorOperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final List<Type> sourceTypes;
        private final List<Type> groupByTypes;
        private final List<Integer> groupByChannels;
        private final List<AggregatorFactory> aggregatorFactories;
        private final JoinCompiler joinCompiler;
        private boolean closed;

        private Factory(int operatorId, PlanNodeId planNodeId, List<Type> sourceTypes, List<Type> groupByTypes, List<Integer> groupByChannels, List<AggregatorFactory> aggregatorFactories, JoinCompiler joinCompiler) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.sourceTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(sourceTypes, "sourceTypes is null"));
            this.groupByTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(groupByTypes, "groupByTypes is null"));
            this.groupByChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(groupByChannels, "groupByChannels is null"));
            this.aggregatorFactories = ImmutableList.copyOf((Collection)Objects.requireNonNull(aggregatorFactories, "aggregatorFactories is null"));
            this.joinCompiler = Objects.requireNonNull(joinCompiler, "joinCompiler is null");
        }

        @Override
        public int getOperatorId() {
            return this.operatorId;
        }

        @Override
        public PlanNodeId getPlanNodeId() {
            return this.planNodeId;
        }

        @Override
        public String getOperatorType() {
            return StreamingAggregationOperator.class.getSimpleName();
        }

        @Override
        public WorkProcessorOperator create(ProcessorContext processorContext, WorkProcessor<Page> sourcePages) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            return new StreamingAggregationOperator(processorContext, sourcePages, this.sourceTypes, this.groupByTypes, this.groupByChannels, this.aggregatorFactories, this.joinCompiler);
        }

        @Override
        public void close() {
            this.closed = true;
        }

        @Override
        public Factory duplicate() {
            return new Factory(this.operatorId, this.planNodeId, this.sourceTypes, this.groupByTypes, this.groupByChannels, this.aggregatorFactories, this.joinCompiler);
        }
    }

    private static class StreamingAggregation
    implements WorkProcessor.Transformation<Page, Page> {
        private final LocalMemoryContext userMemoryContext;
        private final List<Type> groupByTypes;
        private final int[] groupByChannels;
        private final List<AggregatorFactory> aggregatorFactories;
        private final PagesHashStrategy pagesHashStrategy;
        private final AggregationMetrics aggregationMetrics;
        private List<Aggregator> aggregates;
        private final PageBuilder pageBuilder;
        private final Deque<Page> outputPages = new LinkedList<Page>();
        private Page currentGroup;

        private StreamingAggregation(ProcessorContext processorContext, List<Type> sourceTypes, List<Type> groupByTypes, List<Integer> groupByChannels, List<AggregatorFactory> aggregatorFactories, JoinCompiler joinCompiler, AggregationMetrics aggregationMetrics) {
            Objects.requireNonNull(processorContext, "processorContext is null");
            this.userMemoryContext = processorContext.getMemoryTrackingContext().localUserMemoryContext();
            this.groupByTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(groupByTypes, "groupByTypes is null"));
            this.groupByChannels = Ints.toArray((Collection)Objects.requireNonNull(groupByChannels, "groupByChannels is null"));
            this.aggregatorFactories = Objects.requireNonNull(aggregatorFactories, "aggregatorFactories is null");
            this.aggregates = (List)aggregatorFactories.stream().map(factory -> factory.createAggregator(aggregationMetrics)).collect(ImmutableList.toImmutableList());
            this.pageBuilder = new PageBuilder(StreamingAggregation.toTypes(groupByTypes, this.aggregates));
            Objects.requireNonNull(joinCompiler, "joinCompiler is null");
            Objects.requireNonNull(sourceTypes, "sourceTypes is null");
            this.pagesHashStrategy = joinCompiler.compilePagesHashStrategyFactory(sourceTypes, groupByChannels, Optional.empty()).createPagesHashStrategy((List)sourceTypes.stream().map(type -> new ObjectArrayList()).collect(ImmutableList.toImmutableList()), OptionalInt.empty());
            this.aggregationMetrics = Objects.requireNonNull(aggregationMetrics, "aggregationMetrics is null");
        }

        @Override
        public WorkProcessor.TransformationState<Page> process(@Nullable Page inputPage) {
            if (inputPage == null) {
                if (this.currentGroup != null) {
                    this.evaluateAndFlushGroup(this.currentGroup, 0);
                    this.currentGroup = null;
                }
                if (!this.pageBuilder.isEmpty()) {
                    this.outputPages.add(this.pageBuilder.build());
                    this.pageBuilder.reset();
                }
                if (this.outputPages.isEmpty()) {
                    return WorkProcessor.TransformationState.finished();
                }
                return WorkProcessor.TransformationState.ofResult(this.outputPages.removeFirst(), false);
            }
            if (!this.outputPages.isEmpty()) {
                Page outputPage = this.outputPages.removeFirst();
                return WorkProcessor.TransformationState.ofResult(outputPage, this.outputPages.isEmpty());
            }
            this.processInput(inputPage);
            this.updateMemoryUsage();
            if (this.outputPages.isEmpty()) {
                return WorkProcessor.TransformationState.needsMoreData();
            }
            Page outputPage = this.outputPages.removeFirst();
            return WorkProcessor.TransformationState.ofResult(outputPage, this.outputPages.isEmpty());
        }

        private void updateMemoryUsage() {
            long memorySize = this.pageBuilder.getRetainedSizeInBytes();
            for (Page output : this.outputPages) {
                memorySize += output.getRetainedSizeInBytes();
            }
            for (Aggregator aggregator : this.aggregates) {
                memorySize += aggregator.getEstimatedSize();
            }
            if (this.currentGroup != null) {
                memorySize += this.currentGroup.getRetainedSizeInBytes();
            }
            this.userMemoryContext.setBytes(memorySize);
        }

        private void processInput(Page page) {
            Objects.requireNonNull(page, "page is null");
            Page groupByPage = page.getColumns(this.groupByChannels);
            if (this.currentGroup != null) {
                if (!this.pagesHashStrategy.rowIdenticalToRow(0, this.currentGroup.getColumns(this.groupByChannels), 0, groupByPage)) {
                    this.evaluateAndFlushGroup(this.currentGroup, 0);
                }
                this.currentGroup = null;
            }
            int startPosition = 0;
            while (true) {
                int nextGroupStart = this.findNextGroupStart(startPosition, groupByPage);
                this.addRowsToAggregates(page, startPosition, nextGroupStart - 1);
                if (nextGroupStart >= page.getPositionCount()) break;
                this.evaluateAndFlushGroup(page, startPosition);
                startPosition = nextGroupStart;
            }
            this.currentGroup = page.getRegion(page.getPositionCount() - 1, 1).getLoadedPage();
        }

        private void addRowsToAggregates(Page page, int startPosition, int endPosition) {
            Page region = page.getRegion(startPosition, endPosition - startPosition + 1);
            for (Aggregator aggregator : this.aggregates) {
                aggregator.processPage(region);
            }
        }

        private void evaluateAndFlushGroup(Page page, int position) {
            this.pageBuilder.declarePosition();
            for (int i = 0; i < this.groupByTypes.size(); ++i) {
                Block block = page.getBlock(this.groupByChannels[i]);
                Type type = this.groupByTypes.get(i);
                type.appendTo(block, position, this.pageBuilder.getBlockBuilder(i));
            }
            int offset = this.groupByTypes.size();
            for (int i = 0; i < this.aggregates.size(); ++i) {
                this.aggregates.get(i).evaluate(this.pageBuilder.getBlockBuilder(offset + i));
            }
            if (this.pageBuilder.isFull()) {
                this.outputPages.add(this.pageBuilder.build());
                this.pageBuilder.reset();
            }
            this.aggregates = (List)this.aggregatorFactories.stream().map(factory -> factory.createAggregator(this.aggregationMetrics)).collect(ImmutableList.toImmutableList());
        }

        private int findNextGroupStart(int startPosition, Page page) {
            for (int i = startPosition + 1; i < page.getPositionCount(); ++i) {
                if (this.pagesHashStrategy.rowIdenticalToRow(startPosition, page, i, page)) continue;
                return i;
            }
            return page.getPositionCount();
        }

        private static List<Type> toTypes(List<Type> groupByTypes, List<Aggregator> aggregates) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll(groupByTypes);
            aggregates.stream().map(Aggregator::getType).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
            return builder.build();
        }
    }
}

