/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.table;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.SizeOf;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.FixedSplitSource;
import io.trino.spi.function.table.AbstractConnectorTableFunction;
import io.trino.spi.function.table.Argument;
import io.trino.spi.function.table.ConnectorTableFunctionHandle;
import io.trino.spi.function.table.Descriptor;
import io.trino.spi.function.table.ReturnTypeSpecification;
import io.trino.spi.function.table.ScalarArgument;
import io.trino.spi.function.table.ScalarArgumentSpecification;
import io.trino.spi.function.table.TableFunctionAnalysis;
import io.trino.spi.function.table.TableFunctionProcessorProvider;
import io.trino.spi.function.table.TableFunctionProcessorState;
import io.trino.spi.function.table.TableFunctionSplitProcessor;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;

public class SequenceFunction
extends AbstractConnectorTableFunction {
    public static final String NAME = "sequence";
    private static final String START_ARGUMENT_NAME = "START";
    private static final String STOP_ARGUMENT_NAME = "STOP";
    private static final String STEP_ARGUMENT_NAME = "STEP";

    public SequenceFunction() {
        super("builtin", NAME, (List)ImmutableList.of((Object)ScalarArgumentSpecification.builder().name(START_ARGUMENT_NAME).type((Type)BigintType.BIGINT).defaultValue((Object)0L).build(), (Object)ScalarArgumentSpecification.builder().name(STOP_ARGUMENT_NAME).type((Type)BigintType.BIGINT).build(), (Object)ScalarArgumentSpecification.builder().name(STEP_ARGUMENT_NAME).type((Type)BigintType.BIGINT).defaultValue((Object)1L).build()), (ReturnTypeSpecification)new ReturnTypeSpecification.DescribedTable(Descriptor.descriptor((List)ImmutableList.of((Object)"sequential_number"), (List)ImmutableList.of((Object)BigintType.BIGINT))));
    }

    public TableFunctionAnalysis analyze(ConnectorSession session, ConnectorTransactionHandle transaction, Map<String, Argument> arguments, ConnectorAccessControl accessControl) {
        Object startValue = ((ScalarArgument)arguments.get(START_ARGUMENT_NAME)).getValue();
        if (startValue == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Start is null");
        }
        Object stopValue = ((ScalarArgument)arguments.get(STOP_ARGUMENT_NAME)).getValue();
        if (stopValue == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Stop is null");
        }
        Object stepValue = ((ScalarArgument)arguments.get(STEP_ARGUMENT_NAME)).getValue();
        if (stepValue == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Step is null");
        }
        long start = (Long)startValue;
        long stop = (Long)stopValue;
        long step = (Long)stepValue;
        if (start < stop && step <= 0L) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Step must be positive for sequence [%s, %s]", start, stop));
        }
        if (start > stop && step >= 0L) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Step must be negative for sequence [%s, %s]", start, stop));
        }
        return TableFunctionAnalysis.builder().handle((ConnectorTableFunctionHandle)new SequenceFunctionHandle(start, stop, start == stop ? 0L : step)).build();
    }

    public static ConnectorSplitSource getSequenceFunctionSplitSource(SequenceFunctionHandle handle) {
        BigInteger start = BigInteger.valueOf(handle.start());
        BigInteger stop = BigInteger.valueOf(handle.stop());
        BigInteger step = BigInteger.valueOf(handle.step());
        if (step.equals(BigInteger.ZERO)) {
            Preconditions.checkArgument((boolean)start.equals(stop), (Object)"start is not equal to stop for step = 0");
            return new FixedSplitSource((Iterable)ImmutableList.of((Object)new SequenceFunctionSplit(start.longValueExact(), stop.longValueExact())));
        }
        ImmutableList.Builder splits = ImmutableList.builder();
        BigInteger totalSteps = stop.subtract(start).divide(step).add(BigInteger.ONE);
        BigInteger totalSplits = totalSteps.divide(BigInteger.valueOf(1000000L)).add(BigInteger.ONE);
        BigInteger[] stepsPerSplit = totalSteps.divideAndRemainder(totalSplits);
        BigInteger splitJump = stepsPerSplit[0].subtract(BigInteger.ONE).multiply(step);
        BigInteger splitStart = start;
        BigInteger i = BigInteger.ZERO;
        while (i.compareTo(totalSplits) < 0) {
            BigInteger splitStop = splitStart.add(splitJump);
            if (i.compareTo(stepsPerSplit[1]) < 0) {
                splitStop = splitStop.add(step);
            }
            splits.add((Object)new SequenceFunctionSplit(splitStart.longValueExact(), splitStop.longValueExact()));
            splitStart = splitStop.add(step);
            i = i.add(BigInteger.ONE);
        }
        return new FixedSplitSource((Iterable)splits.build());
    }

    public static TableFunctionProcessorProvider getSequenceFunctionProcessorProvider() {
        return new TableFunctionProcessorProvider(){

            public TableFunctionSplitProcessor getSplitProcessor(ConnectorSession session, ConnectorTableFunctionHandle handle, ConnectorSplit split) {
                return new SequenceFunctionProcessor(((SequenceFunctionHandle)handle).step(), (SequenceFunctionSplit)split);
            }
        };
    }

    public static class SequenceFunctionSplit
    implements ConnectorSplit {
        private static final int INSTANCE_SIZE = SizeOf.instanceSize(SequenceFunctionSplit.class);
        public static final int DEFAULT_SPLIT_SIZE = 1000000;
        public static final int MAX_SPLIT_SIZE = 1000000;
        private final long start;
        private final long stop;

        @JsonCreator
        public SequenceFunctionSplit(@JsonProperty(value="start") long start, @JsonProperty(value="stop") long stop) {
            this.start = start;
            this.stop = stop;
        }

        @JsonProperty
        public long getStart() {
            return this.start;
        }

        @JsonProperty
        public long getStop() {
            return this.stop;
        }

        public Map<String, String> getSplitInfo() {
            return ImmutableMap.builder().put((Object)"start", (Object)String.valueOf(this.start)).put((Object)"stop", (Object)String.valueOf(this.stop)).buildOrThrow();
        }

        public long getRetainedSizeInBytes() {
            return INSTANCE_SIZE;
        }
    }

    public record SequenceFunctionHandle(long start, long stop, long step) implements ConnectorTableFunctionHandle
    {
    }

    public static class SequenceFunctionProcessor
    implements TableFunctionSplitProcessor {
        private final PageBuilder pageBuilder = new PageBuilder((List)ImmutableList.of((Object)BigintType.BIGINT));
        private final long step;
        private long start;
        private final long stop;
        private boolean finished;

        public SequenceFunctionProcessor(long step, SequenceFunctionSplit split) {
            this.step = step;
            this.start = split.getStart();
            this.stop = split.getStop();
        }

        public TableFunctionProcessorState process() {
            Preconditions.checkState((boolean)this.pageBuilder.isEmpty(), (Object)"page builder not empty");
            if (this.finished) {
                return TableFunctionProcessorState.Finished.FINISHED;
            }
            BlockBuilder block = this.pageBuilder.getBlockBuilder(0);
            while (this.start != this.stop && !this.pageBuilder.isFull()) {
                this.pageBuilder.declarePosition();
                BigintType.BIGINT.writeLong(block, this.start);
                this.start += this.step;
            }
            if (!this.pageBuilder.isFull()) {
                this.pageBuilder.declarePosition();
                BigintType.BIGINT.writeLong(block, this.start);
                this.finished = true;
            }
            Page page = this.pageBuilder.build();
            this.pageBuilder.reset();
            return TableFunctionProcessorState.Processed.produced((Page)page);
        }
    }
}

