/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol;

import com.google.inject.Inject;
import io.trino.Session;
import io.trino.server.protocol.JsonBytesQueryDataProducer;
import io.trino.server.protocol.QueryDataProducer;
import io.trino.server.protocol.spooling.QueryDataEncoders;
import io.trino.server.protocol.spooling.SpoolingQueryDataProducer;
import java.util.Objects;

public class QueryDataProducerFactory {
    private final QueryDataEncoders encoders;

    @Inject
    public QueryDataProducerFactory(QueryDataEncoders encoders) {
        this.encoders = Objects.requireNonNull(encoders, "encoders is null");
    }

    public QueryDataProducer create(Session session) {
        if (session.getQueryDataEncoding().isEmpty()) {
            return new JsonBytesQueryDataProducer();
        }
        return new SpoolingQueryDataProducer(this.encoders.get(session.getQueryDataEncoding().get()));
    }
}

