/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol.spooling;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.units.DataSize;
import io.airlift.units.MaxDataSize;
import io.airlift.units.MinDataSize;

public class QueryDataEncodingConfig {
    private boolean jsonEnabled = true;
    private boolean jsonZstdEnabled = true;
    private boolean jsonLz4Enabled = true;
    private DataSize compressionThreshold = DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.KILOBYTE);

    public boolean isJsonEnabled() {
        return this.jsonEnabled;
    }

    @Config(value="protocol.spooling.encoding.json.enabled")
    @ConfigDescription(value="Enable uncompressed json spooled encoding")
    public QueryDataEncodingConfig setJsonEnabled(boolean jsonEnabled) {
        this.jsonEnabled = jsonEnabled;
        return this;
    }

    public boolean isJsonZstdEnabled() {
        return this.jsonZstdEnabled;
    }

    @Config(value="protocol.spooling.encoding.json+zstd.enabled")
    @ConfigDescription(value="Enable Zstd compressed json spooled encoding")
    public QueryDataEncodingConfig setJsonZstdEnabled(boolean jsonZstdEnabled) {
        this.jsonZstdEnabled = jsonZstdEnabled;
        return this;
    }

    public boolean isJsonLz4Enabled() {
        return this.jsonLz4Enabled;
    }

    @Config(value="protocol.spooling.encoding.json+lz4.enabled")
    @ConfigDescription(value="Enable LZ4 compressed json spooled encoding")
    public QueryDataEncodingConfig setJsonLz4Enabled(boolean jsonLz4Enabled) {
        this.jsonLz4Enabled = jsonLz4Enabled;
        return this;
    }

    @MinDataSize(value="1kB")
    @MaxDataSize(value="4MB")
    public @MinDataSize(value="1kB") @MaxDataSize(value="4MB") DataSize getCompressionThreshold() {
        return this.compressionThreshold;
    }

    @Config(value="protocol.spooling.encoding.compression.threshold")
    @ConfigDescription(value="Do not compress segments smaller than threshold")
    public QueryDataEncodingConfig setCompressionThreshold(DataSize compressionThreshold) {
        this.compressionThreshold = compressionThreshold;
        return this;
    }
}

