/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol.spooling.encoding;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.io.CountingOutputStream;
import com.google.inject.Inject;
import io.trino.Session;
import io.trino.client.spooling.DataAttribute;
import io.trino.client.spooling.DataAttributes;
import io.trino.plugin.base.util.JsonUtils;
import io.trino.server.protocol.JsonEncodingUtils;
import io.trino.server.protocol.OutputColumn;
import io.trino.server.protocol.spooling.QueryDataEncoder;
import io.trino.server.protocol.spooling.QueryDataEncodingConfig;
import io.trino.server.protocol.spooling.encoding.Lz4QueryDataEncoder;
import io.trino.server.protocol.spooling.encoding.ZstdQueryDataEncoder;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;

public class JsonQueryDataEncoder
implements QueryDataEncoder {
    private boolean closed;
    private static final JsonFactory JSON_FACTORY = JsonUtils.jsonFactory();
    private static final String ENCODING = "json";
    private final Session session;
    private JsonEncodingUtils.TypeEncoder[] typeEncoders;
    private int[] sourcePageChannels;

    public JsonQueryDataEncoder(Session session, List<OutputColumn> columns) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.typeEncoders = JsonEncodingUtils.createTypeEncoders(session, Objects.requireNonNull(columns, "columns is null"));
        this.sourcePageChannels = Objects.requireNonNull(columns, "columns is null").stream().mapToInt(OutputColumn::sourcePageChannel).toArray();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public DataAttributes encodeTo(OutputStream output, List<Page> pages) throws IOException {
        Verify.verify((!this.closed ? 1 : 0) != 0, (String)"JsonQueryDataEncoder is already closed", (Object[])new Object[0]);
        ConnectorSession connectorSession = this.session.toConnectorSession();
        try (CountingOutputStream wrapper = new CountingOutputStream(output);){
            DataAttributes dataAttributes;
            block13: {
                JsonGenerator generator = JSON_FACTORY.createGenerator((OutputStream)wrapper);
                try {
                    JsonEncodingUtils.writePagesToJsonGenerator(connectorSession, e -> {
                        throw e;
                    }, generator, this.typeEncoders, this.sourcePageChannels, pages);
                    dataAttributes = DataAttributes.builder().set(DataAttribute.SEGMENT_SIZE, (Object)Math.toIntExact(wrapper.getCount())).build();
                    if (generator == null) break block13;
                }
                catch (Throwable throwable) {
                    if (generator != null) {
                        try {
                            generator.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                generator.close();
            }
            return dataAttributes;
        }
        catch (Exception e2) {
            Throwables.throwIfInstanceOf((Throwable)e2, TrinoException.class);
            throw new IOException("Could not serialize to JSON", e2);
        }
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.typeEncoders = null;
        this.sourcePageChannels = null;
        this.closed = true;
    }

    @Override
    public String encoding() {
        return ENCODING;
    }

    public static class Lz4Factory
    extends Factory {
        private final int compressionThreshold;

        @Inject
        public Lz4Factory(QueryDataEncodingConfig config) {
            this.compressionThreshold = Math.toIntExact(config.getCompressionThreshold().toBytes());
        }

        @Override
        public QueryDataEncoder create(Session session, List<OutputColumn> columns) {
            return new Lz4QueryDataEncoder(super.create(session, columns), this.compressionThreshold);
        }

        @Override
        public String encoding() {
            return super.encoding() + "+lz4";
        }
    }

    public static class ZstdFactory
    extends Factory {
        private final int compressionThreshold;

        @Inject
        public ZstdFactory(QueryDataEncodingConfig config) {
            this.compressionThreshold = Math.toIntExact(config.getCompressionThreshold().toBytes());
        }

        @Override
        public QueryDataEncoder create(Session session, List<OutputColumn> columns) {
            return new ZstdQueryDataEncoder(super.create(session, columns), this.compressionThreshold);
        }

        @Override
        public String encoding() {
            return super.encoding() + "+zstd";
        }
    }

    public static class Factory
    implements QueryDataEncoder.Factory {
        protected final JsonFactory factory = JsonUtils.jsonFactory();

        @Inject
        public Factory() {
        }

        @Override
        public QueryDataEncoder create(Session session, List<OutputColumn> columns) {
            return new JsonQueryDataEncoder(session, columns);
        }

        @Override
        public String encoding() {
            return JsonQueryDataEncoder.ENCODING;
        }
    }
}

