/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.analyzer;

import io.trino.metadata.ResolvedFunction;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.function.FunctionKind;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.DefaultExpressionTraversalVisitor;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.Node;
import java.util.Objects;
import java.util.Optional;

class WindowFunctionValidator
extends DefaultExpressionTraversalVisitor<Analysis> {
    WindowFunctionValidator() {
    }

    protected Void visitFunctionCall(FunctionCall functionCall, Analysis analysis) {
        Optional<ResolvedFunction> resolvedFunction;
        Objects.requireNonNull(analysis, "analysis is null");
        if (!analysis.isPatternRecognitionFunction(functionCall) && (resolvedFunction = analysis.getResolvedFunction((Node)functionCall)).isPresent() && functionCall.getWindow().isEmpty() && resolvedFunction.get().functionKind() == FunctionKind.WINDOW) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_OVER, (Node)functionCall, "Window function %s requires an OVER clause", resolvedFunction.get().signature().getName());
        }
        return super.visitFunctionCall(functionCall, (Object)analysis);
    }
}

