/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableList;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.IrVisitor;
import java.util.List;

@JsonSerialize
public record Between(Expression value, Expression min, Expression max) implements Expression
{
    @JsonCreator
    public Between {
        IrUtils.validateType(value.type(), min);
        IrUtils.validateType(value.type(), max);
    }

    @Override
    public Type type() {
        return BooleanType.BOOLEAN;
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitBetween(this, context);
    }

    @Override
    public List<? extends Expression> children() {
        return ImmutableList.of((Object)this.value, (Object)this.min, (Object)this.max);
    }

    @Override
    public String toString() {
        return "Between(%s, %s, %s)".formatted(this.value, this.min, this.max);
    }
}

