/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer.rule;

import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Logical;
import io.trino.sql.ir.optimizer.IrOptimizerRule;
import io.trino.sql.planner.Symbol;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class FlattenLogical
implements IrOptimizerRule {
    @Override
    public Optional<Expression> apply(Expression expression, Session session, Map<Symbol, Expression> bindings) {
        if (!(expression instanceof Logical)) {
            return Optional.empty();
        }
        Logical logical = (Logical)expression;
        if (logical.terms().stream().noneMatch(e -> {
            Logical inner;
            return e instanceof Logical && (inner = (Logical)e).operator() == logical.operator();
        })) {
            return Optional.empty();
        }
        ImmutableList.Builder terms = ImmutableList.builder();
        this.flatten(logical.operator(), logical.terms(), (ImmutableList.Builder<Expression>)terms);
        return Optional.of(new Logical(logical.operator(), (List<Expression>)terms.build()));
    }

    private void flatten(Logical.Operator operator, List<Expression> terms, ImmutableList.Builder<Expression> accumulator) {
        for (Expression term : terms) {
            Logical logical;
            if (term instanceof Logical && (logical = (Logical)term).operator() == operator) {
                this.flatten(operator, logical.terms(), accumulator);
                continue;
            }
            accumulator.add((Object)term);
        }
    }
}

