/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.trino.spi.type.RowType;
import io.trino.sql.ir.DefaultTraversalVisitor;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FieldReference;
import io.trino.sql.ir.Lambda;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolsExtractor;
import java.util.Collection;
import java.util.List;
import java.util.Set;

class DereferencePushdown {
    private DereferencePushdown() {
    }

    public static Set<FieldReference> extractRowSubscripts(Collection<Expression> expressions, boolean allowOverlap) {
        Set symbolReferencesAndRowSubscripts;
        Set candidateExpressions = symbolReferencesAndRowSubscripts = (Set)expressions.stream().flatMap(expression -> DereferencePushdown.getSymbolReferencesAndRowSubscripts(expression).stream()).collect(ImmutableSet.toImmutableSet());
        if (!allowOverlap) {
            candidateExpressions = (Set)symbolReferencesAndRowSubscripts.stream().filter(expression -> !DereferencePushdown.prefixExists(expression, symbolReferencesAndRowSubscripts)).collect(ImmutableSet.toImmutableSet());
        }
        return (Set)candidateExpressions.stream().filter(FieldReference.class::isInstance).map(FieldReference.class::cast).collect(ImmutableSet.toImmutableSet());
    }

    public static boolean exclusiveDereferences(Set<Expression> projections) {
        return projections.stream().allMatch(expression -> {
            FieldReference fieldReference;
            return expression instanceof Reference || expression instanceof FieldReference && DereferencePushdown.isRowSubscriptChain(fieldReference = (FieldReference)expression) && !DereferencePushdown.prefixExists(expression, projections);
        });
    }

    public static Symbol getBase(FieldReference expression) {
        return (Symbol)Iterables.getOnlyElement(SymbolsExtractor.extractAll(expression));
    }

    private static List<Expression> getSymbolReferencesAndRowSubscripts(Expression expression) {
        ImmutableList.Builder builder = ImmutableList.builder();
        new DefaultTraversalVisitor<ImmutableList.Builder<Expression>>(){

            @Override
            protected Void visitFieldReference(FieldReference node, ImmutableList.Builder<Expression> context) {
                if (DereferencePushdown.isRowSubscriptChain(node)) {
                    context.add((Object)node);
                }
                return null;
            }

            @Override
            protected Void visitReference(Reference node, ImmutableList.Builder<Expression> context) {
                context.add((Object)node);
                return null;
            }

            @Override
            protected Void visitLambda(Lambda node, ImmutableList.Builder<Expression> context) {
                return null;
            }
        }.process(expression, builder);
        return builder.build();
    }

    private static boolean isRowSubscriptChain(FieldReference expression) {
        FieldReference fieldReference;
        Expression expression2;
        if (!(expression.base().type() instanceof RowType)) {
            return false;
        }
        return expression.base() instanceof Reference || (expression2 = expression.base()) instanceof FieldReference && DereferencePushdown.isRowSubscriptChain(fieldReference = (FieldReference)expression2);
    }

    private static boolean prefixExists(Expression expression, Set<Expression> expressions) {
        Expression current = expression;
        while (current instanceof FieldReference) {
            FieldReference fieldReference = (FieldReference)current;
            if (!expressions.contains(current = fieldReference.base())) continue;
            return true;
        }
        Verify.verify((boolean)(current instanceof Reference));
        return false;
    }
}

