/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import com.google.common.base.Preconditions;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.optimizations.PlanNodeSearcher;
import io.trino.sql.planner.optimizations.PlanOptimizer;
import io.trino.sql.planner.plan.ApplyNode;
import io.trino.sql.planner.plan.CorrelatedJoinNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.Node;
import java.util.List;

public class CheckSubqueryNodesAreRewritten
implements PlanOptimizer {
    @Override
    public PlanNode optimize(PlanNode plan, PlanOptimizer.Context context) {
        PlanNodeSearcher.searchFrom(plan).where(ApplyNode.class::isInstance).findFirst().ifPresent(node -> {
            ApplyNode applyNode = (ApplyNode)node;
            throw this.error(applyNode.getCorrelation(), applyNode.getOriginSubquery());
        });
        PlanNodeSearcher.searchFrom(plan).where(CorrelatedJoinNode.class::isInstance).findFirst().ifPresent(node -> {
            CorrelatedJoinNode correlatedJoinNode = (CorrelatedJoinNode)node;
            throw this.error(correlatedJoinNode.getCorrelation(), correlatedJoinNode.getOriginSubquery());
        });
        return plan;
    }

    private TrinoException error(List<Symbol> correlation, Node originSubquery) {
        Preconditions.checkState((!correlation.isEmpty() ? 1 : 0) != 0, (Object)"All the non correlated subqueries should be rewritten at this point");
        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, originSubquery, "Given correlated subquery is not supported", new Object[0]);
    }
}

