/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import io.trino.operator.RetryPolicy;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.PlanFragmentId;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.PlanVisitor;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class RemoteSourceNode
extends PlanNode {
    private final List<PlanFragmentId> sourceFragmentIds;
    private final List<Symbol> outputs;
    private final Optional<OrderingScheme> orderingScheme;
    private final ExchangeNode.Type exchangeType;
    private final RetryPolicy retryPolicy;

    @JsonCreator
    public RemoteSourceNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="sourceFragmentIds") List<PlanFragmentId> sourceFragmentIds, @JsonProperty(value="outputs") List<Symbol> outputs, @JsonProperty(value="orderingScheme") Optional<OrderingScheme> orderingScheme, @JsonProperty(value="exchangeType") ExchangeNode.Type exchangeType, @JsonProperty(value="retryPolicy") RetryPolicy retryPolicy) {
        super(id);
        Objects.requireNonNull(outputs, "outputs is null");
        this.sourceFragmentIds = sourceFragmentIds;
        this.outputs = ImmutableList.copyOf(outputs);
        this.orderingScheme = Objects.requireNonNull(orderingScheme, "orderingScheme is null");
        this.exchangeType = Objects.requireNonNull(exchangeType, "exchangeType is null");
        this.retryPolicy = Objects.requireNonNull(retryPolicy, "retryPolicy is null");
    }

    public RemoteSourceNode(PlanNodeId id, PlanFragmentId sourceFragmentId, List<Symbol> outputs, Optional<OrderingScheme> orderingScheme, ExchangeNode.Type exchangeType, RetryPolicy retryPolicy) {
        this(id, (List<PlanFragmentId>)ImmutableList.of((Object)sourceFragmentId), outputs, orderingScheme, exchangeType, retryPolicy);
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of();
    }

    @Override
    @JsonProperty(value="outputs")
    public List<Symbol> getOutputSymbols() {
        return this.outputs;
    }

    @JsonProperty(value="sourceFragmentIds")
    public List<PlanFragmentId> getSourceFragmentIds() {
        return this.sourceFragmentIds;
    }

    @JsonProperty(value="orderingScheme")
    public Optional<OrderingScheme> getOrderingScheme() {
        return this.orderingScheme;
    }

    @JsonProperty(value="exchangeType")
    public ExchangeNode.Type getExchangeType() {
        return this.exchangeType;
    }

    @JsonProperty(value="retryPolicy")
    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitRemoteSource(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Preconditions.checkArgument((boolean)newChildren.isEmpty(), (Object)"newChildren is not empty");
        return this;
    }

    public RemoteSourceNode withSourceFragmentIds(List<PlanFragmentId> sourceFragmentIds) {
        return new RemoteSourceNode(this.getId(), sourceFragmentIds, this.getOutputSymbols(), this.getOrderingScheme(), this.getExchangeType(), this.getRetryPolicy());
    }
}

