/*
 * Decompiled with CFR 0.152.
 */
package io.trino.block;

import io.airlift.slice.Slice;
import io.trino.block.AbstractTestBlock;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ByteArrayBlockBuilder;
import io.trino.spi.block.IntArrayBlockBuilder;
import io.trino.spi.block.LongArrayBlockBuilder;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.ShortArrayBlockBuilder;
import io.trino.spi.block.VariableWidthBlock;
import io.trino.spi.block.VariableWidthBlockBuilder;
import java.util.OptionalInt;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRunLengthEncodedBlock
extends AbstractTestBlock {
    @Test
    public void test() {
        for (int positionCount = 0; positionCount < 10; ++positionCount) {
            this.assertRleBlock(positionCount);
        }
    }

    private void assertRleBlock(int positionCount) {
        Slice expectedValue = TestRunLengthEncodedBlock.createExpectedValue(0);
        Block block = RunLengthEncodedBlock.create((Block)TestRunLengthEncodedBlock.createSingleValueBlock(expectedValue), (int)positionCount);
        Slice[] expectedValues = new Slice[positionCount];
        for (int position = 0; position < positionCount; ++position) {
            expectedValues[position] = expectedValue;
        }
        this.assertBlock(block, expectedValues);
    }

    private static Block createSingleValueBlock(Slice expectedValue) {
        VariableWidthBlockBuilder blockBuilder = new VariableWidthBlockBuilder(null, 1, expectedValue.length());
        blockBuilder.writeEntry(expectedValue);
        return blockBuilder.build();
    }

    private static BlockBuilder createBlockBuilder() {
        return new VariableWidthBlockBuilder(null, 1, 1);
    }

    @Test
    public void testPositionsSizeInBytes() {
        Block valueBlock = TestRunLengthEncodedBlock.createSingleValueBlock(TestRunLengthEncodedBlock.createExpectedValue(10));
        Block rleBlock = RunLengthEncodedBlock.create((Block)valueBlock, (int)10);
        Assertions.assertThat((OptionalInt)rleBlock.fixedSizeInBytesPerPosition()).isEmpty();
        boolean[] positions = new boolean[rleBlock.getPositionCount()];
        positions[0] = true;
        positions[1] = true;
        Assertions.assertThat((long)rleBlock.getPositionsSizeInBytes(positions, 2)).isEqualTo(valueBlock.getSizeInBytes());
        Assertions.assertThat((long)rleBlock.getPositionsSizeInBytes(null, 2)).isEqualTo(valueBlock.getSizeInBytes());
        for (int positionCount = 0; positionCount < rleBlock.getPositionCount(); ++positionCount) {
            Assertions.assertThat((long)rleBlock.getPositionsSizeInBytes(null, positionCount)).isEqualTo(valueBlock.getSizeInBytes());
        }
    }

    @Test
    public void testBuildingFromLongArrayBlockBuilder() {
        LongArrayBlockBuilder blockBuilder = new LongArrayBlockBuilder(null, 100);
        this.populateNullValues((BlockBuilder)blockBuilder, 100);
    }

    @Test
    public void testBuildingFromIntArrayBlockBuilder() {
        IntArrayBlockBuilder blockBuilder = new IntArrayBlockBuilder(null, 100);
        this.populateNullValues((BlockBuilder)blockBuilder, 100);
    }

    @Test
    public void testBuildingFromShortArrayBlockBuilder() {
        ShortArrayBlockBuilder blockBuilder = new ShortArrayBlockBuilder(null, 100);
        this.populateNullValues((BlockBuilder)blockBuilder, 100);
    }

    @Test
    public void testBuildingFromByteArrayBlockBuilder() {
        ByteArrayBlockBuilder blockBuilder = new ByteArrayBlockBuilder(null, 100);
        this.populateNullValues((BlockBuilder)blockBuilder, 100);
    }

    @Test
    public void testEstimatedDataSizeForStats() {
        int positionCount = 10;
        Slice expectedValue = TestRunLengthEncodedBlock.createExpectedValue(5);
        Block block = RunLengthEncodedBlock.create((Block)TestRunLengthEncodedBlock.createSingleValueBlock(expectedValue), (int)positionCount);
        for (int postition = 0; postition < positionCount; ++postition) {
            Assertions.assertThat((long)block.getEstimatedDataSizeForStats(postition)).isEqualTo((long)expectedValue.length());
        }
    }

    private void populateNullValues(BlockBuilder blockBuilder, int positionCount) {
        for (int i = 0; i < positionCount; ++i) {
            blockBuilder.appendNull();
        }
    }

    @Override
    protected <T> void assertPositionValue(Block block, int position, T expectedValue) {
        if (expectedValue == null) {
            Assertions.assertThat((boolean)block.isNull(position)).isTrue();
            return;
        }
        Assertions.assertThat((boolean)block.isNull(position)).isFalse();
        VariableWidthBlock variableWidthBlock = (VariableWidthBlock)block.getUnderlyingValueBlock();
        Assertions.assertThat((Comparable)variableWidthBlock.getSlice(block.getUnderlyingValuePosition(position))).isEqualTo(expectedValue);
    }
}

