/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import io.airlift.stats.TDigest;
import io.trino.execution.DistributionSnapshot;
import io.trino.plugin.base.metrics.TDigestHistogram;
import io.trino.spi.metrics.Distribution;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TestDistributionSnapshot {
    TestDistributionSnapshot() {
    }

    @Test
    void testConvertFromTDigestHistogram() {
        TDigest digest = new TDigest();
        digest.add(1.0);
        digest.add(10.0);
        digest.add(10.0);
        digest.add(1.0);
        digest.add(4.0);
        digest.add(5.0);
        digest.add(1.0);
        digest.add(3.0);
        digest.add(7.0);
        TDigestHistogram histogram = new TDigestHistogram(digest);
        DistributionSnapshot snapshot = new DistributionSnapshot((Distribution)histogram);
        Assertions.assertThat((long)snapshot.total()).isEqualTo(9L);
        Assertions.assertThat((double)snapshot.min()).isEqualTo(1.0);
        Assertions.assertThat((double)snapshot.max()).isEqualTo(10.0);
        Assertions.assertThat((double)snapshot.p01()).isEqualTo(1.0);
        Assertions.assertThat((double)snapshot.p05()).isEqualTo(1.0);
        Assertions.assertThat((double)snapshot.p10()).isEqualTo(1.0);
        Assertions.assertThat((double)snapshot.p25()).isEqualTo(1.0);
        Assertions.assertThat((double)snapshot.p50()).isEqualTo(4.0);
        Assertions.assertThat((double)snapshot.p75()).isEqualTo(7.0);
        Assertions.assertThat((double)snapshot.p90()).isEqualTo(10.0);
        Assertions.assertThat((double)snapshot.p95()).isEqualTo(10.0);
        Assertions.assertThat((double)snapshot.p99()).isEqualTo(10.0);
    }
}

