/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.airlift.stats.TDigest;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.opentelemetry.api.trace.Span;
import io.trino.Session;
import io.trino.execution.NodeTaskMap;
import io.trino.execution.PartitionedSplitsInfo;
import io.trino.execution.RemoteTask;
import io.trino.execution.RemoteTaskFactory;
import io.trino.execution.StateMachine;
import io.trino.execution.TaskId;
import io.trino.execution.TaskInfo;
import io.trino.execution.TaskState;
import io.trino.execution.TaskStateMachine;
import io.trino.execution.TaskStatus;
import io.trino.execution.buffer.BufferState;
import io.trino.execution.buffer.OutputBufferInfo;
import io.trino.execution.buffer.OutputBufferStatus;
import io.trino.execution.buffer.OutputBuffers;
import io.trino.execution.buffer.SpoolingOutputStats;
import io.trino.metadata.InternalNode;
import io.trino.metadata.Split;
import io.trino.operator.TaskStats;
import io.trino.plugin.base.metrics.TDigestHistogram;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.plan.DynamicFilterId;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.util.Failures;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.joda.time.DateTime;

public class TestingRemoteTaskFactory
implements RemoteTaskFactory {
    private static final String TASK_INSTANCE_ID = "task-instance-id";
    private final Map<TaskId, TestingRemoteTask> tasks = new HashMap<TaskId, TestingRemoteTask>();

    public synchronized RemoteTask createRemoteTask(Session session, Span stageSpan, TaskId taskId, InternalNode node, boolean speculative, PlanFragment fragment, Multimap<PlanNodeId, Split> initialSplits, OutputBuffers outputBuffers, NodeTaskMap.PartitionedSplitCountTracker partitionedSplitCountTracker, Set<DynamicFilterId> outboundDynamicFilterIds, Optional<DataSize> estimatedMemory, boolean summarizeTaskInfo) {
        TestingRemoteTask task = new TestingRemoteTask(taskId, node.getNodeIdentifier(), fragment);
        task.addSplits(initialSplits);
        task.setOutputBuffers(outputBuffers);
        Preconditions.checkState((this.tasks.put(taskId, task) == null ? 1 : 0) != 0, (String)"task already exist: %s", (Object)taskId);
        return task;
    }

    public synchronized Map<TaskId, TestingRemoteTask> getTasks() {
        return ImmutableMap.copyOf(this.tasks);
    }

    public static class TestingRemoteTask
    implements RemoteTask {
        private final TaskStateMachine taskStateMachine;
        private final String nodeId;
        private final URI location;
        private final PlanFragment fragment;
        private final AtomicLong nextTaskStatusVersion = new AtomicLong(0L);
        private final AtomicBoolean started = new AtomicBoolean();
        private final Set<PlanNodeId> noMoreSplits = Sets.newConcurrentHashSet();
        @GuardedBy(value="this")
        private final Multimap<PlanNodeId, Split> splits = ArrayListMultimap.create();
        @GuardedBy(value="this")
        private OutputBuffers outputBuffers;

        public TestingRemoteTask(TaskId taskId, String nodeId, PlanFragment fragment) {
            this.taskStateMachine = new TaskStateMachine(taskId, MoreExecutors.directExecutor());
            this.nodeId = Objects.requireNonNull(nodeId, "nodeId is null");
            this.location = URI.create("fake://task/" + String.valueOf(taskId) + "/node/" + nodeId);
            this.fragment = Objects.requireNonNull(fragment, "fragment is null");
        }

        public PlanFragment getFragment() {
            return this.fragment;
        }

        public TaskId getTaskId() {
            return this.taskStateMachine.getTaskId();
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public TaskInfo getTaskInfo() {
            return new TaskInfo(this.getTaskStatus(), DateTime.now(), new OutputBufferInfo("TESTING", BufferState.FINISHED, false, false, 0L, 0L, 0L, 0L, Optional.empty(), Optional.of(new TDigestHistogram(new TDigest())), Optional.empty(), Optional.empty()), (Set)ImmutableSet.copyOf(this.noMoreSplits), new TaskStats(DateTime.now(), null), Optional.empty(), false);
        }

        public TaskStatus getTaskStatus() {
            TaskState state = this.taskStateMachine.getState();
            Object failures = ImmutableList.of();
            if (state == TaskState.FAILED) {
                failures = Failures.toFailures((Collection)this.taskStateMachine.getFailureCauses());
            }
            return new TaskStatus(this.taskStateMachine.getTaskId(), TestingRemoteTaskFactory.TASK_INSTANCE_ID, this.nextTaskStatusVersion.getAndIncrement(), state, this.location, this.nodeId, false, (List)failures, 0, 0, OutputBufferStatus.initial(), DataSize.of((long)0L, (DataSize.Unit)DataSize.Unit.BYTE), DataSize.of((long)0L, (DataSize.Unit)DataSize.Unit.BYTE), DataSize.of((long)0L, (DataSize.Unit)DataSize.Unit.BYTE), Optional.empty(), DataSize.of((long)0L, (DataSize.Unit)DataSize.Unit.BYTE), DataSize.of((long)0L, (DataSize.Unit)DataSize.Unit.BYTE), DataSize.of((long)0L, (DataSize.Unit)DataSize.Unit.BYTE), 0L, new Duration(0.0, TimeUnit.MILLISECONDS), 0L, 0L, 0L);
        }

        public void start() {
            this.started.set(true);
        }

        public boolean isStarted() {
            return this.started.get();
        }

        public synchronized void addSplits(Multimap<PlanNodeId, Split> splits) {
            this.splits.putAll(splits);
        }

        public synchronized Multimap<PlanNodeId, Split> getSplits() {
            return ImmutableListMultimap.copyOf(this.splits);
        }

        public void noMoreSplits(PlanNodeId sourceId) {
            this.noMoreSplits.add(sourceId);
        }

        public Set<PlanNodeId> getNoMoreSplits() {
            return ImmutableSet.copyOf(this.noMoreSplits);
        }

        public synchronized void setOutputBuffers(OutputBuffers outputBuffers) {
            this.outputBuffers = outputBuffers;
        }

        public void setSpeculative(boolean speculative) {
        }

        public synchronized OutputBuffers getOutputBuffers() {
            return this.outputBuffers;
        }

        public void addStateChangeListener(StateMachine.StateChangeListener<TaskStatus> stateChangeListener) {
            this.taskStateMachine.addStateChangeListener(newValue -> stateChangeListener.stateChanged((Object)this.getTaskStatus()));
        }

        public void addFinalTaskInfoListener(StateMachine.StateChangeListener<TaskInfo> stateChangeListener) {
            AtomicBoolean done = new AtomicBoolean();
            StateMachine.StateChangeListener fireOnceStateChangeListener = state -> {
                if (state.isDone() && done.compareAndSet(false, true)) {
                    stateChangeListener.stateChanged((Object)this.getTaskInfo());
                }
            };
            this.taskStateMachine.addStateChangeListener(fireOnceStateChangeListener);
            fireOnceStateChangeListener.stateChanged((Object)this.taskStateMachine.getState());
        }

        public ListenableFuture<Void> whenSplitQueueHasSpace(long weightThreshold) {
            return Futures.immediateVoidFuture();
        }

        public void cancel() {
            this.taskStateMachine.cancel();
            this.taskStateMachine.terminationComplete();
        }

        public void abort() {
            this.taskStateMachine.abort();
            this.taskStateMachine.terminationComplete();
        }

        public PartitionedSplitsInfo getPartitionedSplitsInfo() {
            return PartitionedSplitsInfo.forZeroSplits();
        }

        public void failRemotely(Throwable cause) {
            this.taskStateMachine.failed(cause);
            this.taskStateMachine.terminationComplete();
        }

        public void failLocallyImmediately(Throwable cause) {
            this.taskStateMachine.failed(cause);
            this.taskStateMachine.terminationComplete();
        }

        public PartitionedSplitsInfo getQueuedPartitionedSplitsInfo() {
            return PartitionedSplitsInfo.forZeroSplits();
        }

        public void finish() {
            this.taskStateMachine.finished();
        }

        public int getUnacknowledgedPartitionedSplitCount() {
            return 0;
        }

        public Optional<SpoolingOutputStats.Snapshot> retrieveAndDropSpoolingOutputStats() {
            throw new UnsupportedOperationException();
        }
    }
}

