/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.resourcegroups;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.units.DataSize;
import io.trino.execution.ManagedQueryExecution;
import io.trino.execution.MockManagedQueryExecution;
import io.trino.execution.QueryState;
import io.trino.execution.resourcegroups.InternalResourceGroup;
import io.trino.server.QueryStateInfo;
import io.trino.server.ResourceGroupInfo;
import io.trino.spi.resourcegroups.ResourceGroupState;
import io.trino.spi.resourcegroups.SchedulingPolicy;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.apache.commons.math3.distribution.BinomialDistribution;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestResourceGroups {
    @Test
    @Timeout(value=10L)
    public void testQueueFull() {
        InternalResourceGroup root = new InternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        root.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        root.setMaxQueuedQueries(1);
        root.setHardConcurrencyLimit(1);
        MockManagedQueryExecution query1 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        root.run((ManagedQueryExecution)query1);
        Assertions.assertThat((Comparable)query1.getState()).isEqualTo((Object)QueryState.RUNNING);
        MockManagedQueryExecution query2 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        root.run((ManagedQueryExecution)query2);
        Assertions.assertThat((Comparable)query2.getState()).isEqualTo((Object)QueryState.QUEUED);
        MockManagedQueryExecution query3 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        root.run((ManagedQueryExecution)query3);
        Assertions.assertThat((Comparable)query3.getState()).isEqualTo((Object)QueryState.FAILED);
        Assertions.assertThat((String)query3.getThrowable().getMessage()).isEqualTo("Too many queued queries for \"root\"");
    }

    @Test
    @Timeout(value=10L)
    public void testFairEligibility() {
        InternalResourceGroup root = new InternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        root.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        root.setMaxQueuedQueries(4);
        root.setHardConcurrencyLimit(1);
        InternalResourceGroup group1 = root.getOrCreateSubGroup("1");
        group1.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        group1.setMaxQueuedQueries(4);
        group1.setHardConcurrencyLimit(1);
        InternalResourceGroup group2 = root.getOrCreateSubGroup("2");
        group2.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        group2.setMaxQueuedQueries(4);
        group2.setHardConcurrencyLimit(1);
        InternalResourceGroup group3 = root.getOrCreateSubGroup("3");
        group3.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        group3.setMaxQueuedQueries(4);
        group3.setHardConcurrencyLimit(1);
        MockManagedQueryExecution query1a = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        group1.run((ManagedQueryExecution)query1a);
        Assertions.assertThat((Comparable)query1a.getState()).isEqualTo((Object)QueryState.RUNNING);
        MockManagedQueryExecution query1b = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        group1.run((ManagedQueryExecution)query1b);
        Assertions.assertThat((Comparable)query1b.getState()).isEqualTo((Object)QueryState.QUEUED);
        MockManagedQueryExecution query2a = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        group2.run((ManagedQueryExecution)query2a);
        Assertions.assertThat((Comparable)query2a.getState()).isEqualTo((Object)QueryState.QUEUED);
        MockManagedQueryExecution query2b = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        group2.run((ManagedQueryExecution)query2b);
        Assertions.assertThat((Comparable)query2b.getState()).isEqualTo((Object)QueryState.QUEUED);
        MockManagedQueryExecution query3a = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        group3.run((ManagedQueryExecution)query3a);
        Assertions.assertThat((Comparable)query3a.getState()).isEqualTo((Object)QueryState.QUEUED);
        query1a.complete();
        Assertions.assertThat((Comparable)query1b.getState()).isEqualTo((Object)QueryState.QUEUED);
        Assertions.assertThat((Comparable)query2a.getState()).isEqualTo((Object)QueryState.RUNNING);
        Assertions.assertThat((Comparable)query2b.getState()).isEqualTo((Object)QueryState.QUEUED);
        Assertions.assertThat((Comparable)query3a.getState()).isEqualTo((Object)QueryState.QUEUED);
        query2a.complete();
        Assertions.assertThat((Comparable)query3a.getState()).isEqualTo((Object)QueryState.RUNNING);
        Assertions.assertThat((Comparable)query2b.getState()).isEqualTo((Object)QueryState.QUEUED);
        Assertions.assertThat((Comparable)query1b.getState()).isEqualTo((Object)QueryState.QUEUED);
        query3a.complete();
        Assertions.assertThat((Comparable)query1b.getState()).isEqualTo((Object)QueryState.RUNNING);
        Assertions.assertThat((Comparable)query2b.getState()).isEqualTo((Object)QueryState.QUEUED);
    }

    @Test
    public void testSetSchedulingPolicy() {
        InternalResourceGroup root = new InternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        root.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        root.setMaxQueuedQueries(4);
        root.setHardConcurrencyLimit(1);
        InternalResourceGroup group1 = root.getOrCreateSubGroup("1");
        group1.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        group1.setMaxQueuedQueries(4);
        group1.setHardConcurrencyLimit(2);
        InternalResourceGroup group2 = root.getOrCreateSubGroup("2");
        group2.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        group2.setMaxQueuedQueries(4);
        group2.setHardConcurrencyLimit(2);
        MockManagedQueryExecution query1a = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        group1.run((ManagedQueryExecution)query1a);
        Assertions.assertThat((Comparable)query1a.getState()).isEqualTo((Object)QueryState.RUNNING);
        MockManagedQueryExecution query1b = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        group1.run((ManagedQueryExecution)query1b);
        Assertions.assertThat((Comparable)query1b.getState()).isEqualTo((Object)QueryState.QUEUED);
        MockManagedQueryExecution query1c = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        group1.run((ManagedQueryExecution)query1c);
        Assertions.assertThat((Comparable)query1c.getState()).isEqualTo((Object)QueryState.QUEUED);
        MockManagedQueryExecution query2a = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        group2.run((ManagedQueryExecution)query2a);
        Assertions.assertThat((Comparable)query2a.getState()).isEqualTo((Object)QueryState.QUEUED);
        Assertions.assertThat((int)root.getInfo().numEligibleSubGroups()).isEqualTo(2);
        Assertions.assertThat((int)root.getOrCreateSubGroup("1").getQueuedQueries()).isEqualTo(2);
        Assertions.assertThat((int)root.getOrCreateSubGroup("2").getQueuedQueries()).isEqualTo(1);
        Assertions.assertThat((Comparable)root.getSchedulingPolicy()).isEqualTo((Object)SchedulingPolicy.FAIR);
        root.setSchedulingPolicy(SchedulingPolicy.QUERY_PRIORITY);
        Assertions.assertThat((int)root.getInfo().numEligibleSubGroups()).isEqualTo(2);
        Assertions.assertThat((int)root.getOrCreateSubGroup("1").getQueuedQueries()).isEqualTo(2);
        Assertions.assertThat((int)root.getOrCreateSubGroup("2").getQueuedQueries()).isEqualTo(1);
        Assertions.assertThat((Comparable)root.getSchedulingPolicy()).isEqualTo((Object)SchedulingPolicy.QUERY_PRIORITY);
        Assertions.assertThat((Comparable)root.getOrCreateSubGroup("1").getSchedulingPolicy()).isEqualTo((Object)SchedulingPolicy.QUERY_PRIORITY);
        Assertions.assertThat((Comparable)root.getOrCreateSubGroup("2").getSchedulingPolicy()).isEqualTo((Object)SchedulingPolicy.QUERY_PRIORITY);
    }

    @Test
    @Timeout(value=10L)
    public void testFairQueuing() {
        InternalResourceGroup root = new InternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        root.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        root.setMaxQueuedQueries(4);
        root.setHardConcurrencyLimit(1);
        InternalResourceGroup group1 = root.getOrCreateSubGroup("1");
        group1.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        group1.setMaxQueuedQueries(4);
        group1.setHardConcurrencyLimit(2);
        InternalResourceGroup group2 = root.getOrCreateSubGroup("2");
        group2.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        group2.setMaxQueuedQueries(4);
        group2.setHardConcurrencyLimit(2);
        MockManagedQueryExecution query1a = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        group1.run((ManagedQueryExecution)query1a);
        Assertions.assertThat((Comparable)query1a.getState()).isEqualTo((Object)QueryState.RUNNING);
        MockManagedQueryExecution query1b = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        group1.run((ManagedQueryExecution)query1b);
        Assertions.assertThat((Comparable)query1b.getState()).isEqualTo((Object)QueryState.QUEUED);
        MockManagedQueryExecution query1c = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        group1.run((ManagedQueryExecution)query1c);
        Assertions.assertThat((Comparable)query1c.getState()).isEqualTo((Object)QueryState.QUEUED);
        MockManagedQueryExecution query2a = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        group2.run((ManagedQueryExecution)query2a);
        Assertions.assertThat((Comparable)query2a.getState()).isEqualTo((Object)QueryState.QUEUED);
        query1a.complete();
        Assertions.assertThat((Comparable)query1b.getState()).isEqualTo((Object)QueryState.RUNNING);
        Assertions.assertThat((Comparable)query1c.getState()).isEqualTo((Object)QueryState.QUEUED);
        Assertions.assertThat((Comparable)query2a.getState()).isEqualTo((Object)QueryState.QUEUED);
        query1b.complete();
        Assertions.assertThat((Comparable)query2a.getState()).isEqualTo((Object)QueryState.RUNNING);
        Assertions.assertThat((Comparable)query1c.getState()).isEqualTo((Object)QueryState.QUEUED);
    }

    @Test
    @Timeout(value=10L)
    public void testMemoryLimit() {
        InternalResourceGroup root = new InternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        root.setSoftMemoryLimitBytes(1L);
        root.setMaxQueuedQueries(4);
        root.setHardConcurrencyLimit(3);
        MockManagedQueryExecution query1 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().withInitialMemoryUsage(DataSize.ofBytes((long)2L)).build();
        root.run((ManagedQueryExecution)query1);
        root.updateGroupsAndProcessQueuedQueries();
        Assertions.assertThat((Comparable)query1.getState()).isEqualTo((Object)QueryState.RUNNING);
        MockManagedQueryExecution query2 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        root.run((ManagedQueryExecution)query2);
        Assertions.assertThat((Comparable)query2.getState()).isEqualTo((Object)QueryState.QUEUED);
        MockManagedQueryExecution query3 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        root.run((ManagedQueryExecution)query3);
        Assertions.assertThat((Comparable)query3.getState()).isEqualTo((Object)QueryState.QUEUED);
        query1.complete();
        Assertions.assertThat((Comparable)query2.getState()).isEqualTo((Object)QueryState.RUNNING);
        Assertions.assertThat((Comparable)query3.getState()).isEqualTo((Object)QueryState.RUNNING);
    }

    @Test
    public void testSubgroupMemoryLimit() {
        InternalResourceGroup root = new InternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        root.setSoftMemoryLimitBytes(10L);
        root.setMaxQueuedQueries(4);
        root.setHardConcurrencyLimit(3);
        InternalResourceGroup subgroup = root.getOrCreateSubGroup("subgroup");
        subgroup.setSoftMemoryLimitBytes(1L);
        subgroup.setMaxQueuedQueries(4);
        subgroup.setHardConcurrencyLimit(3);
        MockManagedQueryExecution query1 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().withInitialMemoryUsage(DataSize.ofBytes((long)2L)).build();
        subgroup.run((ManagedQueryExecution)query1);
        root.updateGroupsAndProcessQueuedQueries();
        Assertions.assertThat((Comparable)query1.getState()).isEqualTo((Object)QueryState.RUNNING);
        MockManagedQueryExecution query2 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        subgroup.run((ManagedQueryExecution)query2);
        Assertions.assertThat((Comparable)query2.getState()).isEqualTo((Object)QueryState.QUEUED);
        MockManagedQueryExecution query3 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        subgroup.run((ManagedQueryExecution)query3);
        Assertions.assertThat((Comparable)query3.getState()).isEqualTo((Object)QueryState.QUEUED);
        query1.complete();
        Assertions.assertThat((Comparable)query2.getState()).isEqualTo((Object)QueryState.RUNNING);
        Assertions.assertThat((Comparable)query3.getState()).isEqualTo((Object)QueryState.RUNNING);
    }

    @Test
    @Timeout(value=10L)
    public void testSoftCpuLimit() {
        InternalResourceGroup root = new InternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        root.setSoftMemoryLimitBytes(1L);
        root.setSoftCpuLimit(Duration.ofSeconds(1L));
        root.setHardCpuLimit(Duration.ofSeconds(2L));
        root.setCpuQuotaGenerationMillisPerSecond(2000L);
        root.setMaxQueuedQueries(1);
        root.setHardConcurrencyLimit(2);
        MockManagedQueryExecution query1 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().withInitialMemoryUsage(DataSize.ofBytes((long)1L)).withQueryId("query_id").withInitialCpuUsageMillis(1000L).build();
        root.run((ManagedQueryExecution)query1);
        Assertions.assertThat((Comparable)query1.getState()).isEqualTo((Object)QueryState.RUNNING);
        MockManagedQueryExecution query2 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        root.run((ManagedQueryExecution)query2);
        Assertions.assertThat((Comparable)query2.getState()).isEqualTo((Object)QueryState.RUNNING);
        MockManagedQueryExecution query3 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        root.run((ManagedQueryExecution)query3);
        Assertions.assertThat((Comparable)query3.getState()).isEqualTo((Object)QueryState.QUEUED);
        query1.complete();
        Assertions.assertThat((Comparable)query2.getState()).isEqualTo((Object)QueryState.RUNNING);
        Assertions.assertThat((Comparable)query3.getState()).isEqualTo((Object)QueryState.QUEUED);
        root.generateCpuQuota(2L);
        root.updateGroupsAndProcessQueuedQueries();
        Assertions.assertThat((Comparable)query2.getState()).isEqualTo((Object)QueryState.RUNNING);
        Assertions.assertThat((Comparable)query3.getState()).isEqualTo((Object)QueryState.RUNNING);
    }

    @Test
    @Timeout(value=10L)
    public void testHardCpuLimit() {
        InternalResourceGroup root = new InternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        root.setSoftMemoryLimitBytes(1L);
        root.setHardCpuLimit(Duration.ofSeconds(1L));
        root.setCpuQuotaGenerationMillisPerSecond(2000L);
        root.setMaxQueuedQueries(1);
        root.setHardConcurrencyLimit(1);
        MockManagedQueryExecution query1 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().withInitialMemoryUsage(DataSize.ofBytes((long)1L)).withQueryId("query_id").withInitialCpuUsageMillis(2000L).build();
        root.run((ManagedQueryExecution)query1);
        Assertions.assertThat((Comparable)query1.getState()).isEqualTo((Object)QueryState.RUNNING);
        MockManagedQueryExecution query2 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        root.run((ManagedQueryExecution)query2);
        Assertions.assertThat((Comparable)query2.getState()).isEqualTo((Object)QueryState.QUEUED);
        query1.complete();
        root.updateGroupsAndProcessQueuedQueries();
        Assertions.assertThat((Comparable)query2.getState()).isEqualTo((Object)QueryState.QUEUED);
        root.generateCpuQuota(2L);
        root.updateGroupsAndProcessQueuedQueries();
        Assertions.assertThat((Comparable)query2.getState()).isEqualTo((Object)QueryState.RUNNING);
    }

    @Test
    @Timeout(value=10L)
    public void testCpuUsageUpdateForRunningQuery() {
        InternalResourceGroup root = new InternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        InternalResourceGroup child = root.getOrCreateSubGroup("child");
        Stream.of(root, child).forEach(group -> {
            group.setCpuQuotaGenerationMillisPerSecond(1L);
            group.setHardCpuLimit(Duration.ofMillis(3L));
            group.setSoftCpuLimit(Duration.ofMillis(3L));
            group.setHardConcurrencyLimit(100);
            group.setMaxQueuedQueries(100);
        });
        MockManagedQueryExecution q1 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        child.run((ManagedQueryExecution)q1);
        Assertions.assertThat((Comparable)q1.getState()).isEqualTo((Object)QueryState.RUNNING);
        q1.consumeCpuTimeMillis(4L);
        root.updateGroupsAndProcessQueuedQueries();
        Stream.of(root, child).forEach(group -> TestResourceGroups.assertExceedsCpuLimit(group, 4L));
        MockManagedQueryExecution q2 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        child.run((ManagedQueryExecution)q2);
        Assertions.assertThat((Comparable)q2.getState()).isEqualTo((Object)QueryState.QUEUED);
        root.generateCpuQuota(2L);
        Stream.of(root, child).forEach(group -> TestResourceGroups.assertWithinCpuLimit(group, 2L));
        MockManagedQueryExecution q3 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        child.run((ManagedQueryExecution)q3);
        Assertions.assertThat((Comparable)q3.getState()).isEqualTo((Object)QueryState.RUNNING);
        Assertions.assertThat((Comparable)q2.getState()).isEqualTo((Object)QueryState.QUEUED);
        root.updateGroupsAndProcessQueuedQueries();
        Assertions.assertThat((Comparable)q2.getState()).isEqualTo((Object)QueryState.RUNNING);
    }

    @Test
    @Timeout(value=10L)
    public void testCpuUsageUpdateAtQueryCompletion() {
        InternalResourceGroup root = new InternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        InternalResourceGroup child = root.getOrCreateSubGroup("child");
        Stream.of(root, child).forEach(group -> {
            group.setCpuQuotaGenerationMillisPerSecond(1L);
            group.setHardCpuLimit(Duration.ofMillis(3L));
            group.setSoftCpuLimit(Duration.ofMillis(3L));
            group.setHardConcurrencyLimit(100);
            group.setMaxQueuedQueries(100);
        });
        MockManagedQueryExecution q1 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        child.run((ManagedQueryExecution)q1);
        Assertions.assertThat((Comparable)q1.getState()).isEqualTo((Object)QueryState.RUNNING);
        q1.consumeCpuTimeMillis(4L);
        q1.complete();
        Stream.of(root, child).forEach(group -> TestResourceGroups.assertExceedsCpuLimit(group, 4L));
        MockManagedQueryExecution q2 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        child.run((ManagedQueryExecution)q2);
        Assertions.assertThat((Comparable)q2.getState()).isEqualTo((Object)QueryState.QUEUED);
        root.generateCpuQuota(2L);
        Stream.of(root, child).forEach(group -> TestResourceGroups.assertWithinCpuLimit(group, 2L));
        Assertions.assertThat((Comparable)q2.getState()).isEqualTo((Object)QueryState.QUEUED);
        root.updateGroupsAndProcessQueuedQueries();
        Stream.of(root, child).forEach(group -> TestResourceGroups.assertWithinCpuLimit(group, 2L));
        Assertions.assertThat((Comparable)q2.getState()).isEqualTo((Object)QueryState.RUNNING);
    }

    @Test
    @Timeout(value=10L)
    public void testCpuUsageUpdateWhenParentGroupHasRunningQueries() {
        InternalResourceGroup root = new InternalResourceGroup("root", (internalResourceGroup, bl) -> {}, MoreExecutors.directExecutor());
        root.setCpuQuotaGenerationMillisPerSecond(1L);
        root.setHardCpuLimit(Duration.ofMillis(3L));
        root.setSoftCpuLimit(Duration.ofMillis(3L));
        root.setHardConcurrencyLimit(100);
        root.setMaxQueuedQueries(100);
        MockManagedQueryExecution q1 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        root.run((ManagedQueryExecution)q1);
        Assertions.assertThat((Comparable)q1.getState()).isEqualTo((Object)QueryState.RUNNING);
        q1.consumeCpuTimeMillis(2L);
        InternalResourceGroup child = root.getOrCreateSubGroup("child");
        child.setCpuQuotaGenerationMillisPerSecond(1L);
        child.setHardCpuLimit(Duration.ofMillis(3L));
        child.setSoftCpuLimit(Duration.ofMillis(3L));
        child.setHardConcurrencyLimit(100);
        child.setMaxQueuedQueries(100);
        MockManagedQueryExecution q2 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        child.run((ManagedQueryExecution)q2);
        Assertions.assertThat((Comparable)q2.getState()).isEqualTo((Object)QueryState.RUNNING);
        q2.consumeCpuTimeMillis(2L);
        root.updateGroupsAndProcessQueuedQueries();
        TestResourceGroups.assertExceedsCpuLimit(root, 4L);
        TestResourceGroups.assertWithinCpuLimit(child, 2L);
    }

    @Test
    @Timeout(value=10L)
    public void testMemoryUsageUpdateWhenParentGroupHasRunningQueries() {
        InternalResourceGroup root = new InternalResourceGroup("root", (internalResourceGroup, bl) -> {}, MoreExecutors.directExecutor());
        root.setHardConcurrencyLimit(100);
        root.setMaxQueuedQueries(100);
        root.setSoftMemoryLimitBytes(3L);
        MockManagedQueryExecution q1 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        root.run((ManagedQueryExecution)q1);
        Assertions.assertThat((Comparable)q1.getState()).isEqualTo((Object)QueryState.RUNNING);
        q1.setMemoryUsage(DataSize.ofBytes((long)2L));
        InternalResourceGroup child = root.getOrCreateSubGroup("child");
        child.setHardConcurrencyLimit(100);
        child.setMaxQueuedQueries(100);
        child.setSoftMemoryLimitBytes(3L);
        MockManagedQueryExecution q2 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        child.run((ManagedQueryExecution)q2);
        Assertions.assertThat((Comparable)q2.getState()).isEqualTo((Object)QueryState.RUNNING);
        q2.setMemoryUsage(DataSize.ofBytes((long)2L));
        root.updateGroupsAndProcessQueuedQueries();
        TestResourceGroups.assertExceedsMemoryLimit(root, 4L);
        TestResourceGroups.assertWithinMemoryLimit(child, 2L);
    }

    @Test
    @Timeout(value=10L)
    public void testCpuUsageUpdateForDisabledGroup() {
        InternalResourceGroup root = new InternalResourceGroup("root", (internalResourceGroup, bl) -> {}, MoreExecutors.directExecutor());
        InternalResourceGroup child = root.getOrCreateSubGroup("child");
        Stream.of(root, child).forEach(group -> {
            group.setCpuQuotaGenerationMillisPerSecond(1L);
            group.setHardCpuLimit(Duration.ofMillis(3L));
            group.setSoftCpuLimit(Duration.ofMillis(3L));
            group.setHardConcurrencyLimit(100);
            group.setMaxQueuedQueries(100);
        });
        MockManagedQueryExecution q1 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        child.run((ManagedQueryExecution)q1);
        Assertions.assertThat((Comparable)q1.getState()).isEqualTo((Object)QueryState.RUNNING);
        q1.consumeCpuTimeMillis(2L);
        root.updateGroupsAndProcessQueuedQueries();
        Stream.of(root, child).forEach(group -> TestResourceGroups.assertWithinCpuLimit(group, 2L));
        child.setDisabled(true);
        MockManagedQueryExecution q2 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        root.run((ManagedQueryExecution)q2);
        Assertions.assertThat((Comparable)q2.getState()).isEqualTo((Object)QueryState.RUNNING);
        q2.consumeCpuTimeMillis(2L);
        root.updateGroupsAndProcessQueuedQueries();
        TestResourceGroups.assertWithinCpuLimit(child, 2L);
        TestResourceGroups.assertExceedsCpuLimit(root, 4L);
        MockManagedQueryExecution q3 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        root.run((ManagedQueryExecution)q3);
        Assertions.assertThat((Comparable)q3.getState()).isEqualTo((Object)QueryState.QUEUED);
    }

    @Test
    @Timeout(value=10L)
    public void testMemoryUsageUpdateForDisabledGroup() {
        InternalResourceGroup root = new InternalResourceGroup("root", (internalResourceGroup, bl) -> {}, MoreExecutors.directExecutor());
        InternalResourceGroup child = root.getOrCreateSubGroup("child");
        Stream.of(root, child).forEach(group -> {
            group.setHardConcurrencyLimit(100);
            group.setMaxQueuedQueries(100);
            group.setSoftMemoryLimitBytes(3L);
        });
        MockManagedQueryExecution q1 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        child.run((ManagedQueryExecution)q1);
        Assertions.assertThat((Comparable)q1.getState()).isEqualTo((Object)QueryState.RUNNING);
        q1.setMemoryUsage(DataSize.ofBytes((long)2L));
        Stream.of(root, child).forEach(group -> TestResourceGroups.assertWithinMemoryLimit(group, 0L));
        root.updateGroupsAndProcessQueuedQueries();
        Stream.of(root, child).forEach(group -> TestResourceGroups.assertWithinMemoryLimit(group, 2L));
        child.setDisabled(true);
        MockManagedQueryExecution q2 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        root.run((ManagedQueryExecution)q2);
        Assertions.assertThat((Comparable)q2.getState()).isEqualTo((Object)QueryState.RUNNING);
        q2.setMemoryUsage(DataSize.ofBytes((long)2L));
        root.updateGroupsAndProcessQueuedQueries();
        TestResourceGroups.assertWithinMemoryLimit(child, 2L);
        TestResourceGroups.assertExceedsMemoryLimit(root, 4L);
        MockManagedQueryExecution q3 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        root.run((ManagedQueryExecution)q3);
        Assertions.assertThat((Comparable)q3.getState()).isEqualTo((Object)QueryState.QUEUED);
    }

    @Test
    @Timeout(value=10L)
    public void testMemoryUsageUpdateForRunningQuery() {
        InternalResourceGroup root = new InternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        InternalResourceGroup child = root.getOrCreateSubGroup("child");
        Stream.of(root, child).forEach(group -> {
            group.setHardConcurrencyLimit(100);
            group.setMaxQueuedQueries(100);
            group.setSoftMemoryLimitBytes(3L);
        });
        MockManagedQueryExecution q1 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        child.run((ManagedQueryExecution)q1);
        Assertions.assertThat((Comparable)q1.getState()).isEqualTo((Object)QueryState.RUNNING);
        q1.setMemoryUsage(DataSize.ofBytes((long)4L));
        Stream.of(root, child).forEach(group -> TestResourceGroups.assertWithinMemoryLimit(group, 0L));
        root.updateGroupsAndProcessQueuedQueries();
        Stream.of(root, child).forEach(group -> TestResourceGroups.assertExceedsMemoryLimit(group, 4L));
        MockManagedQueryExecution q2 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        child.run((ManagedQueryExecution)q2);
        Assertions.assertThat((Comparable)q2.getState()).isEqualTo((Object)QueryState.QUEUED);
        q1.setMemoryUsage(DataSize.ofBytes((long)2L));
        MockManagedQueryExecution q3 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        child.run((ManagedQueryExecution)q3);
        Assertions.assertThat((Comparable)q3.getState()).isEqualTo((Object)QueryState.QUEUED);
        root.updateGroupsAndProcessQueuedQueries();
        Stream.of(root, child).forEach(group -> TestResourceGroups.assertWithinMemoryLimit(group, 2L));
        Assertions.assertThat((Comparable)q2.getState()).isEqualTo((Object)QueryState.RUNNING);
        Assertions.assertThat((Comparable)q3.getState()).isEqualTo((Object)QueryState.RUNNING);
    }

    @Test
    @Timeout(value=10L)
    public void testMemoryUsageUpdateAtQueryCompletion() {
        InternalResourceGroup root = new InternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        InternalResourceGroup child = root.getOrCreateSubGroup("child");
        Stream.of(root, child).forEach(group -> {
            group.setHardConcurrencyLimit(100);
            group.setMaxQueuedQueries(100);
            group.setSoftMemoryLimitBytes(3L);
        });
        MockManagedQueryExecution q1 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        child.run((ManagedQueryExecution)q1);
        Assertions.assertThat((Comparable)q1.getState()).isEqualTo((Object)QueryState.RUNNING);
        q1.setMemoryUsage(DataSize.ofBytes((long)4L));
        Stream.of(root, child).forEach(group -> TestResourceGroups.assertWithinMemoryLimit(group, 0L));
        root.updateGroupsAndProcessQueuedQueries();
        Stream.of(root, child).forEach(group -> TestResourceGroups.assertExceedsMemoryLimit(group, 4L));
        q1.complete();
        Stream.of(root, child).forEach(group -> TestResourceGroups.assertWithinMemoryLimit(group, 0L));
        MockManagedQueryExecution q2 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        child.run((ManagedQueryExecution)q2);
        Assertions.assertThat((Comparable)q2.getState()).isEqualTo((Object)QueryState.RUNNING);
    }

    @Test
    @Timeout(value=10L)
    public void testRecursiveCpuUsageUpdate() {
        InternalResourceGroup root = new InternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        InternalResourceGroup rootChild1 = root.getOrCreateSubGroup("rootChild1");
        InternalResourceGroup rootChild2 = root.getOrCreateSubGroup("rootChild2");
        InternalResourceGroup rootChild1Child1 = rootChild1.getOrCreateSubGroup("rootChild1Child1");
        InternalResourceGroup rootChild1Child2 = rootChild1.getOrCreateSubGroup("rootChild1Child2");
        Stream.of(root, rootChild1, rootChild2, rootChild1Child1, rootChild1Child2).forEach(group -> {
            group.setCpuQuotaGenerationMillisPerSecond(1L);
            group.setHardConcurrencyLimit(100);
            group.setMaxQueuedQueries(100);
        });
        root.setHardCpuLimit(Duration.ofMillis(16L));
        rootChild1.setHardCpuLimit(Duration.ofMillis(6L));
        rootChild1Child1.setHardCpuLimit(Duration.ofMillis(100L));
        rootChild1Child2.setHardCpuLimit(Duration.ofMillis(100L));
        rootChild2.setHardCpuLimit(Duration.ofMillis(100L));
        MockManagedQueryExecution q1 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        MockManagedQueryExecution q2 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        MockManagedQueryExecution q3 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        rootChild1Child1.run((ManagedQueryExecution)q1);
        rootChild1Child2.run((ManagedQueryExecution)q2);
        rootChild2.run((ManagedQueryExecution)q3);
        Assertions.assertThat((Comparable)q1.getState()).isEqualTo((Object)QueryState.RUNNING);
        Assertions.assertThat((Comparable)q2.getState()).isEqualTo((Object)QueryState.RUNNING);
        Assertions.assertThat((Comparable)q3.getState()).isEqualTo((Object)QueryState.RUNNING);
        q1.consumeCpuTimeMillis(4L);
        q2.consumeCpuTimeMillis(10L);
        q3.consumeCpuTimeMillis(4L);
        root.updateGroupsAndProcessQueuedQueries();
        TestResourceGroups.assertExceedsCpuLimit(root, 18L);
        TestResourceGroups.assertExceedsCpuLimit(rootChild1, 14L);
        TestResourceGroups.assertWithinCpuLimit(rootChild2, 4L);
        TestResourceGroups.assertWithinCpuLimit(rootChild1Child1, 4L);
        TestResourceGroups.assertWithinCpuLimit(rootChild1Child2, 10L);
        MockManagedQueryExecution q4 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        rootChild2.run((ManagedQueryExecution)q4);
        Assertions.assertThat((Comparable)q4.getState()).isEqualTo((Object)QueryState.QUEUED);
        MockManagedQueryExecution q5 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        rootChild1Child1.run((ManagedQueryExecution)q5);
        Assertions.assertThat((Comparable)q5.getState()).isEqualTo((Object)QueryState.QUEUED);
        root.generateCpuQuota(4L);
        TestResourceGroups.assertWithinCpuLimit(root, 14L);
        TestResourceGroups.assertExceedsCpuLimit(rootChild1, 10L);
        TestResourceGroups.assertWithinCpuLimit(rootChild2, 0L);
        TestResourceGroups.assertWithinCpuLimit(rootChild1Child1, 0L);
        TestResourceGroups.assertWithinCpuLimit(rootChild1Child2, 6L);
        root.updateGroupsAndProcessQueuedQueries();
        Assertions.assertThat((Comparable)q4.getState()).isEqualTo((Object)QueryState.RUNNING);
        Assertions.assertThat((Comparable)q5.getState()).isEqualTo((Object)QueryState.QUEUED);
        q2.consumeCpuTimeMillis(3L);
        q2.complete();
        TestResourceGroups.assertExceedsCpuLimit(root, 17L);
        TestResourceGroups.assertExceedsCpuLimit(rootChild1, 13L);
        TestResourceGroups.assertWithinCpuLimit(rootChild1Child2, 9L);
        MockManagedQueryExecution q6 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        rootChild2.run((ManagedQueryExecution)q6);
        Assertions.assertThat((Comparable)q6.getState()).isEqualTo((Object)QueryState.QUEUED);
        root.generateCpuQuota(6L);
        TestResourceGroups.assertWithinCpuLimit(root, 11L);
        TestResourceGroups.assertExceedsCpuLimit(rootChild1, 7L);
        TestResourceGroups.assertWithinCpuLimit(rootChild2, 0L);
        TestResourceGroups.assertWithinCpuLimit(rootChild1Child1, 0L);
        TestResourceGroups.assertWithinCpuLimit(rootChild1Child2, 3L);
        root.updateGroupsAndProcessQueuedQueries();
        Assertions.assertThat((Comparable)q5.getState()).isEqualTo((Object)QueryState.QUEUED);
        Assertions.assertThat((Comparable)q6.getState()).isEqualTo((Object)QueryState.RUNNING);
        root.generateCpuQuota(2L);
        TestResourceGroups.assertWithinCpuLimit(rootChild1, 5L);
        root.updateGroupsAndProcessQueuedQueries();
        Assertions.assertThat((Comparable)q5.getState()).isEqualTo((Object)QueryState.RUNNING);
    }

    @Test
    @Timeout(value=10L)
    public void testMemoryUpdateRecursively() {
        InternalResourceGroup root = new InternalResourceGroup(this, "root", (group, export) -> {}, MoreExecutors.directExecutor()){

            public void triggerProcessQueuedQueries() {
            }
        };
        InternalResourceGroup rootChild1 = root.getOrCreateSubGroup("rootChild1");
        InternalResourceGroup rootChild2 = root.getOrCreateSubGroup("rootChild2");
        InternalResourceGroup rootChild1Child1 = rootChild1.getOrCreateSubGroup("rootChild1Child1");
        InternalResourceGroup rootChild1Child2 = rootChild1.getOrCreateSubGroup("rootChild1Child2");
        Stream.of(root, rootChild1, rootChild2, rootChild1Child1, rootChild1Child2).forEach(group -> {
            group.setHardConcurrencyLimit(100);
            group.setMaxQueuedQueries(100);
        });
        root.setSoftMemoryLimitBytes(8L);
        rootChild1.setSoftMemoryLimitBytes(3L);
        rootChild2.setSoftMemoryLimitBytes(100L);
        rootChild1Child1.setSoftMemoryLimitBytes(100L);
        rootChild1Child2.setSoftMemoryLimitBytes(100L);
        MockManagedQueryExecution q1 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        MockManagedQueryExecution q2 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        MockManagedQueryExecution q3 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        rootChild1Child1.run((ManagedQueryExecution)q1);
        rootChild1Child2.run((ManagedQueryExecution)q2);
        rootChild2.run((ManagedQueryExecution)q3);
        Assertions.assertThat((Comparable)q1.getState()).isEqualTo((Object)QueryState.RUNNING);
        Assertions.assertThat((Comparable)q2.getState()).isEqualTo((Object)QueryState.RUNNING);
        Assertions.assertThat((Comparable)q3.getState()).isEqualTo((Object)QueryState.RUNNING);
        q1.setMemoryUsage(DataSize.ofBytes((long)2L));
        q2.setMemoryUsage(DataSize.ofBytes((long)5L));
        q3.setMemoryUsage(DataSize.ofBytes((long)2L));
        root.updateGroupsAndProcessQueuedQueries();
        TestResourceGroups.assertExceedsMemoryLimit(root, 9L);
        TestResourceGroups.assertExceedsMemoryLimit(rootChild1, 7L);
        TestResourceGroups.assertWithinMemoryLimit(rootChild2, 2L);
        TestResourceGroups.assertWithinMemoryLimit(rootChild1Child1, 2L);
        TestResourceGroups.assertWithinMemoryLimit(rootChild1Child2, 5L);
        MockManagedQueryExecution q4 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        rootChild2.run((ManagedQueryExecution)q4);
        Assertions.assertThat((Comparable)q4.getState()).isEqualTo((Object)QueryState.QUEUED);
        MockManagedQueryExecution q5 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        rootChild1Child1.run((ManagedQueryExecution)q5);
        Assertions.assertThat((Comparable)q5.getState()).isEqualTo((Object)QueryState.QUEUED);
        q1.setMemoryUsage(DataSize.ofBytes((long)0L));
        root.updateGroupsAndProcessQueuedQueries();
        TestResourceGroups.assertWithinMemoryLimit(root, 7L);
        TestResourceGroups.assertExceedsMemoryLimit(rootChild1, 5L);
        TestResourceGroups.assertWithinMemoryLimit(rootChild1Child1, 0L);
        Assertions.assertThat((Comparable)q4.getState()).isEqualTo((Object)QueryState.RUNNING);
        Assertions.assertThat((Comparable)q5.getState()).isEqualTo((Object)QueryState.QUEUED);
        q2.complete();
        TestResourceGroups.assertWithinMemoryLimit(root, 2L);
        TestResourceGroups.assertWithinMemoryLimit(rootChild1, 0L);
        MockManagedQueryExecution q6 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        rootChild1Child2.run((ManagedQueryExecution)q6);
        Assertions.assertThat((Comparable)q6.getState()).isEqualTo((Object)QueryState.RUNNING);
        Assertions.assertThat((Comparable)q5.getState()).isEqualTo((Object)QueryState.QUEUED);
        root.updateGroupsAndProcessQueuedQueries();
        Assertions.assertThat((Comparable)q5.getState()).isEqualTo((Object)QueryState.RUNNING);
    }

    @Test
    @Timeout(value=10L)
    public void testPriorityScheduling() {
        InternalResourceGroup root = new InternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        root.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        root.setMaxQueuedQueries(100);
        root.setHardConcurrencyLimit(0);
        root.setSchedulingPolicy(SchedulingPolicy.QUERY_PRIORITY);
        InternalResourceGroup group1 = root.getOrCreateSubGroup("1");
        group1.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        group1.setMaxQueuedQueries(100);
        group1.setHardConcurrencyLimit(1);
        InternalResourceGroup group2 = root.getOrCreateSubGroup("2");
        group2.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        group2.setMaxQueuedQueries(100);
        group2.setHardConcurrencyLimit(1);
        TreeMap<Integer, MockManagedQueryExecution> queries = new TreeMap<Integer, MockManagedQueryExecution>();
        Random random = new Random();
        for (int i = 0; i < 100; ++i) {
            int priority;
            while (queries.containsKey(priority = random.nextInt(1000000) + 1)) {
            }
            MockManagedQueryExecution query = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().withQueryId("query_id").withPriority(priority).build();
            if (random.nextBoolean()) {
                group1.run((ManagedQueryExecution)query);
            } else {
                group2.run((ManagedQueryExecution)query);
            }
            queries.put(priority, query);
        }
        root.setHardConcurrencyLimit(1);
        ArrayList orderedQueries = new ArrayList(queries.values());
        Collections.reverse(orderedQueries);
        for (MockManagedQueryExecution query : orderedQueries) {
            root.updateGroupsAndProcessQueuedQueries();
            Assertions.assertThat((Comparable)query.getState()).isEqualTo((Object)QueryState.RUNNING);
            query.complete();
        }
    }

    @Test
    @Timeout(value=10L)
    public void testWeightedScheduling() {
        InternalResourceGroup root = new InternalResourceGroup(this, "root", (group, export) -> {}, MoreExecutors.directExecutor()){

            public void triggerProcessQueuedQueries() {
            }
        };
        root.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        root.setMaxQueuedQueries(4);
        root.setHardConcurrencyLimit(0);
        root.setSchedulingPolicy(SchedulingPolicy.WEIGHTED);
        InternalResourceGroup group1 = root.getOrCreateSubGroup("1");
        group1.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        group1.setMaxQueuedQueries(2);
        group1.setHardConcurrencyLimit(2);
        group1.setSoftConcurrencyLimit(2);
        InternalResourceGroup group2 = root.getOrCreateSubGroup("2");
        group2.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        group2.setMaxQueuedQueries(2);
        group2.setHardConcurrencyLimit(2);
        group2.setSoftConcurrencyLimit(2);
        group2.setSchedulingWeight(2);
        Set<MockManagedQueryExecution> group1Queries = TestResourceGroups.fillGroupTo(group1, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 2);
        Set<MockManagedQueryExecution> group2Queries = TestResourceGroups.fillGroupTo(group2, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 2);
        root.setHardConcurrencyLimit(1);
        int group2Ran = 0;
        for (int i = 0; i < 1000; ++i) {
            Iterator<MockManagedQueryExecution> iterator = group1Queries.iterator();
            while (iterator.hasNext()) {
                MockManagedQueryExecution query = iterator.next();
                if (query.getState() != QueryState.RUNNING) continue;
                query.complete();
                iterator.remove();
            }
            group2Ran += TestResourceGroups.completeGroupQueries(group2Queries);
            root.updateGroupsAndProcessQueuedQueries();
            group1Queries = TestResourceGroups.fillGroupTo(group1, group1Queries, 2);
            group2Queries = TestResourceGroups.fillGroupTo(group2, group2Queries, 2);
        }
        BinomialDistribution binomial = new BinomialDistribution(1000, 0.6666666666666666);
        int lowerBound = binomial.inverseCumulativeProbability(1.0E-6);
        int upperBound = binomial.inverseCumulativeProbability(0.999999);
        Assertions.assertThat((int)group2Ran).isLessThan(upperBound);
        Assertions.assertThat((int)group2Ran).isGreaterThan(lowerBound);
    }

    @Test
    @Timeout(value=10L)
    public void testWeightedFairScheduling() {
        InternalResourceGroup root = new InternalResourceGroup(this, "root", (group, export) -> {}, MoreExecutors.directExecutor()){

            public void triggerProcessQueuedQueries() {
            }
        };
        root.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        root.setMaxQueuedQueries(50);
        root.setHardConcurrencyLimit(0);
        root.setSchedulingPolicy(SchedulingPolicy.WEIGHTED_FAIR);
        InternalResourceGroup group1 = root.getOrCreateSubGroup("1");
        group1.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        group1.setMaxQueuedQueries(50);
        group1.setHardConcurrencyLimit(2);
        group1.setSoftConcurrencyLimit(2);
        group1.setSchedulingWeight(1);
        InternalResourceGroup group2 = root.getOrCreateSubGroup("2");
        group2.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        group2.setMaxQueuedQueries(50);
        group2.setHardConcurrencyLimit(2);
        group2.setSoftConcurrencyLimit(2);
        group2.setSchedulingWeight(2);
        Set<MockManagedQueryExecution> group1Queries = TestResourceGroups.fillGroupTo(group1, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 4);
        Set<MockManagedQueryExecution> group2Queries = TestResourceGroups.fillGroupTo(group2, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 4);
        root.setHardConcurrencyLimit(3);
        int group1Ran = 0;
        int group2Ran = 0;
        for (int i = 0; i < 1000; ++i) {
            group1Ran += TestResourceGroups.completeGroupQueries(group1Queries);
            group2Ran += TestResourceGroups.completeGroupQueries(group2Queries);
            root.updateGroupsAndProcessQueuedQueries();
            group1Queries = TestResourceGroups.fillGroupTo(group1, group1Queries, 4);
            group2Queries = TestResourceGroups.fillGroupTo(group2, group2Queries, 4);
        }
        Assertions.assertThat((int)group1Ran).isBetween(Integer.valueOf(995), Integer.valueOf(1000));
        Assertions.assertThat((int)group2Ran).isBetween(Integer.valueOf(1995), Integer.valueOf(2000));
    }

    @Test
    @Timeout(value=10L)
    public void testWeightedFairSchedulingEqualWeights() {
        InternalResourceGroup root = new InternalResourceGroup(this, "root", (group, export) -> {}, MoreExecutors.directExecutor()){

            public void triggerProcessQueuedQueries() {
            }
        };
        root.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        root.setMaxQueuedQueries(50);
        root.setHardConcurrencyLimit(0);
        root.setSchedulingPolicy(SchedulingPolicy.WEIGHTED_FAIR);
        InternalResourceGroup group1 = root.getOrCreateSubGroup("1");
        group1.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        group1.setMaxQueuedQueries(50);
        group1.setHardConcurrencyLimit(2);
        group1.setSoftConcurrencyLimit(2);
        group1.setSchedulingWeight(1);
        InternalResourceGroup group2 = root.getOrCreateSubGroup("2");
        group2.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        group2.setMaxQueuedQueries(50);
        group2.setHardConcurrencyLimit(2);
        group2.setSoftConcurrencyLimit(2);
        group2.setSchedulingWeight(1);
        InternalResourceGroup group3 = root.getOrCreateSubGroup("3");
        group3.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        group3.setMaxQueuedQueries(50);
        group3.setHardConcurrencyLimit(2);
        group3.setSoftConcurrencyLimit(2);
        group3.setSchedulingWeight(2);
        Set<MockManagedQueryExecution> group1Queries = TestResourceGroups.fillGroupTo(group1, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 4);
        Set<MockManagedQueryExecution> group2Queries = TestResourceGroups.fillGroupTo(group2, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 4);
        Set<MockManagedQueryExecution> group3Queries = TestResourceGroups.fillGroupTo(group3, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 4);
        root.setHardConcurrencyLimit(4);
        int group1Ran = 0;
        int group2Ran = 0;
        int group3Ran = 0;
        for (int i = 0; i < 1000; ++i) {
            group1Ran += TestResourceGroups.completeGroupQueries(group1Queries);
            group2Ran += TestResourceGroups.completeGroupQueries(group2Queries);
            group3Ran += TestResourceGroups.completeGroupQueries(group3Queries);
            root.updateGroupsAndProcessQueuedQueries();
            group1Queries = TestResourceGroups.fillGroupTo(group1, group1Queries, 4);
            group2Queries = TestResourceGroups.fillGroupTo(group2, group2Queries, 4);
            group3Queries = TestResourceGroups.fillGroupTo(group3, group3Queries, 4);
        }
        BinomialDistribution binomial = new BinomialDistribution(4000, 0.25);
        int lowerBound = binomial.inverseCumulativeProbability(1.0E-6);
        int upperBound = binomial.inverseCumulativeProbability(0.999999);
        Assertions.assertThat((int)group1Ran).isBetween(Integer.valueOf(lowerBound), Integer.valueOf(upperBound));
        Assertions.assertThat((int)group2Ran).isBetween(Integer.valueOf(lowerBound), Integer.valueOf(upperBound));
        Assertions.assertThat((int)group3Ran).isBetween(Integer.valueOf(2 * lowerBound), Integer.valueOf(2 * upperBound));
    }

    @Test
    @Timeout(value=10L)
    public void testWeightedFairSchedulingNoStarvation() {
        InternalResourceGroup root = new InternalResourceGroup(this, "root", (group, export) -> {}, MoreExecutors.directExecutor()){

            public void triggerProcessQueuedQueries() {
            }
        };
        root.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        root.setMaxQueuedQueries(50);
        root.setHardConcurrencyLimit(0);
        root.setSchedulingPolicy(SchedulingPolicy.WEIGHTED_FAIR);
        InternalResourceGroup group1 = root.getOrCreateSubGroup("1");
        group1.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        group1.setMaxQueuedQueries(50);
        group1.setHardConcurrencyLimit(2);
        group1.setSoftConcurrencyLimit(2);
        group1.setSchedulingWeight(1);
        InternalResourceGroup group2 = root.getOrCreateSubGroup("2");
        group2.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        group2.setMaxQueuedQueries(50);
        group2.setHardConcurrencyLimit(2);
        group2.setSoftConcurrencyLimit(2);
        group2.setSchedulingWeight(2);
        Set<MockManagedQueryExecution> group1Queries = TestResourceGroups.fillGroupTo(group1, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 4);
        Set<MockManagedQueryExecution> group2Queries = TestResourceGroups.fillGroupTo(group2, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 4);
        root.setHardConcurrencyLimit(1);
        int group1Ran = 0;
        for (int i = 0; i < 2000; ++i) {
            group1Ran += TestResourceGroups.completeGroupQueries(group1Queries);
            TestResourceGroups.completeGroupQueries(group2Queries);
            root.updateGroupsAndProcessQueuedQueries();
            group1Queries = TestResourceGroups.fillGroupTo(group1, group1Queries, 4);
            group2Queries = TestResourceGroups.fillGroupTo(group2, group2Queries, 4);
        }
        Assertions.assertThat((int)group1Ran).isEqualTo(1000);
        Assertions.assertThat((int)group1Ran).isEqualTo(1000);
    }

    @Test
    public void testGetInfo() {
        InternalResourceGroup root = new InternalResourceGroup(this, "root", (group, export) -> {}, MoreExecutors.directExecutor()){

            public void triggerProcessQueuedQueries() {
            }
        };
        root.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        root.setMaxQueuedQueries(40);
        root.setHardConcurrencyLimit(0);
        root.setSchedulingPolicy(SchedulingPolicy.WEIGHTED);
        InternalResourceGroup rootA = root.getOrCreateSubGroup("a");
        rootA.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rootA.setMaxQueuedQueries(20);
        rootA.setHardConcurrencyLimit(2);
        InternalResourceGroup rootB = root.getOrCreateSubGroup("b");
        rootB.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rootB.setMaxQueuedQueries(20);
        rootB.setHardConcurrencyLimit(2);
        rootB.setSchedulingWeight(2);
        rootB.setSchedulingPolicy(SchedulingPolicy.QUERY_PRIORITY);
        InternalResourceGroup rootAX = rootA.getOrCreateSubGroup("x");
        rootAX.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rootAX.setMaxQueuedQueries(10);
        rootAX.setHardConcurrencyLimit(10);
        InternalResourceGroup rootAY = rootA.getOrCreateSubGroup("y");
        rootAY.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rootAY.setMaxQueuedQueries(10);
        rootAY.setHardConcurrencyLimit(10);
        InternalResourceGroup rootBX = rootB.getOrCreateSubGroup("x");
        rootBX.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rootBX.setMaxQueuedQueries(10);
        rootBX.setHardConcurrencyLimit(10);
        InternalResourceGroup rootBY = rootB.getOrCreateSubGroup("y");
        rootBY.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rootBY.setMaxQueuedQueries(10);
        rootBY.setHardConcurrencyLimit(10);
        Set<MockManagedQueryExecution> queries = TestResourceGroups.fillGroupTo(rootAX, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 10, false);
        queries.addAll(TestResourceGroups.fillGroupTo(rootAY, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 10, false));
        queries.addAll(TestResourceGroups.fillGroupTo(rootBX, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 10, true));
        queries.addAll(TestResourceGroups.fillGroupTo(rootBY, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 10, true));
        ResourceGroupInfo info = root.getInfo();
        Assertions.assertThat((int)info.numRunningQueries()).isEqualTo(0);
        Assertions.assertThat((int)info.numQueuedQueries()).isEqualTo(40);
        root.setHardConcurrencyLimit(4);
        root.updateGroupsAndProcessQueuedQueries();
        info = root.getInfo();
        Assertions.assertThat((int)info.numRunningQueries()).isEqualTo(4);
        Assertions.assertThat((int)info.numQueuedQueries()).isEqualTo(36);
        Iterator<MockManagedQueryExecution> iterator = queries.iterator();
        while (iterator.hasNext()) {
            MockManagedQueryExecution query = iterator.next();
            if (query.getState() != QueryState.RUNNING) continue;
            query.complete();
            iterator.remove();
        }
        root.updateGroupsAndProcessQueuedQueries();
        info = root.getInfo();
        Assertions.assertThat((int)info.numRunningQueries()).isEqualTo(4);
        Assertions.assertThat((int)info.numQueuedQueries()).isEqualTo(32);
        root.setHardConcurrencyLimit(10);
        root.updateGroupsAndProcessQueuedQueries();
        info = root.getInfo();
        Assertions.assertThat((int)info.numRunningQueries()).isEqualTo(4);
        Assertions.assertThat((int)info.numQueuedQueries()).isEqualTo(32);
        rootB.setHardConcurrencyLimit(10);
        root.updateGroupsAndProcessQueuedQueries();
        info = root.getInfo();
        Assertions.assertThat((int)info.numRunningQueries()).isEqualTo(10);
        Assertions.assertThat((int)info.numQueuedQueries()).isEqualTo(26);
    }

    @Test
    public void testGetResourceGroupStateInfo() {
        InternalResourceGroup root = new InternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        root.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE).toBytes());
        root.setMaxQueuedQueries(40);
        root.setHardConcurrencyLimit(10);
        root.setSchedulingPolicy(SchedulingPolicy.WEIGHTED);
        InternalResourceGroup rootA = root.getOrCreateSubGroup("a");
        rootA.setSoftMemoryLimitBytes(DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rootA.setMaxQueuedQueries(20);
        rootA.setHardConcurrencyLimit(0);
        InternalResourceGroup rootB = root.getOrCreateSubGroup("b");
        rootB.setSoftMemoryLimitBytes(DataSize.of((long)5L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rootB.setMaxQueuedQueries(20);
        rootB.setHardConcurrencyLimit(1);
        rootB.setSchedulingWeight(2);
        rootB.setSchedulingPolicy(SchedulingPolicy.QUERY_PRIORITY);
        InternalResourceGroup rootAX = rootA.getOrCreateSubGroup("x");
        rootAX.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rootAX.setMaxQueuedQueries(10);
        rootAX.setHardConcurrencyLimit(10);
        InternalResourceGroup rootAY = rootA.getOrCreateSubGroup("y");
        rootAY.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rootAY.setMaxQueuedQueries(10);
        rootAY.setHardConcurrencyLimit(10);
        Set<MockManagedQueryExecution> queries = TestResourceGroups.fillGroupTo(rootAX, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 5, false);
        queries.addAll(TestResourceGroups.fillGroupTo(rootAY, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 5, false));
        queries.addAll(TestResourceGroups.fillGroupTo(rootB, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 10, true));
        ResourceGroupInfo rootInfo = root.getFullInfo();
        Assertions.assertThat((Object)rootInfo.id()).isEqualTo((Object)root.getId());
        Assertions.assertThat((Comparable)rootInfo.state()).isEqualTo((Object)ResourceGroupState.CAN_RUN);
        Assertions.assertThat((long)rootInfo.softMemoryLimit().toBytes()).isEqualTo(root.getSoftMemoryLimitBytes());
        Assertions.assertThat((Comparable)rootInfo.memoryUsage()).isEqualTo((Object)DataSize.ofBytes((long)0L));
        Assertions.assertThat((long)rootInfo.cpuUsage().toMillis()).isEqualTo(0L);
        List subGroups = (List)rootInfo.subGroups().get();
        Assertions.assertThat((List)subGroups).hasSize(2);
        TestResourceGroups.assertGroupInfoEquals((ResourceGroupInfo)subGroups.get(0), rootA.getInfo());
        Assertions.assertThat((Object)((ResourceGroupInfo)subGroups.get(0)).id()).isEqualTo((Object)rootA.getId());
        Assertions.assertThat((Comparable)((ResourceGroupInfo)subGroups.get(0)).state()).isEqualTo((Object)ResourceGroupState.CAN_QUEUE);
        Assertions.assertThat((long)((ResourceGroupInfo)subGroups.get(0)).softMemoryLimit().toBytes()).isEqualTo(rootA.getSoftMemoryLimitBytes());
        Assertions.assertThat((int)((ResourceGroupInfo)subGroups.get(0)).hardConcurrencyLimit()).isEqualTo(rootA.getHardConcurrencyLimit());
        Assertions.assertThat((int)((ResourceGroupInfo)subGroups.get(0)).maxQueuedQueries()).isEqualTo(rootA.getMaxQueuedQueries());
        Assertions.assertThat((int)((ResourceGroupInfo)subGroups.get(0)).numEligibleSubGroups()).isEqualTo(2);
        Assertions.assertThat((int)((ResourceGroupInfo)subGroups.get(0)).numRunningQueries()).isEqualTo(0);
        Assertions.assertThat((int)((ResourceGroupInfo)subGroups.get(0)).numQueuedQueries()).isEqualTo(10);
        TestResourceGroups.assertGroupInfoEquals((ResourceGroupInfo)subGroups.get(1), rootB.getInfo());
        Assertions.assertThat((Object)((ResourceGroupInfo)subGroups.get(1)).id()).isEqualTo((Object)rootB.getId());
        Assertions.assertThat((Comparable)((ResourceGroupInfo)subGroups.get(1)).state()).isEqualTo((Object)ResourceGroupState.CAN_QUEUE);
        Assertions.assertThat((long)((ResourceGroupInfo)subGroups.get(1)).softMemoryLimit().toBytes()).isEqualTo(rootB.getSoftMemoryLimitBytes());
        Assertions.assertThat((int)((ResourceGroupInfo)subGroups.get(1)).hardConcurrencyLimit()).isEqualTo(rootB.getHardConcurrencyLimit());
        Assertions.assertThat((int)((ResourceGroupInfo)subGroups.get(1)).maxQueuedQueries()).isEqualTo(rootB.getMaxQueuedQueries());
        Assertions.assertThat((int)((ResourceGroupInfo)subGroups.get(1)).numEligibleSubGroups()).isEqualTo(0);
        Assertions.assertThat((int)((ResourceGroupInfo)subGroups.get(1)).numRunningQueries()).isEqualTo(1);
        Assertions.assertThat((int)((ResourceGroupInfo)subGroups.get(1)).numQueuedQueries()).isEqualTo(9);
        Assertions.assertThat((int)rootInfo.softConcurrencyLimit()).isEqualTo(root.getSoftConcurrencyLimit());
        Assertions.assertThat((int)rootInfo.hardConcurrencyLimit()).isEqualTo(root.getHardConcurrencyLimit());
        Assertions.assertThat((int)rootInfo.maxQueuedQueries()).isEqualTo(root.getMaxQueuedQueries());
        Assertions.assertThat((int)rootInfo.numQueuedQueries()).isEqualTo(19);
        List runningQueries = (List)rootInfo.runningQueries().get();
        Assertions.assertThat((List)runningQueries).hasSize(1);
        QueryStateInfo queryInfo = (QueryStateInfo)runningQueries.get(0);
        Assertions.assertThat((Optional)queryInfo.getResourceGroupId()).isEqualTo(Optional.of(rootB.getId()));
    }

    @Test
    public void testStartedQueries() {
        InternalResourceGroup root = new InternalResourceGroup(this, "root", (internalResourceGroup, bl) -> {}, MoreExecutors.directExecutor()){

            public void triggerProcessQueuedQueries() {
            }
        };
        InternalResourceGroup rootA = root.getOrCreateSubGroup("a");
        InternalResourceGroup rootA1 = rootA.getOrCreateSubGroup("1");
        InternalResourceGroup rootB = root.getOrCreateSubGroup("b");
        List<InternalResourceGroup> allGroups = List.of(root, rootB, rootA, rootA1);
        allGroups.forEach(group -> {
            group.setHardConcurrencyLimit(2);
            group.setMaxQueuedQueries(100);
        });
        MockManagedQueryExecution[] queries = (MockManagedQueryExecution[])Stream.generate(() -> new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build()).limit(4L).toArray(MockManagedQueryExecution[]::new);
        rootB.run((ManagedQueryExecution)queries[0]);
        Assertions.assertThat(allGroups).extracting(group -> group.getStartedQueries().getTotalCount()).containsExactly((Object[])new Long[]{1L, 1L, 0L, 0L});
        rootA1.run((ManagedQueryExecution)queries[1]);
        Assertions.assertThat(allGroups).extracting(group -> group.getStartedQueries().getTotalCount()).containsExactly((Object[])new Long[]{2L, 1L, 1L, 1L});
        rootA1.run((ManagedQueryExecution)queries[2]);
        rootA1.run((ManagedQueryExecution)queries[3]);
        Assertions.assertThat(allGroups).extracting(group -> group.getStartedQueries().getTotalCount()).containsExactly((Object[])new Long[]{2L, 1L, 1L, 1L});
        queries[0].complete();
        queries[1].complete();
        root.updateGroupsAndProcessQueuedQueries();
        Assertions.assertThat(allGroups).extracting(group -> group.getStartedQueries().getTotalCount()).containsExactly((Object[])new Long[]{4L, 1L, 3L, 3L});
    }

    @Test
    public void testGetWaitingQueuedQueries() {
        InternalResourceGroup root = new InternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        root.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        root.setMaxQueuedQueries(40);
        root.setHardConcurrencyLimit(0);
        InternalResourceGroup rootA = root.getOrCreateSubGroup("a");
        rootA.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rootA.setMaxQueuedQueries(20);
        rootA.setHardConcurrencyLimit(8);
        InternalResourceGroup rootAX = rootA.getOrCreateSubGroup("x");
        rootAX.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rootAX.setMaxQueuedQueries(10);
        rootAX.setHardConcurrencyLimit(8);
        InternalResourceGroup rootAY = rootA.getOrCreateSubGroup("y");
        rootAY.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rootAY.setMaxQueuedQueries(10);
        rootAY.setHardConcurrencyLimit(5);
        InternalResourceGroup rootB = root.getOrCreateSubGroup("b");
        rootB.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rootB.setMaxQueuedQueries(20);
        rootB.setHardConcurrencyLimit(8);
        InternalResourceGroup rootBX = rootB.getOrCreateSubGroup("x");
        rootBX.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rootBX.setMaxQueuedQueries(10);
        rootBX.setHardConcurrencyLimit(8);
        InternalResourceGroup rootBY = rootB.getOrCreateSubGroup("y");
        rootBY.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rootBY.setMaxQueuedQueries(10);
        rootBY.setHardConcurrencyLimit(5);
        Set<MockManagedQueryExecution> queries = TestResourceGroups.fillGroupTo(rootAX, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 10, false);
        queries.addAll(TestResourceGroups.fillGroupTo(rootAY, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 10, false));
        queries.addAll(TestResourceGroups.fillGroupTo(rootBX, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 10, true));
        queries.addAll(TestResourceGroups.fillGroupTo(rootBY, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 10, true));
        Assertions.assertThat((int)root.getWaitingQueuedQueries()).isEqualTo(16);
        Assertions.assertThat((int)rootA.getWaitingQueuedQueries()).isEqualTo(13);
        Assertions.assertThat((int)rootAX.getWaitingQueuedQueries()).isEqualTo(10);
        Assertions.assertThat((int)rootAY.getWaitingQueuedQueries()).isEqualTo(10);
        Assertions.assertThat((int)rootB.getWaitingQueuedQueries()).isEqualTo(13);
        Assertions.assertThat((int)rootBX.getWaitingQueuedQueries()).isEqualTo(10);
        Assertions.assertThat((int)rootBY.getWaitingQueuedQueries()).isEqualTo(10);
        root.setHardConcurrencyLimit(20);
        root.updateGroupsAndProcessQueuedQueries();
        Assertions.assertThat((int)root.getWaitingQueuedQueries()).isEqualTo(0);
        Assertions.assertThat((int)rootA.getWaitingQueuedQueries()).isEqualTo(5);
        Assertions.assertThat((int)rootAX.getWaitingQueuedQueries()).isEqualTo(6);
        Assertions.assertThat((int)rootAY.getWaitingQueuedQueries()).isEqualTo(6);
        Assertions.assertThat((int)rootB.getWaitingQueuedQueries()).isEqualTo(5);
        Assertions.assertThat((int)rootBX.getWaitingQueuedQueries()).isEqualTo(6);
        Assertions.assertThat((int)rootBY.getWaitingQueuedQueries()).isEqualTo(6);
    }

    @Test
    public void testGetQueriesQueuedOnInternal() {
        InternalResourceGroup root = new InternalResourceGroup("root", (internalResourceGroup, bl) -> {}, MoreExecutors.directExecutor());
        root.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        root.setMaxQueuedQueries(40);
        root.setHardConcurrencyLimit(0);
        root.setSoftConcurrencyLimit(0);
        InternalResourceGroup rootA = root.getOrCreateSubGroup("a");
        rootA.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rootA.setMaxQueuedQueries(20);
        rootA.setHardConcurrencyLimit(8);
        rootA.setSoftConcurrencyLimit(8);
        InternalResourceGroup rootAX = rootA.getOrCreateSubGroup("x");
        rootAX.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rootAX.setMaxQueuedQueries(10);
        rootAX.setHardConcurrencyLimit(8);
        rootAX.setSoftConcurrencyLimit(8);
        InternalResourceGroup rootAY = rootA.getOrCreateSubGroup("y");
        rootAY.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rootAY.setMaxQueuedQueries(10);
        rootAY.setHardConcurrencyLimit(5);
        rootAY.setSoftConcurrencyLimit(5);
        InternalResourceGroup rootB = root.getOrCreateSubGroup("b");
        rootB.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rootB.setMaxQueuedQueries(20);
        rootB.setHardConcurrencyLimit(8);
        rootB.setSoftConcurrencyLimit(8);
        InternalResourceGroup rootBX = rootB.getOrCreateSubGroup("x");
        rootBX.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rootBX.setMaxQueuedQueries(10);
        rootBX.setHardConcurrencyLimit(8);
        rootBX.setSoftConcurrencyLimit(8);
        InternalResourceGroup rootBY = rootB.getOrCreateSubGroup("y");
        rootBY.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rootBY.setMaxQueuedQueries(10);
        rootBY.setHardConcurrencyLimit(5);
        rootBY.setSoftConcurrencyLimit(5);
        TestResourceGroups.fillGroupTo(rootAX, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 10, false);
        TestResourceGroups.fillGroupTo(rootAY, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 10, false);
        TestResourceGroups.fillGroupTo(rootBX, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 10, true);
        TestResourceGroups.fillGroupTo(rootBY, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 10, true);
        Assertions.assertThat((int)root.getQueriesQueuedOnInternal()).isEqualTo(26);
        Assertions.assertThat((int)rootA.getQueriesQueuedOnInternal()).isEqualTo(13);
        Assertions.assertThat((int)rootAX.getQueriesQueuedOnInternal()).isEqualTo(8);
        Assertions.assertThat((int)rootAY.getQueriesQueuedOnInternal()).isEqualTo(5);
        Assertions.assertThat((int)rootB.getQueriesQueuedOnInternal()).isEqualTo(13);
        Assertions.assertThat((int)rootBX.getQueriesQueuedOnInternal()).isEqualTo(8);
        Assertions.assertThat((int)rootBY.getQueriesQueuedOnInternal()).isEqualTo(5);
        root.setHardConcurrencyLimit(20);
        root.updateGroupsAndProcessQueuedQueries();
        Assertions.assertThat((int)root.getQueriesQueuedOnInternal()).isEqualTo(10);
        Assertions.assertThat((int)rootA.getQueriesQueuedOnInternal()).isEqualTo(5);
        Assertions.assertThat((int)rootAX.getQueriesQueuedOnInternal()).isEqualTo(4);
        Assertions.assertThat((int)rootAY.getQueriesQueuedOnInternal()).isEqualTo(1);
        Assertions.assertThat((int)rootB.getQueriesQueuedOnInternal()).isEqualTo(5);
        Assertions.assertThat((int)rootBX.getQueriesQueuedOnInternal()).isEqualTo(4);
        Assertions.assertThat((int)rootBY.getQueriesQueuedOnInternal()).isEqualTo(1);
    }

    @Test
    public void testGetWaitingQueuedQueriesWithDisabledGroup() {
        InternalResourceGroup root = new InternalResourceGroup("root", (internalResourceGroup, bl) -> {}, MoreExecutors.directExecutor());
        root.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        root.setMaxQueuedQueries(40);
        root.setHardConcurrencyLimit(20);
        InternalResourceGroup rootA = root.getOrCreateSubGroup("a");
        rootA.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rootA.setMaxQueuedQueries(20);
        rootA.setHardConcurrencyLimit(15);
        InternalResourceGroup rootAX = rootA.getOrCreateSubGroup("x");
        rootAX.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rootAX.setMaxQueuedQueries(10);
        rootAX.setHardConcurrencyLimit(10);
        InternalResourceGroup rootB = root.getOrCreateSubGroup("b");
        rootB.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rootB.setMaxQueuedQueries(20);
        rootB.setHardConcurrencyLimit(15);
        TestResourceGroups.fillGroupTo(rootB, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 8, false);
        TestResourceGroups.fillGroupTo(rootAX, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 6, false);
        rootAX.setDisabled(true);
        TestResourceGroups.fillGroupTo(rootA, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 20, false);
        Assertions.assertThat((int)root.getWaitingQueuedQueries()).isEqualTo(3);
        Assertions.assertThat((int)root.getQueuedQueries()).isEqualTo(14);
        Assertions.assertThat((int)rootA.getWaitingQueuedQueries()).isEqualTo(14);
        Assertions.assertThat((int)rootA.getQueuedQueries()).isEqualTo(14);
        Assertions.assertThat((int)rootAX.getWaitingQueuedQueries()).isEqualTo(0);
        Assertions.assertThat((int)rootAX.getQueuedQueries()).isEqualTo(0);
        Assertions.assertThat((int)rootB.getWaitingQueuedQueries()).isEqualTo(0);
        Assertions.assertThat((int)rootB.getQueuedQueries()).isEqualTo(0);
    }

    @Test
    public void testGetQueriesQueuedOnInternalWithDisabledGroup() {
        InternalResourceGroup root = new InternalResourceGroup("root", (internalResourceGroup, bl) -> {}, MoreExecutors.directExecutor());
        root.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        root.setMaxQueuedQueries(40);
        root.setHardConcurrencyLimit(20);
        root.setSoftConcurrencyLimit(20);
        InternalResourceGroup rootA = root.getOrCreateSubGroup("a");
        rootA.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rootA.setMaxQueuedQueries(20);
        rootA.setHardConcurrencyLimit(15);
        rootA.setSoftConcurrencyLimit(15);
        InternalResourceGroup rootAX = rootA.getOrCreateSubGroup("x");
        rootAX.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rootAX.setMaxQueuedQueries(10);
        rootAX.setHardConcurrencyLimit(10);
        rootAX.setSoftConcurrencyLimit(10);
        InternalResourceGroup rootB = root.getOrCreateSubGroup("b");
        rootB.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rootB.setMaxQueuedQueries(20);
        rootB.setHardConcurrencyLimit(15);
        rootB.setSoftConcurrencyLimit(15);
        TestResourceGroups.fillGroupTo(rootB, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 8, false);
        TestResourceGroups.fillGroupTo(rootAX, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 6, false);
        rootAX.setDisabled(true);
        TestResourceGroups.fillGroupTo(rootA, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 20, false);
        Assertions.assertThat((int)root.getQueriesQueuedOnInternal()).isEqualTo(3);
        Assertions.assertThat((int)root.getQueuedQueries()).isEqualTo(14);
        Assertions.assertThat((int)rootA.getQueriesQueuedOnInternal()).isEqualTo(3);
        Assertions.assertThat((int)rootA.getQueuedQueries()).isEqualTo(14);
        Assertions.assertThat((int)rootAX.getQueriesQueuedOnInternal()).isEqualTo(0);
        Assertions.assertThat((int)rootAX.getQueuedQueries()).isEqualTo(0);
        Assertions.assertThat((int)rootB.getQueriesQueuedOnInternal()).isEqualTo(0);
        Assertions.assertThat((int)rootB.getQueuedQueries()).isEqualTo(0);
    }

    private static int completeGroupQueries(Set<MockManagedQueryExecution> groupQueries) {
        int groupRan = 0;
        Iterator<MockManagedQueryExecution> iterator = groupQueries.iterator();
        while (iterator.hasNext()) {
            MockManagedQueryExecution query = iterator.next();
            if (query.getState() != QueryState.RUNNING) continue;
            query.complete();
            iterator.remove();
            ++groupRan;
        }
        return groupRan;
    }

    private static Set<MockManagedQueryExecution> fillGroupTo(InternalResourceGroup group, Set<MockManagedQueryExecution> existingQueries, int count) {
        return TestResourceGroups.fillGroupTo(group, existingQueries, count, false);
    }

    private static Set<MockManagedQueryExecution> fillGroupTo(InternalResourceGroup group, Set<MockManagedQueryExecution> existingQueries, int count, boolean queryPriority) {
        int existingCount = existingQueries.size();
        HashSet<MockManagedQueryExecution> queries = new HashSet<MockManagedQueryExecution>(existingQueries);
        for (int i = 0; i < count - existingCount; ++i) {
            MockManagedQueryExecution query = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().withQueryId(group.getId().toString().replace(".", "") + Integer.toString(i)).withPriority(queryPriority ? i + 1 : 1).build();
            queries.add(query);
            group.run((ManagedQueryExecution)query);
        }
        return queries;
    }

    private static void assertGroupInfoEquals(ResourceGroupInfo actual, ResourceGroupInfo expected) {
        Assertions.assertThat((actual.schedulingWeight() == expected.schedulingWeight() && actual.softConcurrencyLimit() == expected.softConcurrencyLimit() && actual.hardConcurrencyLimit() == expected.hardConcurrencyLimit() && actual.maxQueuedQueries() == expected.maxQueuedQueries() && actual.numQueuedQueries() == expected.numQueuedQueries() && actual.numRunningQueries() == expected.numRunningQueries() && actual.numEligibleSubGroups() == expected.numEligibleSubGroups() && Objects.equals(actual.id(), expected.id()) && actual.state() == expected.state() && actual.schedulingPolicy() == expected.schedulingPolicy() && Objects.equals(actual.softMemoryLimit(), expected.softMemoryLimit()) && Objects.equals(actual.memoryUsage(), expected.memoryUsage()) && Objects.equals(actual.cpuUsage(), expected.cpuUsage()) ? 1 : 0) != 0).isTrue();
    }

    private static void assertExceedsCpuLimit(InternalResourceGroup group, long expectedMillis) {
        long actualMillis = group.getResourceUsageSnapshot().getCpuUsageMillis();
        Assertions.assertThat((long)actualMillis).isEqualTo(expectedMillis);
        Assertions.assertThat((actualMillis >= group.getHardCpuLimit().toMillis() ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((long)group.getCpuUsageMillis()).isEqualTo(expectedMillis);
    }

    private static void assertWithinCpuLimit(InternalResourceGroup group, long expectedMillis) {
        long actualMillis = group.getResourceUsageSnapshot().getCpuUsageMillis();
        Assertions.assertThat((long)actualMillis).isEqualTo(expectedMillis);
        Assertions.assertThat((actualMillis < group.getHardCpuLimit().toMillis() ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((long)group.getCpuUsageMillis()).isEqualTo(expectedMillis);
    }

    private static void assertExceedsMemoryLimit(InternalResourceGroup group, long expectedBytes) {
        long actualBytes = group.getResourceUsageSnapshot().getMemoryUsageBytes();
        Assertions.assertThat((long)actualBytes).isEqualTo(expectedBytes);
        Assertions.assertThat((long)actualBytes).isGreaterThan(group.getSoftMemoryLimitBytes());
        Assertions.assertThat((long)group.getMemoryUsageBytes()).isEqualTo(expectedBytes);
    }

    private static void assertWithinMemoryLimit(InternalResourceGroup group, long expectedBytes) {
        long actualBytes = group.getResourceUsageSnapshot().getMemoryUsageBytes();
        Assertions.assertThat((long)actualBytes).isEqualTo(expectedBytes);
        Assertions.assertThat((long)actualBytes).isLessThanOrEqualTo(group.getSoftMemoryLimitBytes());
        Assertions.assertThat((long)group.getMemoryUsageBytes()).isEqualTo(expectedBytes);
    }
}

