/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler.faulttolerant;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.jaxrs.JsonMapper;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecBinder;
import io.airlift.json.JsonModule;
import io.airlift.units.DataSize;
import io.trino.exchange.ExchangeInput;
import io.trino.exchange.SpoolingExchangeInput;
import io.trino.execution.StageId;
import io.trino.execution.scheduler.faulttolerant.NodeRequirements;
import io.trino.execution.scheduler.faulttolerant.SplitsMapping;
import io.trino.execution.scheduler.faulttolerant.TaskDescriptor;
import io.trino.execution.scheduler.faulttolerant.TaskDescriptorStorage;
import io.trino.metadata.HandleJsonModule;
import io.trino.metadata.Split;
import io.trino.operator.ExchangeOperator;
import io.trino.spi.QueryId;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.catalog.CatalogName;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.exchange.ExchangeSourceHandle;
import io.trino.split.RemoteSplit;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.TestingHandles;
import io.trino.testing.assertions.Assert;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestTaskDescriptorStorage {
    private static final QueryId QUERY_1 = new QueryId("query1");
    private static final QueryId QUERY_2 = new QueryId("query2");
    private static final StageId QUERY_1_STAGE_1 = new StageId(QUERY_1, 1);
    private static final StageId QUERY_1_STAGE_2 = new StageId(QUERY_1, 2);
    private static final StageId QUERY_2_STAGE_1 = new StageId(QUERY_2, 1);
    private static final StageId QUERY_2_STAGE_2 = new StageId(QUERY_2, 2);

    @Test
    public void testHappyPath() {
        TaskDescriptorStorage manager = TestTaskDescriptorStorage.createTaskDescriptorStorage(DataSize.of((long)15L, (DataSize.Unit)DataSize.Unit.KILOBYTE), DataSize.of((long)20L, (DataSize.Unit)DataSize.Unit.KILOBYTE), DataSize.of((long)20L, (DataSize.Unit)DataSize.Unit.KILOBYTE));
        manager.initialize(QUERY_1);
        manager.initialize(QUERY_2);
        manager.put(QUERY_1_STAGE_1, TestTaskDescriptorStorage.createTaskDescriptor(0, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE), "catalog1"));
        manager.put(QUERY_1_STAGE_1, TestTaskDescriptorStorage.createTaskDescriptor(1, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE), "catalog2"));
        manager.put(QUERY_1_STAGE_2, TestTaskDescriptorStorage.createTaskDescriptor(0, DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.KILOBYTE), "catalog3"));
        manager.put(QUERY_2_STAGE_1, TestTaskDescriptorStorage.createTaskDescriptor(0, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE), "catalog4"));
        manager.put(QUERY_2_STAGE_2, TestTaskDescriptorStorage.createTaskDescriptor(0, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE), "catalog5"));
        manager.put(QUERY_2_STAGE_2, TestTaskDescriptorStorage.createTaskDescriptor(1, DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.KILOBYTE), "catalog6"));
        Assertions.assertThat((long)manager.getReservedUncompressedBytes()).isGreaterThanOrEqualTo(TestTaskDescriptorStorage.toBytes(10, DataSize.Unit.KILOBYTE)).isLessThanOrEqualTo(TestTaskDescriptorStorage.toBytes(15, DataSize.Unit.KILOBYTE));
        Assertions.assertThat((Optional)manager.get(QUERY_1_STAGE_1, 0)).flatMap(TestTaskDescriptorStorage::getCatalogName).contains((Object)"catalog1");
        Assertions.assertThat((Optional)manager.get(QUERY_1_STAGE_1, 1)).flatMap(TestTaskDescriptorStorage::getCatalogName).contains((Object)"catalog2");
        Assertions.assertThat((Optional)manager.get(QUERY_1_STAGE_2, 0)).flatMap(TestTaskDescriptorStorage::getCatalogName).contains((Object)"catalog3");
        Assertions.assertThat((Optional)manager.get(QUERY_2_STAGE_1, 0)).flatMap(TestTaskDescriptorStorage::getCatalogName).contains((Object)"catalog4");
        Assertions.assertThat((Optional)manager.get(QUERY_2_STAGE_2, 0)).flatMap(TestTaskDescriptorStorage::getCatalogName).contains((Object)"catalog5");
        Assertions.assertThat((Optional)manager.get(QUERY_2_STAGE_2, 1)).flatMap(TestTaskDescriptorStorage::getCatalogName).contains((Object)"catalog6");
        manager.remove(QUERY_1_STAGE_1, 0);
        manager.remove(QUERY_2_STAGE_2, 1);
        Assertions.assertThatThrownBy(() -> manager.get(QUERY_1_STAGE_1, 0)).hasMessageContaining("descriptor not found for key");
        Assertions.assertThatThrownBy(() -> manager.get(QUERY_2_STAGE_2, 1)).hasMessageContaining("descriptor not found for key");
        Assertions.assertThat((long)manager.getReservedUncompressedBytes()).isGreaterThanOrEqualTo(TestTaskDescriptorStorage.toBytes(6, DataSize.Unit.KILOBYTE)).isLessThanOrEqualTo(TestTaskDescriptorStorage.toBytes(8, DataSize.Unit.KILOBYTE));
    }

    @Test
    public void testDestroy() {
        TaskDescriptorStorage manager = new TaskDescriptorStorage(DataSize.of((long)5L, (DataSize.Unit)DataSize.Unit.KILOBYTE), DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.KILOBYTE), DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.KILOBYTE), JsonCodec.jsonCodec(TaskDescriptor.class), JsonCodec.jsonCodec(Split.class));
        manager.initialize(QUERY_1);
        manager.initialize(QUERY_2);
        manager.put(QUERY_1_STAGE_1, TestTaskDescriptorStorage.createTaskDescriptor(0, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE)));
        Assertions.assertThat((Optional)manager.get(QUERY_1_STAGE_1, 0)).isPresent();
        Assertions.assertThat((long)manager.getReservedUncompressedBytes()).isGreaterThanOrEqualTo(TestTaskDescriptorStorage.toBytes(1, DataSize.Unit.KILOBYTE));
        manager.put(QUERY_2_STAGE_1, TestTaskDescriptorStorage.createTaskDescriptor(0, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE)));
        Assertions.assertThat((Optional)manager.get(QUERY_2_STAGE_1, 0)).isPresent();
        Assertions.assertThat((long)manager.getReservedUncompressedBytes()).isGreaterThanOrEqualTo(TestTaskDescriptorStorage.toBytes(2, DataSize.Unit.KILOBYTE));
        manager.destroy(QUERY_1);
        Assertions.assertThat((Optional)manager.get(QUERY_1_STAGE_1, 0)).isEmpty();
        Assertions.assertThat((Optional)manager.get(QUERY_2_STAGE_1, 0)).isPresent();
        Assertions.assertThat((long)manager.getReservedUncompressedBytes()).isGreaterThanOrEqualTo(TestTaskDescriptorStorage.toBytes(1, DataSize.Unit.KILOBYTE)).isLessThanOrEqualTo(TestTaskDescriptorStorage.toBytes(2, DataSize.Unit.KILOBYTE));
        manager.destroy(QUERY_2);
        Assertions.assertThat((Optional)manager.get(QUERY_1_STAGE_1, 0)).isEmpty();
        Assertions.assertThat((Optional)manager.get(QUERY_2_STAGE_1, 0)).isEmpty();
        Assertions.assertThat((long)manager.getReservedUncompressedBytes()).isEqualTo(0L);
    }

    @Test
    public void testCapacityExceeded() {
        TaskDescriptorStorage manager = TestTaskDescriptorStorage.createTaskDescriptorStorage(DataSize.of((long)5L, (DataSize.Unit)DataSize.Unit.KILOBYTE), DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.KILOBYTE), DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.KILOBYTE));
        manager.initialize(QUERY_1);
        manager.initialize(QUERY_2);
        manager.put(QUERY_1_STAGE_1, TestTaskDescriptorStorage.createTaskDescriptor(0, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE), "catalog1"));
        manager.put(QUERY_1_STAGE_1, TestTaskDescriptorStorage.createTaskDescriptor(1, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE), "catalog2"));
        manager.put(QUERY_1_STAGE_2, TestTaskDescriptorStorage.createTaskDescriptor(0, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE), "catalog3"));
        manager.put(QUERY_2_STAGE_1, TestTaskDescriptorStorage.createTaskDescriptor(0, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE), "catalog4"));
        manager.put(QUERY_2_STAGE_2, TestTaskDescriptorStorage.createTaskDescriptor(0, DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.KILOBYTE), "catalog5"));
        Assertions.assertThat((long)manager.getReservedUncompressedBytes()).isGreaterThanOrEqualTo(TestTaskDescriptorStorage.toBytes(4, DataSize.Unit.KILOBYTE)).isLessThanOrEqualTo(TestTaskDescriptorStorage.toBytes(5, DataSize.Unit.KILOBYTE));
        Assertions.assertThatThrownBy(() -> manager.put(QUERY_1_STAGE_1, TestTaskDescriptorStorage.createTaskDescriptor(0, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE)))).matches(TestTaskDescriptorStorage::isStorageCapacityExceededFailure);
        Assertions.assertThatThrownBy(() -> manager.put(QUERY_1_STAGE_2, TestTaskDescriptorStorage.createTaskDescriptor(1, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE)))).matches(TestTaskDescriptorStorage::isStorageCapacityExceededFailure);
        Assertions.assertThatThrownBy(() -> manager.get(QUERY_1_STAGE_1, 0)).matches(TestTaskDescriptorStorage::isStorageCapacityExceededFailure);
        Assertions.assertThatThrownBy(() -> manager.get(QUERY_1_STAGE_1, 1)).matches(TestTaskDescriptorStorage::isStorageCapacityExceededFailure);
        Assertions.assertThatThrownBy(() -> manager.get(QUERY_1_STAGE_2, 0)).matches(TestTaskDescriptorStorage::isStorageCapacityExceededFailure);
        Assertions.assertThatThrownBy(() -> manager.remove(QUERY_1_STAGE_1, 0)).matches(TestTaskDescriptorStorage::isStorageCapacityExceededFailure);
        Assertions.assertThatThrownBy(() -> manager.remove(QUERY_1_STAGE_1, 1)).matches(TestTaskDescriptorStorage::isStorageCapacityExceededFailure);
        Assertions.assertThatThrownBy(() -> manager.remove(QUERY_1_STAGE_2, 0)).matches(TestTaskDescriptorStorage::isStorageCapacityExceededFailure);
        Assertions.assertThat((Optional)manager.get(QUERY_2_STAGE_1, 0)).flatMap(TestTaskDescriptorStorage::getCatalogName).contains((Object)"catalog4");
        Assertions.assertThat((Optional)manager.get(QUERY_2_STAGE_2, 0)).flatMap(TestTaskDescriptorStorage::getCatalogName).contains((Object)"catalog5");
        manager.put(QUERY_2_STAGE_2, TestTaskDescriptorStorage.createTaskDescriptor(1, DataSize.of((long)3L, (DataSize.Unit)DataSize.Unit.KILOBYTE), "catalog6"));
        Assertions.assertThat((long)manager.getReservedUncompressedBytes()).isEqualTo(0L);
        Assertions.assertThatThrownBy(() -> manager.put(QUERY_2_STAGE_2, TestTaskDescriptorStorage.createTaskDescriptor(3, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE)))).matches(TestTaskDescriptorStorage::isStorageCapacityExceededFailure);
        Assertions.assertThatThrownBy(() -> manager.get(QUERY_2_STAGE_1, 0)).matches(TestTaskDescriptorStorage::isStorageCapacityExceededFailure);
        Assertions.assertThatThrownBy(() -> manager.remove(QUERY_2_STAGE_1, 0)).matches(TestTaskDescriptorStorage::isStorageCapacityExceededFailure);
    }

    @Test
    public void testCompression() {
        boolean lastRun;
        TaskDescriptorStorage manager = TestTaskDescriptorStorage.createTaskDescriptorStorage(DataSize.of((long)150L, (DataSize.Unit)DataSize.Unit.KILOBYTE), DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.KILOBYTE), DataSize.of((long)80L, (DataSize.Unit)DataSize.Unit.KILOBYTE));
        manager.initialize(QUERY_1);
        manager.initialize(QUERY_2);
        manager.put(QUERY_1_STAGE_1, TestTaskDescriptorStorage.createTaskDescriptor(0, DataSize.of((long)20L, (DataSize.Unit)DataSize.Unit.KILOBYTE), "catalog1"));
        manager.put(QUERY_1_STAGE_1, TestTaskDescriptorStorage.createTaskDescriptor(1, DataSize.of((long)20L, (DataSize.Unit)DataSize.Unit.KILOBYTE), "catalog2"));
        manager.put(QUERY_1_STAGE_2, TestTaskDescriptorStorage.createTaskDescriptor(0, DataSize.of((long)20L, (DataSize.Unit)DataSize.Unit.KILOBYTE), "catalog3"));
        long q1Bytes = manager.getReservedUncompressedBytes();
        manager.put(QUERY_2_STAGE_1, TestTaskDescriptorStorage.createTaskDescriptor(2, DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.KILOBYTE), "catalog4"));
        manager.put(QUERY_2_STAGE_2, TestTaskDescriptorStorage.createTaskDescriptor(0, DataSize.of((long)20L, (DataSize.Unit)DataSize.Unit.KILOBYTE), "catalog5"));
        Assertions.assertThat((long)manager.getReservedUncompressedBytes()).isGreaterThanOrEqualTo(TestTaskDescriptorStorage.toBytes(90, DataSize.Unit.KILOBYTE)).isLessThanOrEqualTo(TestTaskDescriptorStorage.toBytes(100, DataSize.Unit.KILOBYTE));
        Assertions.assertThat((long)manager.getReservedCompressedBytes()).isEqualTo(0L);
        Assertions.assertThat((long)manager.getOriginalCompressedBytes()).isEqualTo(0L);
        manager.put(QUERY_2_STAGE_2, TestTaskDescriptorStorage.createTaskDescriptor(1, DataSize.of((long)20L, (DataSize.Unit)DataSize.Unit.KILOBYTE), "catalog3"));
        Assertions.assertThat((long)manager.getReservedUncompressedBytes()).isGreaterThanOrEqualTo(TestTaskDescriptorStorage.toBytes(100, DataSize.Unit.KILOBYTE));
        Assertions.assertThat((long)manager.getReservedCompressedBytes()).isEqualTo(0L);
        Assertions.assertThat((long)manager.getOriginalCompressedBytes()).isEqualTo(0L);
        long reservedUncompressedBytesOnHighWater = manager.getReservedUncompressedBytes();
        manager.put(QUERY_2_STAGE_2, TestTaskDescriptorStorage.createTaskDescriptor(2, DataSize.of((long)20L, (DataSize.Unit)DataSize.Unit.KILOBYTE), "catalog3"));
        Assertions.assertThat((long)manager.getReservedUncompressedBytes()).isEqualTo(reservedUncompressedBytesOnHighWater);
        Assertions.assertThat((long)manager.getReservedCompressedBytes()).isGreaterThan(0L);
        Assertions.assertThat((long)manager.getOriginalCompressedBytes()).isGreaterThan(TestTaskDescriptorStorage.toBytes(20, DataSize.Unit.KILOBYTE));
        long singleTaskCompressedSize = manager.getReservedCompressedBytes();
        manager.put(QUERY_2_STAGE_2, TestTaskDescriptorStorage.createTaskDescriptor(3, DataSize.of((long)200L, (DataSize.Unit)DataSize.Unit.KILOBYTE), "catalog3"));
        manager.put(QUERY_2_STAGE_2, TestTaskDescriptorStorage.createTaskDescriptor(4, DataSize.of((long)200L, (DataSize.Unit)DataSize.Unit.KILOBYTE), "catalog3"));
        Assertions.assertThat((long)manager.getReservedUncompressedBytes()).isEqualTo(reservedUncompressedBytesOnHighWater);
        Assertions.assertThat((long)manager.getReservedCompressedBytes()).isGreaterThan(0L);
        Assertions.assertThat((long)manager.getOriginalCompressedBytes()).isGreaterThan(TestTaskDescriptorStorage.toBytes(420, DataSize.Unit.KILOBYTE));
        int i = 5;
        do {
            lastRun = manager.getReservedCompressedBytes() + manager.getReservedUncompressedBytes() + singleTaskCompressedSize > DataSize.of((long)150L, (DataSize.Unit)DataSize.Unit.KILOBYTE).toBytes();
            manager.put(QUERY_2_STAGE_2, TestTaskDescriptorStorage.createTaskDescriptor(i++, DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.KILOBYTE), "catalog3"));
        } while (!lastRun);
        Assertions.assertThatThrownBy(() -> manager.put(QUERY_2_STAGE_2, TestTaskDescriptorStorage.createTaskDescriptor(1001, DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.KILOBYTE), "catalog3"))).hasMessageContaining("Task descriptor storage capacity has been exceeded");
        Assertions.assertThat((long)manager.getReservedUncompressedBytes()).isEqualTo(q1Bytes);
        Assertions.assertThat((long)manager.getReservedCompressedBytes()).isEqualTo(0L);
        Assertions.assertThat((long)manager.getOriginalCompressedBytes()).isEqualTo(0L);
        manager.put(QUERY_1_STAGE_2, TestTaskDescriptorStorage.createTaskDescriptor(1, DataSize.of((long)20L, (DataSize.Unit)DataSize.Unit.KILOBYTE), "catalog3"));
        Assertions.assertThat((long)manager.getReservedUncompressedBytes()).isGreaterThan(q1Bytes);
        Assertions.assertThat((long)manager.getReservedCompressedBytes()).isEqualTo(0L);
        Assertions.assertThat((long)manager.getOriginalCompressedBytes()).isEqualTo(0L);
        manager.put(QUERY_1_STAGE_2, TestTaskDescriptorStorage.createTaskDescriptor(2, DataSize.of((long)50L, (DataSize.Unit)DataSize.Unit.KILOBYTE), "catalog3"));
        manager.put(QUERY_1_STAGE_2, TestTaskDescriptorStorage.createTaskDescriptor(3, DataSize.of((long)50L, (DataSize.Unit)DataSize.Unit.KILOBYTE), "catalog3"));
        manager.put(QUERY_1_STAGE_2, TestTaskDescriptorStorage.createTaskDescriptor(4, DataSize.of((long)50L, (DataSize.Unit)DataSize.Unit.KILOBYTE), "catalog3"));
        Assertions.assertThat((long)manager.getReservedUncompressedBytes()).isGreaterThan(0L);
        Assertions.assertThat((long)manager.getReservedCompressedBytes()).isGreaterThan(0L);
        Assertions.assertThat((long)manager.getOriginalCompressedBytes()).isGreaterThan(0L);
        manager.remove(QUERY_1_STAGE_1, 0);
        manager.remove(QUERY_1_STAGE_1, 1);
        manager.remove(QUERY_1_STAGE_2, 0);
        manager.remove(QUERY_1_STAGE_2, 1);
        manager.remove(QUERY_1_STAGE_2, 2);
        manager.remove(QUERY_1_STAGE_2, 3);
        manager.remove(QUERY_1_STAGE_2, 4);
        Assertions.assertThat((long)manager.getReservedUncompressedBytes()).isEqualTo(0L);
        Assertions.assertThat((long)manager.getReservedCompressedBytes()).isEqualTo(0L);
        Assertions.assertThat((long)manager.getOriginalCompressedBytes()).isEqualTo(0L);
    }

    @Test
    @Timeout(value=20L)
    public void testBackgroundCompression() {
        TaskDescriptorStorage manager = TestTaskDescriptorStorage.createTaskDescriptorStorage(DataSize.of((long)150L, (DataSize.Unit)DataSize.Unit.KILOBYTE), DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.KILOBYTE), DataSize.of((long)80L, (DataSize.Unit)DataSize.Unit.KILOBYTE));
        manager.initialize(QUERY_1);
        manager.initialize(QUERY_2);
        manager.put(QUERY_1_STAGE_1, TestTaskDescriptorStorage.createTaskDescriptor(0, DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.KILOBYTE), "catalog1"));
        manager.put(QUERY_1_STAGE_2, TestTaskDescriptorStorage.createTaskDescriptor(0, DataSize.of((long)20L, (DataSize.Unit)DataSize.Unit.KILOBYTE), "catalog1"));
        manager.put(QUERY_2_STAGE_1, TestTaskDescriptorStorage.createTaskDescriptor(0, DataSize.of((long)20L, (DataSize.Unit)DataSize.Unit.KILOBYTE), "catalog1"));
        manager.put(QUERY_1_STAGE_1, TestTaskDescriptorStorage.createTaskDescriptor(1, DataSize.of((long)40L, (DataSize.Unit)DataSize.Unit.KILOBYTE), "catalog1"));
        manager.put(QUERY_1_STAGE_1, TestTaskDescriptorStorage.createTaskDescriptor(2, DataSize.of((long)40L, (DataSize.Unit)DataSize.Unit.KILOBYTE), "catalog1"));
        manager.put(QUERY_2_STAGE_1, TestTaskDescriptorStorage.createTaskDescriptor(1, DataSize.of((long)40L, (DataSize.Unit)DataSize.Unit.KILOBYTE), "catalog1"));
        manager.put(QUERY_2_STAGE_1, TestTaskDescriptorStorage.createTaskDescriptor(2, DataSize.of((long)40L, (DataSize.Unit)DataSize.Unit.KILOBYTE), "catalog1"));
        Assertions.assertThat((long)manager.getReservedUncompressedBytes()).isGreaterThan(0L);
        Assertions.assertThat((long)manager.getReservedCompressedBytes()).isGreaterThan(0L);
        Assertions.assertThat((long)manager.getOriginalCompressedBytes()).isGreaterThan(0L);
        manager.start();
        Assert.assertEventually(() -> {
            Assertions.assertThat((long)manager.getReservedUncompressedBytes()).isEqualTo(0L);
            Assertions.assertThat((long)manager.getReservedCompressedBytes()).isGreaterThan(0L);
            Assertions.assertThat((long)manager.getOriginalCompressedBytes()).isGreaterThan(0L);
        });
        manager.stop();
    }

    private static TaskDescriptorStorage createTaskDescriptorStorage(DataSize maxMemory, DataSize compressingHighWaterMark, DataSize compressingLowWaterMark) {
        Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), new HandleJsonModule(), binder -> {
            binder.bind(JsonMapper.class).in(Singleton.class);
            JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(TaskDescriptor.class);
            JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(Split.class);
        }});
        Injector injector = app.initialize();
        JsonCodec taskDescriptorJsonCodec = (JsonCodec)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<JsonCodec<TaskDescriptor>>(){}));
        JsonCodec splitJsonCodec = (JsonCodec)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<JsonCodec<Split>>(){}));
        TaskDescriptorStorage manager = new TaskDescriptorStorage(maxMemory, compressingHighWaterMark, compressingLowWaterMark, taskDescriptorJsonCodec, splitJsonCodec);
        return manager;
    }

    private static TaskDescriptor createTaskDescriptor(int partitionId, DataSize retainedSize) {
        return TestTaskDescriptorStorage.createTaskDescriptor(partitionId, retainedSize, Optional.empty());
    }

    private static TaskDescriptor createTaskDescriptor(int partitionId, DataSize retainedSize, String catalogName) {
        return TestTaskDescriptorStorage.createTaskDescriptor(partitionId, retainedSize, Optional.of(TestingHandles.createTestCatalogHandle((String)catalogName)));
    }

    private static TaskDescriptor createTaskDescriptor(int partitionId, DataSize retainedSize, Optional<CatalogHandle> catalog) {
        return new TaskDescriptor(partitionId, SplitsMapping.builder().addSplit(new PlanNodeId("1"), 1, new Split(ExchangeOperator.REMOTE_CATALOG_HANDLE, (ConnectorSplit)new RemoteSplit((ExchangeInput)new SpoolingExchangeInput((List)ImmutableList.of((Object)new TestingExchangeSourceHandle(retainedSize.toBytes())), Optional.empty())))).build(), new NodeRequirements(catalog, Optional.empty(), true));
    }

    private static Optional<String> getCatalogName(TaskDescriptor descriptor) {
        return descriptor.getNodeRequirements().getCatalogHandle().map(CatalogHandle::getCatalogName).map(CatalogName::toString);
    }

    private static boolean isStorageCapacityExceededFailure(Throwable t) {
        if (!(t instanceof TrinoException)) {
            return false;
        }
        TrinoException trinoException = (TrinoException)t;
        return trinoException.getErrorCode().getCode() == StandardErrorCode.EXCEEDED_TASK_DESCRIPTOR_STORAGE_CAPACITY.toErrorCode().getCode();
    }

    private static long toBytes(int size, DataSize.Unit unit) {
        return DataSize.of((long)size, (DataSize.Unit)unit).toBytes();
    }

    public static class TestingExchangeSourceHandle
    implements ExchangeSourceHandle {
        private final long retainedSizeInBytes;

        @JsonCreator
        public TestingExchangeSourceHandle(@JsonProperty(value="retainedSizeInBytes") long retainedSizeInBytes) {
            this.retainedSizeInBytes = retainedSizeInBytes;
        }

        public int getPartitionId() {
            return 0;
        }

        public long getDataSizeInBytes() {
            return 0L;
        }

        @JsonProperty
        public long getRetainedSizeInBytes() {
            return this.retainedSizeInBytes;
        }
    }
}

