/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import io.trino.block.BlockAssertions;
import io.trino.operator.FlatHashStrategy;
import io.trino.operator.FlatHashStrategyCompiler;
import io.trino.spi.block.Block;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.block.VariableWidthBlock;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import java.util.Arrays;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TestFlatHashStrategyCompiler {
    private static final TypeOperators TYPE_OPERATORS = new TypeOperators();

    TestFlatHashStrategyCompiler() {
    }

    @Test
    void test() {
        FlatHashStrategyCompiler.compileFlatHashStrategy(Collections.nCopies(2001, BigintType.BIGINT), (TypeOperators)TYPE_OPERATORS);
        FlatHashStrategyCompiler.compileFlatHashStrategy(Collections.nCopies(2001, VarcharType.VARCHAR), (TypeOperators)TYPE_OPERATORS);
    }

    @Test
    public void testMultiChunkIdenticalAndHash() {
        int[] testColumns;
        for (int columns : testColumns = new int[]{499, 500, 501}) {
            TestFlatHashStrategyCompiler.testVariableWidthColumns(columns);
            TestFlatHashStrategyCompiler.testFixedWidthColumns(columns);
        }
    }

    private static void testVariableWidthColumns(int columns) {
        Block[] variableBlocks = TestFlatHashStrategyCompiler.createVariableWidthTestColumns(columns);
        FlatHashStrategy hashStrategy = FlatHashStrategyCompiler.compileFlatHashStrategy(Collections.nCopies(columns, VarcharType.VARCHAR), (TypeOperators)TYPE_OPERATORS);
        byte[] fixedChunk = new byte[hashStrategy.getTotalFlatFixedLength()];
        int variableLength = Math.toIntExact(Arrays.stream(variableBlocks).mapToLong(block -> VarcharType.VARCHAR.getFlatVariableWidthSize(block, 0)).sum());
        byte[] variableChunk = new byte[variableLength];
        hashStrategy.writeFlat(variableBlocks, 0, fixedChunk, 0, variableChunk, 0);
        Assertions.assertThat((boolean)hashStrategy.valueIdentical(fixedChunk, 0, variableChunk, 0, variableBlocks, 0)).isTrue();
        long blocksHash = hashStrategy.hash(variableBlocks, 0);
        Assertions.assertThat((long)hashStrategy.hash(fixedChunk, 0, variableChunk, 0)).isEqualTo(blocksHash);
    }

    private static void testFixedWidthColumns(int columns) {
        Block[] fixedBlocks = TestFlatHashStrategyCompiler.createFixedWidthTestColumns(columns);
        FlatHashStrategy hashStrategy = FlatHashStrategyCompiler.compileFlatHashStrategy(Collections.nCopies(columns, BigintType.BIGINT), (TypeOperators)TYPE_OPERATORS);
        byte[] fixedChunk = new byte[hashStrategy.getTotalFlatFixedLength()];
        byte[] variableChunk = null;
        hashStrategy.writeFlat(fixedBlocks, 0, fixedChunk, 0, fixedChunk, 0);
        Assertions.assertThat((boolean)hashStrategy.valueIdentical(fixedChunk, 0, variableChunk, 0, fixedBlocks, 0)).isTrue();
        long blocksHash = hashStrategy.hash(fixedBlocks, 0);
        Assertions.assertThat((long)hashStrategy.hash(fixedChunk, 0, variableChunk, 0)).isEqualTo(blocksHash);
    }

    private static Block[] createVariableWidthTestColumns(int columns) {
        VariableWidthBlock nonNullBlock = BlockAssertions.createStringsBlock("test string");
        ValueBlock nullsBlock = VarcharType.VARCHAR.createBlockBuilder(null, 1).appendNull().buildValueBlock();
        Block[] blocks = new Block[columns];
        for (int i = 0; i < columns; ++i) {
            blocks[i] = i % 2 == 0 ? nullsBlock : nonNullBlock;
        }
        return blocks;
    }

    private static Block[] createFixedWidthTestColumns(int columns) {
        ValueBlock nonNullBlock = BlockAssertions.createLongsBlock(0x80000000L);
        ValueBlock nullsBlock = BigintType.BIGINT.createBlockBuilder(null, 1).appendNull().buildValueBlock();
        Block[] blocks = new Block[columns];
        for (int i = 0; i < columns; ++i) {
            blocks[i] = i % 2 == 0 ? nullsBlock : nonNullBlock;
        }
        return blocks;
    }
}

