/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.trino.operator.aggregation.AbstractTestAggregationFunction;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.DateType;
import io.trino.spi.type.SqlDate;
import io.trino.spi.type.Type;
import java.util.List;

public class TestDateMaxAggregation
extends AbstractTestAggregationFunction {
    @Override
    protected Block[] getSequenceBlocks(int start, int length) {
        BlockBuilder blockBuilder = DateType.DATE.createFixedSizeBlockBuilder(length);
        for (int i = start; i < start + length; ++i) {
            DateType.DATE.writeLong(blockBuilder, (long)i);
        }
        return new Block[]{blockBuilder.build()};
    }

    protected SqlDate getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        return new SqlDate(start + length - 1);
    }

    @Override
    protected String getFunctionName() {
        return "max";
    }

    @Override
    protected List<Type> getFunctionParameterTypes() {
        return ImmutableList.of((Object)DateType.DATE);
    }
}

