/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.project;

import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.Threads;
import io.trino.block.BlockAssertions;
import io.trino.operator.DriverYieldSignal;
import io.trino.operator.Work;
import io.trino.operator.project.DictionaryAwarePageProjection;
import io.trino.operator.project.InputChannels;
import io.trino.operator.project.InputPageProjection;
import io.trino.operator.project.PageProjection;
import io.trino.operator.project.SelectedPositions;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.DictionaryId;
import io.trino.spi.block.LazyBlock;
import io.trino.spi.block.LongArrayBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SourcePage;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestDictionaryAwarePageProjection {
    private static final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"TestDictionaryAwarePageProjection-%s"));

    @AfterAll
    public void tearDown() {
        executor.shutdownNow();
    }

    @Test
    public void testDelegateMethods() {
        DictionaryAwarePageProjection projection = TestDictionaryAwarePageProjection.createProjection(false);
        Assertions.assertThat((boolean)projection.isDeterministic()).isEqualTo(true);
        Assertions.assertThat((List)projection.getInputChannels().getInputChannels()).isEqualTo((Object)ImmutableList.of((Object)3));
        Assertions.assertThat((Object)projection.getType()).isEqualTo((Object)BigintType.BIGINT);
    }

    @Test
    public void testSimpleBlock() {
        ValueBlock block = BlockAssertions.createLongSequenceBlock(0, 100);
        TestDictionaryAwarePageProjection.testProject((Block)block, block.getClass(), true, false);
        TestDictionaryAwarePageProjection.testProject((Block)block, block.getClass(), false, true);
        TestDictionaryAwarePageProjection.testProject((Block)block, block.getClass(), false, false);
    }

    @Test
    public void testRleBlock() {
        ValueBlock value = BlockAssertions.createLongSequenceBlock(42, 43);
        RunLengthEncodedBlock block = (RunLengthEncodedBlock)RunLengthEncodedBlock.create((Block)value, (int)100);
        TestDictionaryAwarePageProjection.testProject((Block)block, RunLengthEncodedBlock.class, true, false);
        TestDictionaryAwarePageProjection.testProject((Block)block, RunLengthEncodedBlock.class, false, true);
        TestDictionaryAwarePageProjection.testProject((Block)block, RunLengthEncodedBlock.class, false, false);
    }

    @Test
    public void testRleBlockWithFailure() {
        ValueBlock value = BlockAssertions.createLongSequenceBlock(-43, -42);
        RunLengthEncodedBlock block = (RunLengthEncodedBlock)RunLengthEncodedBlock.create((Block)value, (int)100);
        TestDictionaryAwarePageProjection.testProjectFails((Block)block, RunLengthEncodedBlock.class, true, false);
        TestDictionaryAwarePageProjection.testProjectFails((Block)block, RunLengthEncodedBlock.class, false, true);
        TestDictionaryAwarePageProjection.testProjectFails((Block)block, RunLengthEncodedBlock.class, false, false);
    }

    @Test
    public void testDictionaryBlock() {
        Block block = TestDictionaryAwarePageProjection.createDictionaryBlock(10, 100);
        TestDictionaryAwarePageProjection.testProject(block, DictionaryBlock.class, true, false);
        TestDictionaryAwarePageProjection.testProject(block, DictionaryBlock.class, false, true);
        TestDictionaryAwarePageProjection.testProject(block, DictionaryBlock.class, false, false);
    }

    @Test
    public void testDictionaryBlockWithFailure() {
        Block block = TestDictionaryAwarePageProjection.createDictionaryBlockWithFailure(10, 100);
        TestDictionaryAwarePageProjection.testProjectFails(block, DictionaryBlock.class, true, false);
        TestDictionaryAwarePageProjection.testProjectFails(block, DictionaryBlock.class, false, true);
        TestDictionaryAwarePageProjection.testProjectFails(block, DictionaryBlock.class, false, false);
    }

    @Test
    public void testDictionaryBlockProcessingWithUnusedFailure() {
        Block block = TestDictionaryAwarePageProjection.createDictionaryBlockWithUnusedEntries(10, 100);
        TestDictionaryAwarePageProjection.testProject(block, LongArrayBlock.class, true, false);
        TestDictionaryAwarePageProjection.testProject(block, LongArrayBlock.class, false, true);
        TestDictionaryAwarePageProjection.testProject(block, LongArrayBlock.class, false, false);
    }

    @Test
    public void testDictionaryProcessingIgnoreYield() {
        DictionaryAwarePageProjection projection = TestDictionaryAwarePageProjection.createProjection(false);
        Block block = TestDictionaryAwarePageProjection.createDictionaryBlock(10, 100);
        TestDictionaryAwarePageProjection.testProjectRange(block, DictionaryBlock.class, projection, true, false);
        TestDictionaryAwarePageProjection.testProjectFastReturnIgnoreYield(block, projection, false);
        TestDictionaryAwarePageProjection.testProjectFastReturnIgnoreYield(block, projection, false);
        TestDictionaryAwarePageProjection.testProjectFastReturnIgnoreYield(block, projection, false);
    }

    @Test
    public void testDictionaryProcessingEnableDisable() {
        this.testDictionaryProcessingEnableDisable(true, false);
        this.testDictionaryProcessingEnableDisable(false, true);
        this.testDictionaryProcessingEnableDisable(false, false);
    }

    private void testDictionaryProcessingEnableDisable(boolean forceYield, boolean produceLazyBlock) {
        DictionaryAwarePageProjection projection = TestDictionaryAwarePageProjection.createProjection(produceLazyBlock);
        Block ineffectiveBlock = TestDictionaryAwarePageProjection.createDictionaryBlock(100, 20);
        TestDictionaryAwarePageProjection.testProjectRange(ineffectiveBlock, DictionaryBlock.class, projection, forceYield, produceLazyBlock);
        TestDictionaryAwarePageProjection.testProjectFastReturnIgnoreYield(ineffectiveBlock, projection, produceLazyBlock);
        TestDictionaryAwarePageProjection.testProjectList(ineffectiveBlock, DictionaryBlock.class, projection, false, produceLazyBlock);
        Block anotherIneffectiveBlock = TestDictionaryAwarePageProjection.createDictionaryBlock(100, 25);
        TestDictionaryAwarePageProjection.testProjectRange(anotherIneffectiveBlock, LongArrayBlock.class, projection, forceYield, produceLazyBlock);
        TestDictionaryAwarePageProjection.testProjectList(anotherIneffectiveBlock, LongArrayBlock.class, projection, forceYield, produceLazyBlock);
        for (int i = 0; i < 15; ++i) {
            TestDictionaryAwarePageProjection.testProjectRange(anotherIneffectiveBlock, LongArrayBlock.class, projection, forceYield, produceLazyBlock);
        }
        TestDictionaryAwarePageProjection.testProjectRange(ineffectiveBlock, DictionaryBlock.class, projection, forceYield, produceLazyBlock);
        TestDictionaryAwarePageProjection.testProjectFastReturnIgnoreYield(ineffectiveBlock, projection, produceLazyBlock);
        TestDictionaryAwarePageProjection.testProjectList(ineffectiveBlock, DictionaryBlock.class, projection, false, produceLazyBlock);
        Block effectiveBlock = TestDictionaryAwarePageProjection.createDictionaryBlock(10, 100);
        TestDictionaryAwarePageProjection.testProjectRange(effectiveBlock, DictionaryBlock.class, projection, forceYield, produceLazyBlock);
        TestDictionaryAwarePageProjection.testProjectFastReturnIgnoreYield(effectiveBlock, projection, produceLazyBlock);
    }

    @Test
    public void testPreservesDictionaryInstance() {
        DictionaryAwarePageProjection projection = new DictionaryAwarePageProjection((PageProjection)new InputPageProjection(0, (Type)BigintType.BIGINT), block -> DictionaryId.randomDictionaryId(), false);
        ValueBlock dictionary = BlockAssertions.createLongsBlock(0, 1);
        Block firstDictionaryBlock = DictionaryBlock.create((int)4, (Block)dictionary, (int[])new int[]{0, 1, 2, 3});
        Block secondDictionaryBlock = DictionaryBlock.create((int)4, (Block)dictionary, (int[])new int[]{3, 2, 1, 0});
        DriverYieldSignal yieldSignal = new DriverYieldSignal();
        Work firstWork = projection.project(null, yieldSignal, SourcePage.create((Block)firstDictionaryBlock), SelectedPositions.positionsList((int[])new int[]{0, 1}, (int)0, (int)2));
        Assertions.assertThat((boolean)firstWork.process()).isTrue();
        Block firstOutputBlock = (Block)firstWork.getResult();
        Assertions.assertThat((Object)firstOutputBlock).isInstanceOf(DictionaryBlock.class);
        Work secondWork = projection.project(null, yieldSignal, SourcePage.create((Block)secondDictionaryBlock), SelectedPositions.positionsList((int[])new int[]{0, 1}, (int)0, (int)2));
        Assertions.assertThat((boolean)secondWork.process()).isTrue();
        Block secondOutputBlock = (Block)secondWork.getResult();
        Assertions.assertThat((Object)secondOutputBlock).isInstanceOf(DictionaryBlock.class);
        Assertions.assertThat((Object)firstOutputBlock).isNotSameAs((Object)secondOutputBlock);
        ValueBlock firstDictionary = ((DictionaryBlock)firstOutputBlock).getDictionary();
        ValueBlock secondDictionary = ((DictionaryBlock)secondOutputBlock).getDictionary();
        Assertions.assertThat((Object)firstDictionary).isSameAs((Object)secondDictionary);
        Assertions.assertThat((Object)firstDictionary).isSameAs((Object)dictionary);
    }

    private static Block createDictionaryBlock(int dictionarySize, int blockSize) {
        ValueBlock dictionary = BlockAssertions.createLongSequenceBlock(0, dictionarySize);
        int[] ids = new int[blockSize];
        Arrays.setAll(ids, index -> index % dictionarySize);
        return DictionaryBlock.create((int)ids.length, (Block)dictionary, (int[])ids);
    }

    private static Block createDictionaryBlockWithFailure(int dictionarySize, int blockSize) {
        ValueBlock dictionary = BlockAssertions.createLongSequenceBlock(-10, dictionarySize - 10);
        int[] ids = new int[blockSize];
        Arrays.setAll(ids, index -> index % dictionarySize);
        return DictionaryBlock.create((int)ids.length, (Block)dictionary, (int[])ids);
    }

    private static Block createDictionaryBlockWithUnusedEntries(int dictionarySize, int blockSize) {
        ValueBlock dictionary = BlockAssertions.createLongSequenceBlock(-10, dictionarySize);
        int[] ids = new int[blockSize];
        Arrays.setAll(ids, index -> index % dictionarySize + 10);
        return DictionaryBlock.create((int)ids.length, (Block)dictionary, (int[])ids);
    }

    private static Block projectWithYield(Work<Block> work, DriverYieldSignal yieldSignal) {
        int yieldCount = 0;
        while (true) {
            yieldSignal.setWithDelay(1L, executor);
            yieldSignal.forceYieldForTesting();
            if (work.process()) {
                Assertions.assertThat((int)yieldCount).isGreaterThan(0);
                return (Block)work.getResult();
            }
            if (++yieldCount > 1000000) {
                Fail.fail((String)"projection is not making progress");
            }
            yieldSignal.reset();
        }
    }

    private static void testProject(Block block, Class<? extends Block> expectedResultType, boolean forceYield, boolean produceLazyBlock) {
        TestDictionaryAwarePageProjection.testProjectRange(block, expectedResultType, TestDictionaryAwarePageProjection.createProjection(produceLazyBlock), forceYield, produceLazyBlock);
        TestDictionaryAwarePageProjection.testProjectList(block, expectedResultType, TestDictionaryAwarePageProjection.createProjection(produceLazyBlock), forceYield, produceLazyBlock);
        TestDictionaryAwarePageProjection.testProjectRange((Block)TestDictionaryAwarePageProjection.lazyWrapper(block), expectedResultType, TestDictionaryAwarePageProjection.createProjection(produceLazyBlock), forceYield, produceLazyBlock);
        TestDictionaryAwarePageProjection.testProjectList((Block)TestDictionaryAwarePageProjection.lazyWrapper(block), expectedResultType, TestDictionaryAwarePageProjection.createProjection(produceLazyBlock), forceYield, produceLazyBlock);
    }

    private static void testProjectFails(Block block, Class<? extends Block> expectedResultType, boolean forceYield, boolean produceLazyBlock) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestDictionaryAwarePageProjection.testProjectRange(block, expectedResultType, TestDictionaryAwarePageProjection.createProjection(produceLazyBlock), forceYield, produceLazyBlock)).isInstanceOf(NegativeValueException.class)).hasMessageContaining("value is negative");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestDictionaryAwarePageProjection.testProjectList(block, expectedResultType, TestDictionaryAwarePageProjection.createProjection(produceLazyBlock), forceYield, produceLazyBlock)).isInstanceOf(NegativeValueException.class)).hasMessageContaining("value is negative");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestDictionaryAwarePageProjection.testProjectRange((Block)TestDictionaryAwarePageProjection.lazyWrapper(block), expectedResultType, TestDictionaryAwarePageProjection.createProjection(produceLazyBlock), forceYield, produceLazyBlock)).isInstanceOf(NegativeValueException.class)).hasMessageContaining("value is negative");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestDictionaryAwarePageProjection.testProjectList((Block)TestDictionaryAwarePageProjection.lazyWrapper(block), expectedResultType, TestDictionaryAwarePageProjection.createProjection(produceLazyBlock), forceYield, produceLazyBlock)).isInstanceOf(NegativeValueException.class)).hasMessageContaining("value is negative");
    }

    private static void testProjectRange(Block block, Class<? extends Block> expectedResultType, DictionaryAwarePageProjection projection, boolean forceYield, boolean produceLazyBlock) {
        Block result;
        if (produceLazyBlock) {
            block = TestDictionaryAwarePageProjection.lazyWrapper(block);
        }
        DriverYieldSignal yieldSignal = new DriverYieldSignal();
        Work work = projection.project(null, yieldSignal, SourcePage.create((Block)block), SelectedPositions.positionsRange((int)5, (int)10));
        if (forceYield) {
            result = TestDictionaryAwarePageProjection.projectWithYield((Work<Block>)work, yieldSignal);
        } else {
            Assertions.assertThat((boolean)work.process()).isTrue();
            result = (Block)work.getResult();
        }
        if (produceLazyBlock) {
            Assertions.assertThat((Object)result).isInstanceOf(LazyBlock.class);
            Assertions.assertThat((boolean)result.isLoaded()).isFalse();
            Assertions.assertThat((boolean)block.isLoaded()).isFalse();
            result = result.getLoadedBlock();
        }
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, result, block.getRegion(5, 10));
        Assertions.assertThat((Object)result).isInstanceOf(expectedResultType);
    }

    private static void testProjectList(Block block, Class<? extends Block> expectedResultType, DictionaryAwarePageProjection projection, boolean forceYield, boolean produceLazyBlock) {
        Block result;
        if (produceLazyBlock) {
            block = TestDictionaryAwarePageProjection.lazyWrapper(block);
        }
        DriverYieldSignal yieldSignal = new DriverYieldSignal();
        int[] positions = new int[]{0, 2, 4, 6, 8, 10};
        Work work = projection.project(null, yieldSignal, SourcePage.create((Block)block), SelectedPositions.positionsList((int[])positions, (int)0, (int)positions.length));
        if (forceYield) {
            result = TestDictionaryAwarePageProjection.projectWithYield((Work<Block>)work, yieldSignal);
        } else {
            Assertions.assertThat((boolean)work.process()).isTrue();
            result = (Block)work.getResult();
        }
        if (produceLazyBlock) {
            Assertions.assertThat((Object)result).isInstanceOf(LazyBlock.class);
            Assertions.assertThat((boolean)result.isLoaded()).isFalse();
            Assertions.assertThat((boolean)block.isLoaded()).isFalse();
            result = result.getLoadedBlock();
        }
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, result, block.copyPositions(positions, 0, positions.length));
        Assertions.assertThat((Object)result).isInstanceOf(expectedResultType);
    }

    private static void testProjectFastReturnIgnoreYield(Block block, DictionaryAwarePageProjection projection, boolean produceLazyBlock) {
        if (produceLazyBlock) {
            block = TestDictionaryAwarePageProjection.lazyWrapper(block);
        }
        DriverYieldSignal yieldSignal = new DriverYieldSignal();
        Work work = projection.project(null, yieldSignal, SourcePage.create((Block)block), SelectedPositions.positionsRange((int)5, (int)10));
        yieldSignal.setWithDelay(1L, executor);
        yieldSignal.forceYieldForTesting();
        Assertions.assertThat((boolean)work.process()).isTrue();
        Block result = (Block)work.getResult();
        yieldSignal.reset();
        if (produceLazyBlock) {
            Assertions.assertThat((Object)result).isInstanceOf(LazyBlock.class);
            Assertions.assertThat((boolean)result.isLoaded()).isFalse();
            Assertions.assertThat((boolean)block.isLoaded()).isFalse();
            result = result.getLoadedBlock();
        }
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, result, block.getRegion(5, 10));
        Assertions.assertThat((Object)result).isInstanceOf(DictionaryBlock.class);
    }

    private static DictionaryAwarePageProjection createProjection(boolean produceLazyBlock) {
        return new DictionaryAwarePageProjection((PageProjection)new TestPageProjection(), block -> DictionaryId.randomDictionaryId(), produceLazyBlock);
    }

    private static LazyBlock lazyWrapper(Block block) {
        return new LazyBlock(block.getPositionCount(), () -> ((Block)block).getLoadedBlock());
    }

    private static class NegativeValueException
    extends RuntimeException {
        public NegativeValueException(long value) {
            super("value is negative: " + value);
        }
    }

    private static class TestPageProjection
    implements PageProjection {
        private TestPageProjection() {
        }

        public Type getType() {
            return BigintType.BIGINT;
        }

        public boolean isDeterministic() {
            return true;
        }

        public InputChannels getInputChannels() {
            return new InputChannels(new int[]{3});
        }

        public Work<Block> project(ConnectorSession session, DriverYieldSignal yieldSignal, SourcePage page, SelectedPositions selectedPositions) {
            return new TestPageProjectionWork(yieldSignal, page, selectedPositions);
        }

        private static long verifyPositive(long value) {
            if (value < 0L) {
                throw new NegativeValueException(value);
            }
            return value;
        }

        private static class TestPageProjectionWork
        implements Work<Block> {
            private final DriverYieldSignal yieldSignal;
            private final Block block;
            private final SelectedPositions selectedPositions;
            private BlockBuilder blockBuilder;
            private int nextIndexOrPosition;
            private Block result;

            public TestPageProjectionWork(DriverYieldSignal yieldSignal, SourcePage page, SelectedPositions selectedPositions) {
                this.yieldSignal = yieldSignal;
                this.block = page.getBlock(0);
                this.selectedPositions = selectedPositions;
                this.blockBuilder = BigintType.BIGINT.createFixedSizeBlockBuilder(selectedPositions.size());
            }

            public boolean process() {
                Assertions.assertThat((Object)this.result).isNull();
                if (this.selectedPositions.isList()) {
                    int offset = this.selectedPositions.getOffset();
                    int[] positions = this.selectedPositions.getPositions();
                    for (int index = this.nextIndexOrPosition + offset; index < offset + this.selectedPositions.size(); ++index) {
                        BigintType.BIGINT.writeLong(this.blockBuilder, TestPageProjection.verifyPositive(BigintType.BIGINT.getLong(this.block, positions[index])));
                        if (!this.yieldSignal.isSet()) continue;
                        this.nextIndexOrPosition = index + 1 - offset;
                        return false;
                    }
                } else {
                    int offset = this.selectedPositions.getOffset();
                    for (int position = this.nextIndexOrPosition + offset; position < offset + this.selectedPositions.size(); ++position) {
                        BigintType.BIGINT.writeLong(this.blockBuilder, TestPageProjection.verifyPositive(BigintType.BIGINT.getLong(this.block, position)));
                        if (!this.yieldSignal.isSet()) continue;
                        this.nextIndexOrPosition = position + 1 - offset;
                        return false;
                    }
                }
                this.result = this.blockBuilder.build();
                this.blockBuilder = this.blockBuilder.newBlockBuilderLike(null);
                return true;
            }

            public Block getResult() {
                Assertions.assertThat((Object)this.result).isNotNull();
                return this.result;
            }
        }
    }
}

