/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.project;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.block.BlockAssertions;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.operator.TestingSourcePage;
import io.trino.operator.project.PageFieldsToInputParametersRewriter;
import io.trino.spi.block.Block;
import io.trino.spi.connector.SourcePage;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.Between;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Case;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Coalesce;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.In;
import io.trino.sql.ir.Lambda;
import io.trino.sql.ir.Logical;
import io.trino.sql.ir.NullIf;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.Switch;
import io.trino.sql.ir.WhenClause;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.SqlToRowExpressionTranslator;
import io.trino.transaction.TestingTransactionManager;
import io.trino.type.FunctionType;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPageFieldsToInputParametersRewriter {
    private static final TestingTransactionManager TRANSACTION_MANAGER = new TestingTransactionManager();
    private static final PlannerContext PLANNER_CONTEXT = TestingPlannerContext.plannerContextBuilder().withTransactionManager(TRANSACTION_MANAGER).build();
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction CEIL = FUNCTIONS.resolveFunction("ceil", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT}));
    private static final ResolvedFunction ROUND = FUNCTIONS.resolveFunction("round", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT}));
    private static final ResolvedFunction TRANSFORM = FUNCTIONS.resolveFunction("transform", TypeSignatureProvider.fromTypes((Type[])new Type[]{new ArrayType((Type)BigintType.BIGINT), new FunctionType((List)ImmutableList.of((Object)BigintType.BIGINT), (Type)IntegerType.INTEGER)}));
    private static final ResolvedFunction ZIP_WITH = FUNCTIONS.resolveFunction("zip_with", TypeSignatureProvider.fromTypes((Type[])new Type[]{new ArrayType((Type)BigintType.BIGINT), new ArrayType((Type)BigintType.BIGINT), new FunctionType((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT), (Type)BigintType.BIGINT)}));
    private static final ResolvedFunction ADD_BIGINT = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
    private static final ResolvedFunction MULTIPLY_BIGINT = FUNCTIONS.resolveOperator(OperatorType.MULTIPLY, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
    private static final ResolvedFunction DIVIDE_BIGINT = FUNCTIONS.resolveOperator(OperatorType.DIVIDE, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
    private static final ResolvedFunction MULTIPLY_INTEGER = FUNCTIONS.resolveOperator(OperatorType.MULTIPLY, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));
    private static final ResolvedFunction MODULUS_BIGINT = FUNCTIONS.resolveOperator(OperatorType.MODULUS, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
    private static final ResolvedFunction NEGATION_BIGINT = FUNCTIONS.resolveOperator(OperatorType.NEGATION, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT));

    @Test
    public void testEagerLoading() {
        RowExpressionBuilder builder = RowExpressionBuilder.create().addSymbol("bigint0", (Type)BigintType.BIGINT).addSymbol("bigint1", (Type)BigintType.BIGINT);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression((Expression)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "bigint0"), (Object)new Constant((Type)BigintType.BIGINT, (Object)5L)))), 1);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression((Expression)new Cast((Expression)new Call(MULTIPLY_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "bigint0"), (Object)new Constant((Type)BigintType.BIGINT, (Object)10L))), (Type)IntegerType.INTEGER)), 1);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression((Expression)new Coalesce((Expression)new Call(MODULUS_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "bigint0"), (Object)new Constant((Type)BigintType.BIGINT, (Object)2L))), (Expression)new Reference((Type)BigintType.BIGINT, "bigint0"), new Expression[0])), 1);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression((Expression)new In((Expression)new Reference((Type)BigintType.BIGINT, "bigint0"), (List)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)1L), (Object)new Constant((Type)BigintType.BIGINT, (Object)2L), (Object)new Constant((Type)BigintType.BIGINT, (Object)3L)))), 1);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "bigint0"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L))), 1);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "bigint0"), (Object)new Constant((Type)BigintType.BIGINT, (Object)1L))), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L))), 1);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression((Expression)new Between((Expression)new Reference((Type)BigintType.BIGINT, "bigint0"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)10L))), 1);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "bigint0"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L)), (Expression)new Reference((Type)BigintType.BIGINT, "bigint0"))), (Expression)new Constant((Type)BigintType.BIGINT, null))), 1);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression((Expression)new Switch((Expression)new Reference((Type)BigintType.BIGINT, "bigint0"), (List)ImmutableList.of((Object)new WhenClause((Expression)new Constant((Type)BigintType.BIGINT, (Object)1L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L))), (Expression)new Call(NEGATION_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "bigint0"))))), 1);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression((Expression)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Coalesce((Expression)new Constant((Type)BigintType.BIGINT, (Object)0L), (Expression)new Reference((Type)BigintType.BIGINT, "bigint0"), new Expression[0]), (Object)new Reference((Type)BigintType.BIGINT, "bigint0")))), 1);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression((Expression)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "bigint0"), (Object)new Call(MULTIPLY_BIGINT, (List)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)2L), (Object)new Reference((Type)BigintType.BIGINT, "bigint1")))))), 2);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression((Expression)new NullIf((Expression)new Reference((Type)BigintType.BIGINT, "bigint0"), (Expression)new Reference((Type)BigintType.BIGINT, "bigint1"))), 2);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression((Expression)new Coalesce((Expression)new Call(CEIL, (List)ImmutableList.of((Object)new Call(DIVIDE_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "bigint0"), (Object)new Reference((Type)BigintType.BIGINT, "bigint1"))))), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L), new Expression[0])), 2);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "bigint0"), (Expression)new Reference((Type)BigintType.BIGINT, "bigint1")), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L))), 2);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "bigint0"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L)), (Expression)new Reference((Type)BigintType.BIGINT, "bigint1"))), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L))), 2, (Set<Integer>)ImmutableSet.of((Object)0));
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression((Expression)new Coalesce((Expression)new Call(ROUND, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "bigint0"))), (Expression)new Reference((Type)BigintType.BIGINT, "bigint1"), new Expression[0])), 2, (Set<Integer>)ImmutableSet.of((Object)0));
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "bigint0"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L)), (Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "bigint1"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L))))), 2, (Set<Integer>)ImmutableSet.of((Object)0));
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "bigint0"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L)), (Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "bigint1"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L))))), 2, (Set<Integer>)ImmutableSet.of((Object)0));
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression((Expression)new Between((Expression)new Reference((Type)BigintType.BIGINT, "bigint0"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L), (Expression)new Reference((Type)BigintType.BIGINT, "bigint1"))), 2, (Set<Integer>)ImmutableSet.of((Object)0));
        builder = RowExpressionBuilder.create().addSymbol("array_bigint0", (Type)new ArrayType((Type)BigintType.BIGINT)).addSymbol("array_bigint1", (Type)new ArrayType((Type)BigintType.BIGINT));
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression((Expression)new Call(TRANSFORM, (List)ImmutableList.of((Object)new Reference((Type)new ArrayType((Type)BigintType.BIGINT), "array_bigint0"), (Object)new Lambda((List)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "x")), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))))), 1, (Set<Integer>)ImmutableSet.of());
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression((Expression)new Call(TRANSFORM, (List)ImmutableList.of((Object)new Reference((Type)new ArrayType((Type)BigintType.BIGINT), "array_bigint0"), (Object)new Lambda((List)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "x")), (Expression)new Call(MULTIPLY_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Reference((Type)IntegerType.INTEGER, "x"))))))), 1, (Set<Integer>)ImmutableSet.of());
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression((Expression)new Call(ZIP_WITH, (List)ImmutableList.of((Object)new Reference((Type)new ArrayType((Type)BigintType.BIGINT), "array_bigint0"), (Object)new Reference((Type)new ArrayType((Type)BigintType.BIGINT), "array_bigint1"), (Object)new Lambda((List)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "x"), (Object)new Symbol((Type)BigintType.BIGINT, "y")), (Expression)new Call(MULTIPLY_BIGINT, (List)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)2L), (Object)new Reference((Type)BigintType.BIGINT, "x"))))))), 2, (Set<Integer>)ImmutableSet.of());
    }

    private static void verifyEagerlyLoadedColumns(RowExpression rowExpression, int columnCount) {
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(rowExpression, columnCount, (Set)IntStream.range(0, columnCount).boxed().collect(ImmutableSet.toImmutableSet()));
    }

    private static void verifyEagerlyLoadedColumns(RowExpression rowExpression, int columnCount, Set<Integer> eagerlyLoadedChannels) {
        PageFieldsToInputParametersRewriter.Result result = PageFieldsToInputParametersRewriter.rewritePageFieldsToInputParameters((RowExpression)rowExpression);
        Block[] blocks = new Block[columnCount];
        for (int channel = 0; channel < columnCount; ++channel) {
            blocks[channel] = BlockAssertions.createLongSequenceBlock(0, 100);
        }
        TestingSourcePage inputPage = new TestingSourcePage(100, blocks);
        result.getInputChannels().getInputChannels((SourcePage)inputPage);
        for (int channel = 0; channel < columnCount; ++channel) {
            Assertions.assertThat((boolean)inputPage.wasLoaded(channel)).isEqualTo(eagerlyLoadedChannels.contains(channel));
        }
    }

    private static class RowExpressionBuilder {
        private final Map<Symbol, Integer> sourceLayout = new HashMap<Symbol, Integer>();
        private final List<Type> types = new LinkedList<Type>();

        private RowExpressionBuilder() {
        }

        private static RowExpressionBuilder create() {
            return new RowExpressionBuilder();
        }

        private RowExpressionBuilder addSymbol(String name, Type type) {
            Symbol symbol = new Symbol(type, name);
            this.sourceLayout.put(symbol, this.types.size());
            this.types.add(type);
            return this;
        }

        private RowExpression buildExpression(Expression expression) {
            return SqlToRowExpressionTranslator.translate((Expression)expression, this.sourceLayout, (Metadata)PLANNER_CONTEXT.getMetadata(), (TypeManager)PLANNER_CONTEXT.getTypeManager());
        }
    }
}

