/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.jmh.Benchmarks;
import io.trino.operator.scalar.DateTimeFunctions;
import io.trino.operator.scalar.QuarterOfYearDateTimeField;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.chrono.ISOChronology;
import org.junit.jupiter.api.Test;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.RunnerException;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=2)
@Warmup(iterations=10, time=1000, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=1000, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkDateTimeFunctions {
    private static final ISOChronology ISO_CHRONOLOGY = ISOChronology.getInstanceUTC();

    public static DateTimeField getTimestampFieldOld(ISOChronology chronology, Slice unit) {
        String unitString;
        return switch (unitString = unit.toStringUtf8().toLowerCase(Locale.ENGLISH)) {
            case "millisecond" -> chronology.millisOfSecond();
            case "second" -> chronology.secondOfMinute();
            case "minute" -> chronology.minuteOfHour();
            case "hour" -> chronology.hourOfDay();
            case "day" -> chronology.dayOfMonth();
            case "week" -> chronology.weekOfWeekyear();
            case "month" -> chronology.monthOfYear();
            case "quarter" -> QuarterOfYearDateTimeField.QUARTER_OF_YEAR.getField((Chronology)chronology);
            case "year" -> chronology.year();
            default -> throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "'" + unitString + "' is not a valid TIMESTAMP field");
        };
    }

    @Benchmark
    public DateTimeField getTimestampFieldOld(BenchmarkData data) {
        return BenchmarkDateTimeFunctions.getTimestampFieldOld(ISO_CHRONOLOGY, data.getUnit());
    }

    @Benchmark
    public DateTimeField getTimestampFieldNew(BenchmarkData data) {
        return DateTimeFunctions.getTimestampField((ISOChronology)ISO_CHRONOLOGY, (Slice)data.getUnit());
    }

    @Test
    public void test() {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        this.getTimestampFieldOld(data);
        this.getTimestampFieldNew(data);
    }

    public static void main(String[] args) throws RunnerException {
        Benchmarks.benchmark(BenchmarkDateTimeFunctions.class).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        @Param(value={"millisecond", "second", "minute", "hour", "day", "week", "month", "quarter", "year", "MILLISECOND", "SECOND", "MINUTE", "HOUR", "DAY", "WEEK", "MONTH", "QUARTER", "YEAR"})
        private String unitString = "year";
        private Slice unit;

        @Setup
        public void setup() {
            this.unit = Slices.utf8Slice((String)this.unitString);
        }

        public Slice getUnit() {
            return this.unit;
        }
    }
}

