/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.block.Block;
import io.trino.spi.block.SqlRow;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeUtils;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.Row;
import io.trino.sql.ir.optimizer.rule.EvaluateRow;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;

public class TestEvaluateRow {
    @Test
    void test() {
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Row((List)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)1L), (Object)new Constant((Type)BigintType.BIGINT, (Object)2L))))).isPresent()).get().satisfies(new ThrowingConsumer[]{row -> {
            Object patt2$temp;
            block6: {
                block5: {
                    Type patt1$temp;
                    if (!(row instanceof Constant)) break block5;
                    Constant $b$0 = (Constant)row;
                    try {
                        patt1$temp = $b$0.type();
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    if (!(patt1$temp instanceof RowType)) break block5;
                    RowType type = (RowType)patt1$temp;
                    patt2$temp = $b$0.value();
                    if (patt2$temp instanceof SqlRow) break block6;
                }
                throw new AssertionError((Object)"Expected SqlRow");
            }
            SqlRow value = (SqlRow)patt2$temp;
            Assertions.assertThat((Object)TypeUtils.readNativeValue((Type)BigintType.BIGINT, (Block)value.getRawFieldBlock(0), (int)value.getRawIndex())).isEqualTo((Object)1L);
            Assertions.assertThat((Object)TypeUtils.readNativeValue((Type)BigintType.BIGINT, (Block)value.getRawFieldBlock(1), (int)value.getRawIndex())).isEqualTo((Object)2L);
        }});
        Assertions.assertThat(this.optimize((Expression)new Row((List)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)1L), (Object)new Reference((Type)BigintType.BIGINT, "x"))))).isEmpty();
    }

    private Optional<Expression> optimize(Expression expression) {
        return new EvaluateRow().apply(expression, TestingSession.testSession(), (Map)ImmutableMap.of());
    }
}

