/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import io.trino.Session;
import io.trino.cost.CachingStatsProvider;
import io.trino.cost.CachingTableStatsProvider;
import io.trino.cost.StatsCalculator;
import io.trino.cost.StatsProvider;
import io.trino.cost.TableStatsProvider;
import io.trino.metadata.Metadata;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.assertions.MatchResult;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.PlanMatchingVisitor;
import io.trino.sql.planner.iterative.Lookup;
import io.trino.sql.planner.plan.PlanFragmentId;
import io.trino.sql.planner.plan.PlanVisitor;
import java.util.Objects;
import java.util.Optional;

public class PlanFragmentMatcher {
    private final PlanFragmentId fragmentId;
    private final Optional<PlanMatchPattern> planPattern;
    private final Optional<PartitioningHandle> partitioning;
    private final Optional<Integer> inputPartitionCount;
    private final Optional<Integer> outputPartitionCount;

    public static Builder builder() {
        return new Builder();
    }

    public PlanFragmentMatcher(PlanFragmentId fragmentId, Optional<PlanMatchPattern> planPattern, Optional<PartitioningHandle> partitioning, Optional<Integer> inputPartitionCount, Optional<Integer> outputPartitionCount) {
        this.fragmentId = Objects.requireNonNull(fragmentId, "fragmentId is null");
        this.planPattern = Objects.requireNonNull(planPattern, "planPattern is null");
        this.partitioning = Objects.requireNonNull(partitioning, "partitioning is null");
        this.inputPartitionCount = Objects.requireNonNull(inputPartitionCount, "inputPartitionCount is null");
        this.outputPartitionCount = Objects.requireNonNull(outputPartitionCount, "outputPartitionCount is null");
    }

    public boolean matches(PlanFragment fragment, StatsCalculator statsCalculator, Session session, Metadata metadata) {
        if (!this.fragmentId.equals((Object)fragment.getId())) {
            return false;
        }
        if (this.planPattern.isPresent()) {
            CachingStatsProvider statsProvider = new CachingStatsProvider(statsCalculator, session, (TableStatsProvider)new CachingTableStatsProvider(metadata, session));
            MatchResult matches = (MatchResult)fragment.getRoot().accept((PlanVisitor)new PlanMatchingVisitor(session, metadata, (StatsProvider)statsProvider, Lookup.noLookup()), (Object)this.planPattern.get());
            if (!matches.isMatch()) {
                return false;
            }
        }
        if (this.partitioning.isPresent() && !this.partitioning.get().equals((Object)fragment.getPartitioning())) {
            return false;
        }
        if (this.inputPartitionCount.isPresent() && !this.inputPartitionCount.equals(fragment.getPartitionCount())) {
            return false;
        }
        return this.outputPartitionCount.isEmpty() || this.outputPartitionCount.equals(fragment.getOutputPartitioningScheme().getPartitionCount());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Fragment ").append(this.fragmentId).append("\n");
        this.planPattern.ifPresent(planPattern -> builder.append("PlanPattern: \n").append(planPattern).append("\n"));
        this.partitioning.ifPresent(partitioning -> builder.append("Partitioning: ").append(partitioning).append("\n"));
        this.inputPartitionCount.ifPresent(partitionCount -> builder.append("InputPartitionCount: ").append(partitionCount).append("\n"));
        this.outputPartitionCount.ifPresent(partitionCount -> builder.append("OutputPartitionCount: ").append(partitionCount).append("\n"));
        return builder.toString();
    }

    public static class Builder {
        private PlanFragmentId fragmentId;
        private Optional<PlanMatchPattern> planPattern = Optional.empty();
        private Optional<PartitioningHandle> partitioning = Optional.empty();
        private Optional<Integer> inputPartitionCount = Optional.empty();
        private Optional<Integer> outputPartitionCount = Optional.empty();

        public Builder fragmentId(int fragmentId) {
            this.fragmentId = new PlanFragmentId(String.valueOf(fragmentId));
            return this;
        }

        public Builder planPattern(PlanMatchPattern planPattern) {
            this.planPattern = Optional.of(planPattern);
            return this;
        }

        public Builder partitioning(PartitioningHandle partitioning) {
            this.partitioning = Optional.of(partitioning);
            return this;
        }

        public Builder inputPartitionCount(int inputPartitionCount) {
            this.inputPartitionCount = Optional.of(inputPartitionCount);
            return this;
        }

        public Builder outputPartitionCount(int outputPartitionCount) {
            this.outputPartitionCount = Optional.of(outputPartitionCount);
            return this;
        }

        public PlanFragmentMatcher build() {
            return new PlanFragmentMatcher(this.fragmentId, this.planPattern, this.partitioning, this.inputPartitionCount, this.outputPartitionCount);
        }
    }
}

