/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.AddIntermediateAggregations;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import org.junit.jupiter.api.Test;

public class TestAddIntermediateAggregations
extends BaseRuleTest {
    public TestAddIntermediateAggregations() {
        super(new Plugin[0]);
    }

    @Test
    public void testSessionDisable() {
        this.tester().assertThat((Rule<?>)new AddIntermediateAggregations()).setSystemProperty("enable_intermediate_aggregations", "false").setSystemProperty("task_concurrency", "4").on(p -> p.aggregation(af -> af.globalGrouping().step(AggregationNode.Step.FINAL).addAggregation(p.symbol("c"), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "b"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.gatheringExchange(ExchangeNode.Scope.REMOTE, (PlanNode)p.aggregation(ap -> ap.globalGrouping().step(AggregationNode.Step.PARTIAL).addAggregation(p.symbol("b"), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("a")))))))).doesNotFire();
    }

    @Test
    public void testWithGroups() {
        this.tester().assertThat((Rule<?>)new AddIntermediateAggregations()).setSystemProperty("enable_intermediate_aggregations", "true").setSystemProperty("task_concurrency", "4").on(p -> p.aggregation(af -> af.singleGroupingSet(p.symbol("c")).step(AggregationNode.Step.FINAL).addAggregation(p.symbol("c"), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "b"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.gatheringExchange(ExchangeNode.Scope.REMOTE, (PlanNode)p.aggregation(ap -> ap.singleGroupingSet(p.symbol("b")).step(AggregationNode.Step.PARTIAL).addAggregation(p.symbol("b"), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("a")))))))).doesNotFire();
    }
}

