/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.Plugin;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.AggregationFunction;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.RemoveRedundantDistinctAggregation;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestRemoveRedundantDistinctAggregation
extends BaseRuleTest {
    private static final ResolvedFunction ADD_INTEGER = new TestingFunctionResolution().resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));

    public TestRemoveRedundantDistinctAggregation() {
        super(new Plugin[0]);
    }

    @Test
    public void testRemoveDistinctAggregationForGroupedAggregation() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantDistinctAggregation()).on(TestRemoveRedundantDistinctAggregation::distinctWithGroupBy).matches(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("value"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.values("value")));
    }

    @Test
    public void testRemoveDistinctAggregationForGroupedAggregationDoesNotFireOnGroupingKeyNotPresentInDistinct() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantDistinctAggregation()).on(TestRemoveRedundantDistinctAggregation::distinctWithGroupByWithNonMatchingKeySubset).doesNotFire();
    }

    @Test
    public void testRemoveDistinctAggregationForGroupedAggregationWithProjectAndFilter() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantDistinctAggregation()).on(TestRemoveRedundantDistinctAggregation::distinctWithFilterWithProjectWithGroupBy).matches(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)6L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L)), PlanMatchPattern.project(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("value"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.values("value")))));
    }

    @Test
    public void testRemoveDistinctAggregationForGroupedAggregationDoesNotFireForNonIdentityProjectionsOnChildGroupingKeys() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantDistinctAggregation()).on(TestRemoveRedundantDistinctAggregation::distinctWithFilterWithNonIdentityProjectOnChildGroupingKeys).doesNotFire();
    }

    @Test
    public void testRemoveDistinctAggregationForGroupedAggregationWithSymbolReference() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantDistinctAggregation()).on(TestRemoveRedundantDistinctAggregation::distinctWithSymbolReferenceWithGroupBy).matches(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)6L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L)), PlanMatchPattern.project(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("value"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.values("value")))));
    }

    private static PlanNode distinctWithGroupBy(PlanBuilder p) {
        Symbol value = p.symbol("value", (Type)IntegerType.INTEGER);
        return p.aggregation(b -> b.singleGroupingSet(value).source((PlanNode)p.aggregation(builder -> builder.singleGroupingSet(value).source((PlanNode)p.values(value)))));
    }

    private static PlanNode distinctWithGroupByWithNonMatchingKeySubset(PlanBuilder p) {
        Symbol value = p.symbol("value", (Type)IntegerType.INTEGER);
        Symbol value2 = p.symbol("value2", (Type)IntegerType.INTEGER);
        return p.aggregation(b -> b.singleGroupingSet(value).source((PlanNode)p.aggregation(builder -> builder.singleGroupingSet(value, value2).source((PlanNode)p.values(value, value2)))));
    }

    private static PlanNode distinctWithFilterWithProjectWithGroupBy(PlanBuilder p) {
        Symbol value = p.symbol("value", (Type)IntegerType.INTEGER);
        return p.aggregation(b -> b.singleGroupingSet(value).source((PlanNode)p.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)6L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L)), (PlanNode)p.project(Assignments.builder().putIdentity(value).build(), (PlanNode)p.aggregation(builder -> builder.singleGroupingSet(value).source((PlanNode)p.values(value)))))));
    }

    private static PlanNode distinctWithFilterWithNonIdentityProjectOnChildGroupingKeys(PlanBuilder p) {
        Symbol value = p.symbol("value", (Type)IntegerType.INTEGER);
        return p.aggregation(b -> b.singleGroupingSet(value).source((PlanNode)p.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)6L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L)), (PlanNode)p.project(Assignments.builder().put(value, (Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "x"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L)))).build(), (PlanNode)p.aggregation(builder -> builder.singleGroupingSet(value).source((PlanNode)p.values(value)))))));
    }

    private static PlanNode distinctWithSymbolReferenceWithGroupBy(PlanBuilder p) {
        Symbol value = p.symbol("value", (Type)IntegerType.INTEGER);
        Symbol value2 = p.symbol("value2", (Type)IntegerType.INTEGER);
        return p.aggregation(b -> b.singleGroupingSet(value2).source((PlanNode)p.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)6L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L)), (PlanNode)p.project(Assignments.builder().put(value2, (Expression)value.toSymbolReference()).build(), (PlanNode)p.aggregation(builder -> builder.singleGroupingSet(value).source((PlanNode)p.values(value)))))));
    }
}

