/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.sanity;

import com.google.common.collect.ImmutableList;
import io.trino.execution.warnings.WarningCollector;
import io.trino.spi.type.Type;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.ExplainAnalyzeNode;
import io.trino.sql.planner.plan.OutputNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.planner.sanity.VerifyOnlyOneOutputNode;
import io.trino.type.UnknownType;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestVerifyOnlyOneOutputNode {
    private final PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();

    @Test
    public void testValidateSuccessful() {
        OutputNode root = new OutputNode(this.idAllocator.getNextId(), (PlanNode)new ProjectNode(this.idAllocator.getNextId(), (PlanNode)new ValuesNode(this.idAllocator.getNextId(), (List)ImmutableList.of()), Assignments.of()), (List)ImmutableList.of(), (List)ImmutableList.of());
        new VerifyOnlyOneOutputNode().validate((PlanNode)root, null, TestingPlannerContext.PLANNER_CONTEXT, WarningCollector.NOOP);
    }

    @Test
    public void testValidateFailed() {
        OutputNode root = new OutputNode(this.idAllocator.getNextId(), (PlanNode)new ExplainAnalyzeNode(this.idAllocator.getNextId(), (PlanNode)new OutputNode(this.idAllocator.getNextId(), (PlanNode)new ProjectNode(this.idAllocator.getNextId(), (PlanNode)new ValuesNode(this.idAllocator.getNextId(), (List)ImmutableList.of()), Assignments.of()), (List)ImmutableList.of(), (List)ImmutableList.of()), new Symbol((Type)UnknownType.UNKNOWN, "a"), (List)ImmutableList.of(), false), (List)ImmutableList.of(), (List)ImmutableList.of());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestVerifyOnlyOneOutputNode.lambda$testValidateFailed$0((PlanNode)root)).isInstanceOf(IllegalStateException.class)).hasMessage("Expected plan to have single instance of OutputNode");
    }

    private static /* synthetic */ void lambda$testValidateFailed$0(PlanNode root) throws Throwable {
        new VerifyOnlyOneOutputNode().validate(root, null, TestingPlannerContext.PLANNER_CONTEXT, WarningCollector.NOOP);
    }
}

