/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.annotation.UsedByGeneratedCode;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Plugin;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.LanguageFunctionEngine;
import io.trino.spi.function.ScalarFunctionAdapter;
import io.trino.spi.function.ScalarFunctionImplementation;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.StandaloneQueryRunner;
import io.trino.testing.TestingSession;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestInlineFunctions {
    private final QueryAssertions assertions;

    public TestInlineFunctions() {
        Session session = TestingSession.testSessionBuilder().setCatalog("test_catalog").setSchema("tiny").build();
        StandaloneQueryRunner runner = new StandaloneQueryRunner(session);
        runner.installPlugin((Plugin)new TpchPlugin());
        runner.createCatalog("test_catalog", "tpch", (Map)ImmutableMap.of((Object)"tpch.splits-per-node", (Object)"1"));
        runner.installPlugin((Plugin)new TestingLanguageEnginePlugin());
        this.assertions = new QueryAssertions((QueryRunner)runner);
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
    }

    @Test
    public void testSqlFunction() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH FUNCTION my_func(x bigint)\n    RETURNS bigint\n    RETURN x * 2\nSELECT my_func(nationkey)\nFROM nation\nWHERE nationkey = 1\n"))).matches("VALUES BIGINT '2'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH FUNCTION my_func(x bigint)\n    RETURNS bigint\n    RETURN x * 2\nSELECT my_func(nationkey)\nFROM nation\nWHERE nationkey >= 1\n"))).matches("SELECT nationkey * 2 FROM nation WHERE nationkey >= 1");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH FUNCTION my_func(x bigint)\n    RETURNS bigint\n    RETURN x * 2\nSELECT my_func(nationkey)\nFROM nation\n"))).matches("SELECT nationkey * 2 FROM nation");
    }

    @Test
    public void testLanguageEngineFunction() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH FUNCTION twice(x bigint)\nRETURNS bigint\nLANGUAGE TESTING\nWITH (handler = 'correct')\nAS $$\nmagic\n$$\nSELECT twice(nationkey)\nFROM nation\nWHERE nationkey = 1\n"))).matches("VALUES BIGINT '2'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH FUNCTION twice(x bigint)\nRETURNS bigint\nLANGUAGE TESTING\nWITH (handler = 'correct')\nAS $$\nmagic\n$$\nSELECT twice(nationkey)\nFROM nation\nWHERE nationkey >= 1\n"))).matches("SELECT nationkey * 2 FROM nation WHERE nationkey >= 1");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH FUNCTION twice(x bigint)\nRETURNS bigint\nLANGUAGE TESTING\nWITH (handler = 'correct')\nAS $$\nmagic\n$$\nSELECT twice(nationkey)\nFROM nation\n"))).matches("SELECT nationkey * 2 FROM nation");
    }

    @Test
    public void testLanguageEngineFunctionProperties() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH FUNCTION twice(x bigint)\nRETURNS varchar\nLANGUAGE TESTING\nWITH (handler = 'test', oops = 'abc')\nAS $$\nmagic\n$$\nVALUES 123\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_PROPERTY}).hasMessage("line 4:25: Function language TESTING property 'oops' does not exist");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH FUNCTION twice(x bigint)\nRETURNS varchar\nLANGUAGE TESTING\nWITH (handler = 888)\nAS $$\nmagic\n$$\nVALUES 123\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_PROPERTY}).hasMessage("line 4:7: Invalid value for function language TESTING property 'handler': Cannot convert [888] to varchar");
    }

    @Test
    public void testLanguageEngineFunctionValidation() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH FUNCTION twice(x bigint)\nRETURNS varchar\nLANGUAGE TESTING\nWITH (handler = 'correct')\nAS $$\nmagic\n$$\nVALUES 123\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:6: Invalid function 'twice': Invalid return type: varchar");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH FUNCTION twice(x varchar)\nRETURNS bigint\nLANGUAGE TESTING\nWITH (handler = 'correct')\nAS $$\nmagic\n$$\nVALUES 123\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:6: Invalid function 'twice': Invalid argument types: [varchar]");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH FUNCTION twice(x bigint)\nRETURNS bigint\nLANGUAGE TESTING\nAS $$\nmagic\n$$\nVALUES 123\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_PROPERTY}).hasMessage("line 1:6: Invalid function 'twice': Handler is required.");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH FUNCTION twice(x bigint)\nRETURNS bigint\nLANGUAGE TESTING\nWITH (handler = 'abc')\nAS $$\nmagic\n$$\nVALUES 123\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_PROPERTY}).hasMessage("line 1:6: Invalid function 'twice': Invalid handler value: abc");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH FUNCTION twice(x bigint)\nRETURNS bigint\nLANGUAGE TESTING\nWITH (handler = 'correct')\nAS $$\noops\n$$\nVALUES 123\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR}).hasMessage("line 1:6: Invalid function 'twice': Invalid definition: oops");
    }

    @Test
    public void testInlineSqlFunctions() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH FUNCTION abc(x integer) RETURNS integer RETURN x * 2\nSELECT abc(21)\n"))).matches("VALUES 42");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH FUNCTION abc(x integer) RETURNS integer RETURN abs(x)\nSELECT abc(-21)\n"))).matches("VALUES 21");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH\n  FUNCTION abc(x integer) RETURNS integer RETURN x * 2,\n  FUNCTION xyz(x integer) RETURNS integer RETURN abc(x) + 1\nSELECT xyz(21)\n"))).matches("VALUES 43");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH\n  FUNCTION my_pow(n int, p int)\n  RETURNS int\n  BEGIN\n    DECLARE r int DEFAULT n;\n    top: LOOP\n      IF p <= 1 THEN\n        LEAVE top;\n      END IF;\n      SET r = r * n;\n      SET p = p - 1;\n    END LOOP;\n    RETURN r;\n  END\nSELECT my_pow(2, 8)\n"))).matches("VALUES 256");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH\n  FUNCTION fun_with_uppercase_var()\n  RETURNS int\n  BEGIN\n    DECLARE R int DEFAULT 7;\n    RETURN R;\n  END\nSELECT fun_with_uppercase_var()\n"))).matches("VALUES 7");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH\n  FUNCTION my_pow(n int, p int)\n  RETURNS int\n  BEGIN\n    DECLARE r int DEFAULT n;\n    top: LOOP\n      IF p <= 1 THEN\n        LEAVE top;\n      END IF;\n      SET r = r * n;\n      SET p = p - 1;\n    END LOOP;\n    RETURN r;\n  END\nSELECT my_pow(CAST(nationkey AS integer), CAST(regionkey AS integer)) FROM nation WHERE nationkey IN (1,2,3,5,8)\n"))).matches("VALUES 1, 2, 3, 5, 64");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH FUNCTION get(input row(varchar))\n    RETURNS varchar\n    RETURN input[1]\nSELECT get(ROW('abc'))\n"))).matches("VALUES VARCHAR 'abc'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH FUNCTION a.b() RETURNS int RETURN 42 SELECT a.b()"))).failure().hasMessageContaining("line 1:6: Inline function names cannot be qualified: a.b");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH FUNCTION x() RETURNS int SECURITY INVOKER RETURN 42 SELECT x()"))).failure().hasMessageContaining("line 1:31: Security mode not supported for inline functions");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH FUNCTION x() RETURNS bigint SECURITY DEFINER RETURN 42 SELECT x()"))).failure().hasMessageContaining("line 1:34: Security mode not supported for inline functions");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH function x() RETURNS bigint DETERMINISTIC DETERMINISTIC RETURN 42 SELECT x()"))).failure().hasMessageContaining("line 1:48: Multiple deterministic clauses specified");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH FUNCTION abs(x integer) RETURNS integer RETURN x * 2\nSELECT abs(-10)\n"))).matches("VALUES -20");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH\n  FUNCTION abs(x integer) RETURNS integer RETURN x * 2,\n  FUNCTION wrap_abs(x integer) RETURNS integer RETURN abs(x)\nSELECT wrap_abs(-10)\n"))).matches("VALUES -20");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH FUNCTION abs(x varchar) RETURNS varchar RETURN reverse(x)\nSELECT abs('abc')\n"))).skippingTypesCheck().matches("VALUES 'cba'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH\n  FUNCTION a(x integer) RETURNS integer RETURN b(x),\n  FUNCTION b(x integer) RETURNS integer RETURN x * 2\nSELECT a(10)\n"))).failure().hasMessage("line 2:48: Function 'b' not registered");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH FUNCTION a(x integer) RETURNS integer RETURN a(x)\nSELECT a(10)\n"))).failure().hasMessage("line 1:6: Recursive language functions are not supported: a(integer):integer");
    }

    public static class TestingLanguageEnginePlugin
    implements Plugin {
        public Iterable<LanguageFunctionEngine> getLanguageFunctionEngines() {
            return List.of(new TestingLanguageFunctionEngine());
        }
    }

    public static class TestingLanguageFunctionEngine
    implements LanguageFunctionEngine {
        private static final MethodHandle HANDLE = Reflection.methodHandle(TestingLanguageFunctionEngine.class, (String)"twice", (Class[])new Class[]{Long.TYPE});

        public String getLanguage() {
            return "TESTING";
        }

        public List<PropertyMetadata<?>> getFunctionProperties() {
            return List.of(PropertyMetadata.stringProperty((String)"handler", (String)"handler", (String)"", (boolean)false));
        }

        public void validateScalarFunction(Type returnType, List<Type> argumentTypes, String definition, Map<String, Object> properties) {
            if (!returnType.equals((Object)BigintType.BIGINT)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Invalid return type: " + String.valueOf(returnType));
            }
            if (!argumentTypes.equals(List.of(BigintType.BIGINT))) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Invalid argument types: " + String.valueOf(argumentTypes));
            }
            String handler = (String)properties.get("handler");
            if (handler.isEmpty()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_PROPERTY, "Handler is required.");
            }
            if (!handler.equals("correct")) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_PROPERTY, "Invalid handler value: " + handler);
            }
            if (!definition.strip().equals("magic")) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "Invalid definition: " + definition.strip());
            }
        }

        public ScalarFunctionImplementation getScalarFunctionImplementation(Type returnType, List<Type> argumentTypes, String definition, Map<String, Object> properties, InvocationConvention invocationConvention) {
            Preconditions.checkState((boolean)returnType.equals((Object)BigintType.BIGINT));
            Preconditions.checkState((boolean)argumentTypes.equals(List.of(BigintType.BIGINT)));
            Preconditions.checkState((boolean)properties.equals(Map.of("handler", "correct")));
            Preconditions.checkState((boolean)definition.strip().equals("magic"));
            MethodHandle adapted = ScalarFunctionAdapter.adapt((MethodHandle)HANDLE, (Type)returnType, argumentTypes, (InvocationConvention)InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL}), (InvocationConvention)invocationConvention);
            return ScalarFunctionImplementation.builder().methodHandle(adapted).build();
        }

        @UsedByGeneratedCode
        public static long twice(long x) {
            return x * 2L;
        }
    }
}

