/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.spi.function.OperatorType;
import io.trino.sql.query.QueryAssertions;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestCharOperators {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testEqual() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "cast('foo' as char(3))", "cast('foo' as char(5))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "cast('foo' as char(3))", "cast('foo' as char(3))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "cast('foo' as char(3))", "cast('bar' as char(3))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "cast('bar' as char(3))", "cast('foo' as char(3))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "cast('bar' as char(5))", "'bar'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "cast('bar' as char(5))", "'bar   '")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "cast('a' as char(2))", "cast('a ' as char(2))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "cast('a ' as char(2))", "cast('a' as char(2))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "cast('a' as char(3))", "cast('a' as char(2))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "cast('' as char(3))", "cast('' as char(2))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "cast('' as char(2))", "cast('' as char(2))")))).isEqualTo(true);
    }

    @Test
    public void testNotEqual() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "cast('foo' as char(3))").binding("b", "cast('foo' as char(5))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "cast('foo' as char(3))").binding("b", "cast('foo' as char(3))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "cast('foo' as char(3))").binding("b", "cast('bar' as char(3))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "cast('bar' as char(3))").binding("b", "cast('foo' as char(3))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "cast('bar' as char(5))").binding("b", "'bar'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "cast('bar' as char(5))").binding("b", "'bar   '")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "cast('a' as char(2))").binding("b", "cast('a ' as char(2))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "cast('a ' as char(2))").binding("b", "cast('a' as char(2))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "cast('a' as char(3))").binding("b", "cast('a' as char(2))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "cast('' as char(3))").binding("b", "cast('' as char(2))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "cast('' as char(2))").binding("b", "cast('' as char(2))")))).isEqualTo(false);
    }

    @Test
    public void testLessThan() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "cast('\u0000' as char(1))", "cast(' ' as char(1))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "cast('bar' as char(5))", "cast('foo' as char(3))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "cast('foo' as char(5))", "cast('bar' as char(3))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "cast('bar' as char(3))", "cast('foo' as char(5))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "cast('foo' as char(3))", "cast('bar' as char(5))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "cast('foo' as char(3))", "cast('foo' as char(3))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "cast('foo' as char(3))", "cast('foo' as char(5))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "cast('foo' as char(5))", "cast('foo' as char(3))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "cast('foo' as char(3))", "cast('bar' as char(3))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "cast('bar' as char(3))", "cast('foo' as char(3))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "cast('foobar' as char(6))", "cast('foobaz' as char(6))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "cast('foob r' as char(6))", "cast('foobar' as char(6))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "cast('\u0000' as char(1))", "cast(' ' as char(1))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "cast('\u0000' as char(1))", "cast('' as char(0))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "cast('abc\u0000' as char(4))", "cast('abc' as char(4))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "cast('\u0000' as char(1))", "cast('\u0000 ' as char(2))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "cast('\u0000' as char(2))", "cast('\u0000 ' as char(2))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "cast('\u0000 a' as char(3))", "cast('\u0000' as char(3))")))).isEqualTo(false);
    }

    @Test
    public void testLessThanOrEqual() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "cast('bar' as char(5))", "cast('foo' as char(3))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "cast('foo' as char(5))", "cast('bar' as char(3))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "cast('bar' as char(3))", "cast('foo' as char(5))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "cast('foo' as char(3))", "cast('bar' as char(5))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "cast('foo' as char(3))", "cast('foo' as char(3))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "cast('foo' as char(3))", "cast('foo' as char(5))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "cast('foo' as char(5))", "cast('foo' as char(3))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "cast('foo' as char(3))", "cast('bar' as char(3))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "cast('bar' as char(3))", "cast('foo' as char(3))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "cast('foobar' as char(6))", "cast('foobaz' as char(6))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "cast('foob r' as char(6))", "cast('foobar' as char(6))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "cast('\u0000' as char(1))", "cast(' ' as char(1))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "cast('\u0000' as char(1))", "cast('' as char(0))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "cast('abc\u0000' as char(4))", "cast('abc' as char(4))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "cast('\u0000' as char(1))", "cast('\u0000 ' as char(2))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "cast('\u0000' as char(2))", "cast('\u0000 ' as char(2))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "cast('\u0000 a' as char(3))", "cast('\u0000' as char(3))")))).isEqualTo(false);
    }

    @Test
    public void testGreaterThan() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "cast('bar' as char(5))").binding("b", "cast('foo' as char(3))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "cast('foo' as char(5))").binding("b", "cast('bar' as char(3))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "cast('bar' as char(3))").binding("b", "cast('foo' as char(5))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "cast('foo' as char(3))").binding("b", "cast('bar' as char(5))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "cast('foo' as char(3))").binding("b", "cast('foo' as char(3))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "cast('foo' as char(3))").binding("b", "cast('foo' as char(5))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "cast('foo' as char(5))").binding("b", "cast('foo' as char(3))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "cast('foo' as char(3))").binding("b", "cast('bar' as char(3))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "cast('bar' as char(3))").binding("b", "cast('foo' as char(3))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "cast('foobar' as char(6))").binding("b", "cast('foobaz' as char(6))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "cast('foob r' as char(6))").binding("b", "cast('foobar' as char(6))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "cast(' ' as char(1))").binding("b", "cast('\u0000' as char(1))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "cast('' as char(0))").binding("b", "cast('\u0000' as char(1))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "cast('abc' as char(4))").binding("b", "cast('abc\u0000' as char(4))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "cast('\u0000 ' as char(2))").binding("b", "cast('\u0000' as char(1))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "cast('\u0000 ' as char(2))").binding("b", "cast('\u0000' as char(2))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "cast('\u0000 a' as char(3))").binding("b", "cast('\u0000' as char(3))")))).isEqualTo(true);
    }

    @Test
    public void testGreaterThanOrEqual() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "cast('bar' as char(5))").binding("b", "cast('foo' as char(3))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "cast('foo' as char(5))").binding("b", "cast('bar' as char(3))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "cast('bar' as char(3))").binding("b", "cast('foo' as char(5))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "cast('foo' as char(3))").binding("b", "cast('bar' as char(5))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "cast('foo' as char(3))").binding("b", "cast('foo' as char(3))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "cast('foo' as char(3))").binding("b", "cast('foo' as char(5))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "cast('foo' as char(5))").binding("b", "cast('foo' as char(3))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "cast('foo' as char(3))").binding("b", "cast('bar' as char(3))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "cast('bar' as char(3))").binding("b", "cast('foo' as char(3))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "cast('foobar' as char(6))").binding("b", "cast('foobaz' as char(6))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "cast('foob r' as char(6))").binding("b", "cast('foobar' as char(6))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "cast(' ' as char(1))").binding("b", "cast('\u0000' as char(1))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "cast('' as char(0))").binding("b", "cast('\u0000' as char(1))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "cast('abc' as char(4))").binding("b", "cast('abc\u0000' as char(4))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "cast('\u0000 ' as char(2))").binding("b", "cast('\u0000' as char(1))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "cast('\u0000 ' as char(2))").binding("b", "cast('\u0000' as char(2))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "cast('\u0000 a' as char(3))").binding("b", "cast('\u0000' as char(3))")))).isEqualTo(true);
    }

    @Test
    public void testBetween() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "cast('bbb' as char(3))").binding("low", "cast('aaa' as char(3))").binding("high", "cast('ccc' as char(3))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "cast('foo' as char(3))").binding("low", "cast('foo' as char(3))").binding("high", "cast('foo' as char(3))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "cast('foo' as char(3))").binding("low", "cast('foo' as char(3))").binding("high", "cast('bar' as char(3))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "cast('foo' as char(3))").binding("low", "cast('zzz' as char(3))").binding("high", "cast('foo' as char(3))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value NOT BETWEEN low AND high").binding("value", "cast('foo' as char(3))").binding("low", "cast('zzz' as char(3))").binding("high", "cast('foo' as char(3))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "cast('foo' as char(3))").binding("low", "cast('bar' as char(3))").binding("high", "cast('foo' as char(3))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "cast('foo' as char(3))").binding("low", "cast('bar' as char(3))").binding("high", "cast('bar' as char(3))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "cast('bar' as char(3))").binding("low", "cast('foo' as char(3))").binding("high", "cast('foo' as char(3))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "cast('bar' as char(3))").binding("low", "cast('foo' as char(3))").binding("high", "cast('bar' as char(3))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "cast('bar' as char(3))").binding("low", "cast('bar' as char(3))").binding("high", "cast('foo' as char(3))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "cast('bar' as char(3))").binding("low", "cast('bar' as char(3))").binding("high", "cast('bar' as char(3))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "cast('\u0000 a' as char(3))").binding("low", "cast('\u0000' as char(3))").binding("high", "cast('\u0000a' as char(3))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "cast('bar' as char(4))").binding("low", "cast('bar' as char(3))").binding("high", "cast('bar' as char(5))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "cast('bar' as char(4))").binding("low", "cast('bar' as char(5))").binding("high", "cast('bar' as char(7))")))).isEqualTo(true);
    }

    @Test
    public void testIdentical() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IDENTICAL, "cast(NULL as char(3))", "cast(NULL as char(3))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IDENTICAL, "cast(NULL as char(3))", "cast(NULL as char(5))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IDENTICAL, "cast('foo' as char(3))", "cast('foo' as char(5))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IDENTICAL, "cast('foo' as char(3))", "cast('foo' as char(3))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IDENTICAL, "cast('foo' as char(3))", "cast('bar' as char(3))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IDENTICAL, "cast('bar' as char(3))", "cast('foo' as char(3))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IDENTICAL, "cast('foo' as char(3))", "NULL")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IDENTICAL, "cast('bar' as char(5))", "'bar'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IDENTICAL, "cast('bar' as char(5))", "'bar   '")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IDENTICAL, "NULL", "cast('foo' as char(3))")))).isEqualTo(false);
    }

    @Test
    public void testIndeterminate() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "CAST(null AS CHAR(3))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "CHAR '123'")))).isEqualTo(false);
    }
}

