/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.PageBuilderStatus;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.type.LikePattern;
import io.trino.type.LikePatternType;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestLikePatternType {
    @Test
    public void testGetObject() {
        VariableWidthBlockBuilder blockBuilder = LikePatternType.LIKE_PATTERN.createBlockBuilder(new PageBuilderStatus().createBlockBuilderStatus(), 10);
        LikePatternType.LIKE_PATTERN.writeObject((BlockBuilder)blockBuilder, (Object)LikePattern.compile((String)"helloX_world", Optional.of(Character.valueOf('X'))));
        LikePatternType.LIKE_PATTERN.writeObject((BlockBuilder)blockBuilder, (Object)LikePattern.compile((String)"foo%_bar", Optional.empty()));
        Block block = blockBuilder.build();
        LikePattern pattern = (LikePattern)LikePatternType.LIKE_PATTERN.getObject(block, 0);
        Assertions.assertThat((String)pattern.getPattern()).isEqualTo("helloX_world");
        Assertions.assertThat((Optional)pattern.getEscape()).isEqualTo(Optional.of(Character.valueOf('X')));
        pattern = (LikePattern)LikePatternType.LIKE_PATTERN.getObject(block, 1);
        Assertions.assertThat((String)pattern.getPattern()).isEqualTo("foo%_bar");
        Assertions.assertThat((Optional)pattern.getEscape()).isEqualTo(Optional.empty());
    }
}

