/*
 * Decompiled with CFR 0.152.
 */
package io.trino.util;

import io.airlift.testing.ValidationAssertions;
import io.trino.util.PowerOfTwo;
import org.junit.jupiter.api.Test;

public class TestPowerOfTwoValidator {
    @Test
    public void testValidator() {
        TestPowerOfTwoValidator.assertValid(1);
        TestPowerOfTwoValidator.assertValid(2);
        TestPowerOfTwoValidator.assertValid(64);
        TestPowerOfTwoValidator.assertInvalid(0);
        TestPowerOfTwoValidator.assertInvalid(3);
        TestPowerOfTwoValidator.assertInvalid(99);
        TestPowerOfTwoValidator.assertInvalid(-1);
        TestPowerOfTwoValidator.assertInvalid(-2);
        TestPowerOfTwoValidator.assertInvalid(-4);
    }

    @Test
    public void testAllowsNullPowerOfTwoAnnotation() {
        ValidationAssertions.assertValidates((Object)new NullPowerOfTwoAnnotation());
    }

    private static void assertValid(int value) {
        ValidationAssertions.assertValidates((Object)new ConstrainedPowerOfTwo(value));
    }

    private static void assertInvalid(int value) {
        ConstrainedPowerOfTwo object = new ConstrainedPowerOfTwo(value);
        ValidationAssertions.assertFailsValidation((Object)object, (String)"unboxed", (String)"is not a power of two", PowerOfTwo.class);
        ValidationAssertions.assertFailsValidation((Object)object, (String)"boxed", (String)"is not a power of two", PowerOfTwo.class);
    }

    public static class NullPowerOfTwoAnnotation {
        @PowerOfTwo
        public Integer getNull() {
            return null;
        }
    }

    public static class ConstrainedPowerOfTwo {
        private final int value;

        public ConstrainedPowerOfTwo(int value) {
            this.value = value;
        }

        @PowerOfTwo
        public int getUnboxed() {
            return this.value;
        }

        @PowerOfTwo
        public Integer getBoxed() {
            return this.value;
        }
    }
}

