/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector.informationschema;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.SizeOf;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ConnectorSplit;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class InformationSchemaSplit
implements ConnectorSplit {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(InformationSchemaSplit.class);
    private final List<HostAddress> addresses;

    @JsonCreator
    public InformationSchemaSplit(@JsonProperty(value="addresses") List<HostAddress> addresses) {
        Objects.requireNonNull(addresses, "addresses is null");
        Preconditions.checkArgument((!addresses.isEmpty() ? 1 : 0) != 0, (Object)"addresses is empty");
        this.addresses = ImmutableList.copyOf(addresses);
    }

    public boolean isRemotelyAccessible() {
        return false;
    }

    @JsonProperty
    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    public Map<String, String> getSplitInfo() {
        return ImmutableMap.of((Object)"addresses", (Object)this.addresses.stream().map(HostAddress::toString).collect(Collectors.joining(",")));
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf(this.addresses, HostAddress::getRetainedSizeInBytes);
    }
}

