/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableSet;
import io.trino.metadata.Metadata;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.EntityPrivilege;
import io.trino.spi.security.Privilege;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.Node;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;

public final class PrivilegeUtilities {
    private PrivilegeUtilities() {
    }

    public static Set<Privilege> parseStatementPrivileges(Node statement, Optional<List<String>> optionalPrivileges) {
        Set<Object> privileges = optionalPrivileges.isPresent() ? (Set)optionalPrivileges.get().stream().map(privilege -> PrivilegeUtilities.parsePrivilege(statement, privilege)).collect(ImmutableSet.toImmutableSet()) : EnumSet.allOf(Privilege.class);
        return privileges;
    }

    public static Set<EntityPrivilege> fetchEntityKindPrivileges(String entityKind, Metadata metadata, Optional<List<String>> privileges) {
        Set<EntityPrivilege> allPrivileges = metadata.getAllEntityKindPrivileges(entityKind);
        if (privileges.isPresent()) {
            return (Set)privileges.get().stream().map(privilege -> {
                EntityPrivilege entityPrivilege = new EntityPrivilege(privilege.toUpperCase(Locale.ENGLISH));
                if (!allPrivileges.contains(entityPrivilege)) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PRIVILEGE, "Privilege %s is not supported for entity kind %s".formatted(privilege, entityKind));
                }
                return entityPrivilege;
            }).collect(ImmutableSet.toImmutableSet());
        }
        return allPrivileges;
    }

    private static Privilege parsePrivilege(Node statement, String privilegeString) {
        for (Privilege privilege : Privilege.values()) {
            if (!privilege.name().equalsIgnoreCase(privilegeString)) continue;
            return privilege;
        }
        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PRIVILEGE, statement, "Unknown privilege: '%s'", privilegeString);
    }
}

