/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.transaction.IsolationLevel;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Isolation;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.StartTransaction;
import io.trino.sql.tree.TransactionAccessMode;
import io.trino.transaction.TransactionId;
import io.trino.transaction.TransactionManager;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class StartTransactionTask
implements DataDefinitionTask<StartTransaction> {
    private final TransactionManager transactionManager;

    @Inject
    public StartTransactionTask(TransactionManager transactionManager) {
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
    }

    @Override
    public String getName() {
        return "START TRANSACTION";
    }

    @Override
    public ListenableFuture<Void> execute(StartTransaction statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        Session session = stateMachine.getSession();
        if (!session.isClientTransactionSupport()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INCOMPATIBLE_CLIENT, "Client does not support transactions");
        }
        if (session.getTransactionId().isPresent()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Nested transactions not supported");
        }
        Optional<IsolationLevel> isolationLevel = StartTransactionTask.extractIsolationLevel(statement);
        Optional<Boolean> readOnly = StartTransactionTask.extractReadOnly(statement);
        TransactionId transactionId = this.transactionManager.beginTransaction(isolationLevel.orElse(TransactionManager.DEFAULT_ISOLATION), readOnly.orElse(false), false);
        stateMachine.setStartedTransactionId(transactionId);
        this.transactionManager.trySetInactive(transactionId);
        return Futures.immediateVoidFuture();
    }

    private static Optional<IsolationLevel> extractIsolationLevel(StartTransaction startTransaction) {
        if (startTransaction.getTransactionModes().stream().filter(Isolation.class::isInstance).count() > 1L) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.SYNTAX_ERROR, (Node)startTransaction, "Multiple transaction isolation levels specified", new Object[0]);
        }
        return startTransaction.getTransactionModes().stream().filter(Isolation.class::isInstance).map(Isolation.class::cast).map(Isolation::getLevel).map(StartTransactionTask::convertLevel).findFirst();
    }

    private static Optional<Boolean> extractReadOnly(StartTransaction startTransaction) {
        if (startTransaction.getTransactionModes().stream().filter(TransactionAccessMode.class::isInstance).count() > 1L) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.SYNTAX_ERROR, (Node)startTransaction, "Multiple transaction read modes specified", new Object[0]);
        }
        return startTransaction.getTransactionModes().stream().filter(TransactionAccessMode.class::isInstance).map(TransactionAccessMode.class::cast).map(TransactionAccessMode::isReadOnly).findFirst();
    }

    private static IsolationLevel convertLevel(Isolation.Level level) {
        return switch (level) {
            default -> throw new MatchException(null, null);
            case Isolation.Level.SERIALIZABLE -> IsolationLevel.SERIALIZABLE;
            case Isolation.Level.REPEATABLE_READ -> IsolationLevel.REPEATABLE_READ;
            case Isolation.Level.READ_COMMITTED -> IsolationLevel.READ_COMMITTED;
            case Isolation.Level.READ_UNCOMMITTED -> IsolationLevel.READ_UNCOMMITTED;
        };
    }
}

