/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.executor;

import com.google.common.collect.ComparisonChain;
import io.trino.execution.TaskId;
import java.util.Objects;
import java.util.function.Supplier;

public class RunningSplitInfo
implements Comparable<RunningSplitInfo> {
    private final long startTime;
    private final String threadId;
    private final Thread thread;
    private boolean printed;
    private final TaskId taskId;
    private final Supplier<String> splitInfo;

    public RunningSplitInfo(long startTime, String threadId, Thread thread, TaskId taskId, Supplier<String> splitInfo) {
        this.startTime = startTime;
        this.threadId = Objects.requireNonNull(threadId, "threadId is null");
        this.thread = Objects.requireNonNull(thread, "thread is null");
        this.taskId = Objects.requireNonNull(taskId, "taskId is null");
        this.splitInfo = Objects.requireNonNull(splitInfo, "split is null");
        this.printed = false;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getThreadId() {
        return this.threadId;
    }

    public Thread getThread() {
        return this.thread;
    }

    public TaskId getTaskId() {
        return this.taskId;
    }

    public String getSplitInfo() {
        return this.splitInfo.get();
    }

    public boolean isPrinted() {
        return this.printed;
    }

    public void setPrinted() {
        this.printed = true;
    }

    @Override
    public int compareTo(RunningSplitInfo o) {
        return ComparisonChain.start().compare(this.startTime, o.getStartTime()).compare((Comparable)((Object)this.threadId), (Comparable)((Object)o.getThreadId())).result();
    }
}

