/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler.faulttolerant;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.CatalogHandle;
import java.util.Objects;
import java.util.Optional;

public class NodeRequirements {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(NodeRequirements.class);
    private final Optional<CatalogHandle> catalogHandle;
    private final Optional<HostAddress> address;
    private final boolean remotelyAccessible;

    @JsonCreator
    public NodeRequirements(@JsonProperty(value="catalogHandle") Optional<CatalogHandle> catalogHandle, @JsonProperty(value="address") Optional<HostAddress> address, @JsonProperty(value="remotelyAccessible") boolean remotelyAccessible) {
        Preconditions.checkArgument((remotelyAccessible || address.isPresent() ? 1 : 0) != 0, (Object)"addresses is empty and node is not remotely accessible");
        this.catalogHandle = Objects.requireNonNull(catalogHandle, "catalogHandle is null");
        this.address = address;
        this.remotelyAccessible = remotelyAccessible;
    }

    @JsonProperty
    public Optional<CatalogHandle> getCatalogHandle() {
        return this.catalogHandle;
    }

    @JsonProperty
    public Optional<HostAddress> getAddress() {
        return this.address;
    }

    @JsonProperty
    public boolean isRemotelyAccessible() {
        return this.remotelyAccessible;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeRequirements that = (NodeRequirements)o;
        return Objects.equals(this.catalogHandle, that.catalogHandle) && Objects.equals(this.address, that.address) && this.remotelyAccessible == that.remotelyAccessible;
    }

    public int hashCode() {
        return Objects.hash(this.catalogHandle, this.address, this.remotelyAccessible);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("catalogHandle", this.catalogHandle).add("addresses", this.address).add("remotelyAccessible", this.remotelyAccessible).toString();
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf(this.catalogHandle, CatalogHandle::getRetainedSizeInBytes) + SizeOf.sizeOf(this.address, HostAddress::getRetainedSizeInBytes);
    }
}

