/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.arrayagg;

import io.trino.operator.aggregation.arrayagg.ArrayAggregationState;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.BlockIndex;
import io.trino.spi.function.BlockPosition;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.Description;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlNullable;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.Type;

@AggregationFunction(value="array_agg", isOrderSensitive=true)
@Description(value="return an array of values")
public final class ArrayAggregationFunction {
    private ArrayAggregationFunction() {
    }

    @InputFunction
    @TypeParameter(value="T")
    public static void input(@AggregationState(value={"T"}) ArrayAggregationState state, @SqlNullable @BlockPosition @SqlType(value="T") ValueBlock value, @BlockIndex int position) {
        state.add(value, position);
    }

    @CombineFunction
    public static void combine(@AggregationState(value={"T"}) ArrayAggregationState state, @AggregationState(value={"T"}) ArrayAggregationState otherState) {
        state.merge(otherState);
    }

    @OutputFunction(value="array(T)")
    public static void output(@TypeParameter(value="T") Type elementType, @AggregationState(value={"T"}) ArrayAggregationState state, BlockBuilder out) {
        if (state.isEmpty()) {
            out.appendNull();
        } else {
            ((ArrayBlockBuilder)out).buildEntry(state::writeAll);
        }
    }
}

