/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.output;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import io.trino.execution.buffer.OutputBuffer;
import io.trino.execution.buffer.PageSerializer;
import io.trino.execution.buffer.PageSplitterUtil;
import io.trino.execution.buffer.PagesSerdeFactory;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.operator.OperatorContext;
import io.trino.operator.PartitionFunction;
import io.trino.operator.output.PositionsAppenderFactory;
import io.trino.operator.output.PositionsAppenderPageBuilder;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.type.Type;
import io.trino.util.Ciphers;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import jakarta.annotation.Nullable;
import java.io.Closeable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.IntUnaryOperator;

public class PagePartitioner
implements Closeable {
    private static final int COLUMNAR_STRATEGY_COEFFICIENT = 2;
    private final OutputBuffer outputBuffer;
    private final PartitionFunction partitionFunction;
    private final int[] partitionChannels;
    private final LocalMemoryContext memoryContext;
    @Nullable
    private final Block[] partitionConstantBlocks;
    private final PageSerializer serializer;
    private final PositionsAppenderPageBuilder[] positionsAppenders;
    private final boolean replicatesAnyRow;
    private final boolean partitionProcessRleAndDictionaryBlocks;
    private final int nullChannel;
    private boolean hasAnyRowBeenReplicated;
    private long outputSizeReportedBeforeRelease;

    public PagePartitioner(PartitionFunction partitionFunction, List<Integer> partitionChannels, List<Optional<NullableValue>> partitionConstants, boolean replicatesAnyRow, OptionalInt nullChannel, OutputBuffer outputBuffer, PagesSerdeFactory serdeFactory, List<Type> sourceTypes, DataSize maxMemory, PositionsAppenderFactory positionsAppenderFactory, Optional<Slice> exchangeEncryptionKey, AggregatedMemoryContext aggregatedMemoryContext, boolean partitionProcessRleAndDictionaryBlocks) {
        this.partitionFunction = Objects.requireNonNull(partitionFunction, "partitionFunction is null");
        this.partitionChannels = Ints.toArray((Collection)Objects.requireNonNull(partitionChannels, "partitionChannels is null"));
        Objects.requireNonNull(positionsAppenderFactory, "positionsAppenderFactory is null");
        Block[] partitionConstantBlocks = (Block[])partitionConstants.stream().map(constant -> constant.map(NullableValue::asBlock).orElse(null)).toArray(Block[]::new);
        this.partitionConstantBlocks = Arrays.stream(partitionConstantBlocks).anyMatch(Objects::nonNull) ? partitionConstantBlocks : null;
        this.replicatesAnyRow = replicatesAnyRow;
        this.nullChannel = nullChannel.orElse(-1);
        this.outputBuffer = Objects.requireNonNull(outputBuffer, "outputBuffer is null");
        this.serializer = serdeFactory.createSerializer(exchangeEncryptionKey.map(Ciphers::deserializeAesEncryptionKey));
        this.partitionProcessRleAndDictionaryBlocks = partitionProcessRleAndDictionaryBlocks;
        for (int i = 0; i < this.partitionChannels.length; ++i) {
            if (this.partitionChannels[i] >= 0) continue;
            Preconditions.checkArgument((this.partitionConstantBlocks != null && this.partitionConstantBlocks[i] != null ? 1 : 0) != 0, (String)"Expected constant for partitioning channel %s, but none was found", (int)i);
        }
        int partitionCount = partitionFunction.partitionCount();
        int pageSize = Math.toIntExact(Math.min(0x100000L, maxMemory.toBytes() / (long)partitionCount));
        pageSize = Math.max(1, pageSize);
        this.positionsAppenders = new PositionsAppenderPageBuilder[partitionCount];
        for (int i = 0; i < partitionCount; ++i) {
            this.positionsAppenders[i] = PositionsAppenderPageBuilder.withMaxPageSize(pageSize, Objects.requireNonNull(sourceTypes, "sourceTypes is null"), positionsAppenderFactory);
        }
        this.memoryContext = aggregatedMemoryContext.newLocalMemoryContext(PagePartitioner.class.getSimpleName());
        this.updateMemoryUsage();
    }

    public PartitionFunction getPartitionFunction() {
        return this.partitionFunction;
    }

    public void partitionPage(Page page, OperatorContext operatorContext) {
        int outputPositionCount;
        if (page.getPositionCount() == 0) {
            return;
        }
        int n = outputPositionCount = this.replicatesAnyRow && !this.hasAnyRowBeenReplicated ? page.getPositionCount() + this.positionsAppenders.length - 1 : page.getPositionCount();
        if (page.getPositionCount() < this.partitionFunction.partitionCount() * 2) {
            this.partitionPageByRow(page);
        } else {
            this.partitionPageByColumn(page);
        }
        long outputSizeInBytes = this.flushPositionsAppenders(false);
        this.updateMemoryUsage();
        operatorContext.recordOutput(outputSizeInBytes, outputPositionCount);
    }

    private long adjustFlushedOutputSizeWithEagerlyReportedBytes(long flushedOutputSize) {
        if (this.outputSizeReportedBeforeRelease > 0L) {
            long adjustmentAmount = Math.min(flushedOutputSize, this.outputSizeReportedBeforeRelease);
            this.outputSizeReportedBeforeRelease -= adjustmentAmount;
            flushedOutputSize -= adjustmentAmount;
        }
        return flushedOutputSize;
    }

    private long adjustEagerlyReportedBytesWithBufferedBytesOnRelease(long bufferedBytesOnRelease) {
        if (bufferedBytesOnRelease > this.outputSizeReportedBeforeRelease) {
            long additionalBufferedBytes = bufferedBytesOnRelease - this.outputSizeReportedBeforeRelease;
            this.outputSizeReportedBeforeRelease = bufferedBytesOnRelease;
            return additionalBufferedBytes;
        }
        return 0L;
    }

    public void prepareForRelease(OperatorContext operatorContext) {
        long bufferedSizeInBytes = 0L;
        long outputSizeInBytes = 0L;
        for (int partition = 0; partition < this.positionsAppenders.length; ++partition) {
            PositionsAppenderPageBuilder positionsAppender = this.positionsAppenders[partition];
            Optional<Page> flushedPage = positionsAppender.flushOrFlattenBeforeRelease();
            if (flushedPage.isPresent()) {
                Page page = flushedPage.get();
                outputSizeInBytes += page.getSizeInBytes();
                this.enqueuePage(page, partition);
                continue;
            }
            bufferedSizeInBytes += positionsAppender.getSizeInBytes();
        }
        this.updateMemoryUsage();
        outputSizeInBytes = this.adjustFlushedOutputSizeWithEagerlyReportedBytes(outputSizeInBytes);
        bufferedSizeInBytes = this.adjustEagerlyReportedBytesWithBufferedBytesOnRelease(bufferedSizeInBytes);
        operatorContext.recordOutput(outputSizeInBytes + bufferedSizeInBytes, 0L);
    }

    public void partitionPageByRow(Page page) {
        int position;
        Objects.requireNonNull(page, "page is null");
        if (page.getPositionCount() == 0) {
            return;
        }
        if (this.replicatesAnyRow && !this.hasAnyRowBeenReplicated) {
            for (PositionsAppenderPageBuilder pageBuilder : this.positionsAppenders) {
                pageBuilder.appendToOutputPartition(page, 0);
            }
            this.hasAnyRowBeenReplicated = true;
            position = 1;
        } else {
            position = 0;
        }
        Page partitionFunctionArgs = this.getPartitionFunctionArguments(page);
        if (this.nullChannel >= 0 && page.getBlock(this.nullChannel).mayHaveNull()) {
            Block nullsBlock = page.getBlock(this.nullChannel);
            while (position < page.getPositionCount()) {
                if (nullsBlock.isNull(position)) {
                    for (PositionsAppenderPageBuilder pageBuilder : this.positionsAppenders) {
                        pageBuilder.appendToOutputPartition(page, position);
                    }
                } else {
                    int partition = this.partitionFunction.getPartition(partitionFunctionArgs, position);
                    this.positionsAppenders[partition].appendToOutputPartition(page, position);
                }
                ++position;
            }
        } else {
            while (position < page.getPositionCount()) {
                int partition = this.partitionFunction.getPartition(partitionFunctionArgs, position);
                this.positionsAppenders[partition].appendToOutputPartition(page, position);
                ++position;
            }
        }
    }

    public void partitionPageByColumn(Page page) {
        IntArrayList[] partitionedPositions = this.partitionPositions(page);
        for (int i = 0; i < this.partitionFunction.partitionCount(); ++i) {
            IntArrayList partitionPositions = partitionedPositions[i];
            if (partitionPositions.isEmpty()) continue;
            this.positionsAppenders[i].appendToOutputPartition(page, partitionPositions);
            partitionPositions.clear();
        }
    }

    private IntArrayList[] partitionPositions(Page page) {
        int position;
        Verify.verify((page.getPositionCount() > 0 ? 1 : 0) != 0, (String)"position count is 0", (Object[])new Object[0]);
        IntArrayList[] partitionPositions = this.initPositions(page);
        if (this.replicatesAnyRow && !this.hasAnyRowBeenReplicated) {
            for (IntArrayList partitionPosition : partitionPositions) {
                partitionPosition.add(0);
            }
            this.hasAnyRowBeenReplicated = true;
            position = 1;
        } else {
            position = 0;
        }
        Page partitionFunctionArgs = this.getPartitionFunctionArguments(page);
        if (this.partitionProcessRleAndDictionaryBlocks && partitionFunctionArgs.getChannelCount() > 0 && PagePartitioner.onlyRleBlocks(partitionFunctionArgs)) {
            this.partitionBySingleRleValue(page, position, partitionFunctionArgs, partitionPositions);
        } else if (this.partitionProcessRleAndDictionaryBlocks && partitionFunctionArgs.getChannelCount() == 1 && PagePartitioner.isDictionaryProcessingFaster(partitionFunctionArgs.getBlock(0))) {
            this.partitionBySingleDictionary(page, position, partitionFunctionArgs, partitionPositions);
        } else {
            this.partitionGeneric(page, position, aPosition -> this.partitionFunction.getPartition(partitionFunctionArgs, aPosition), partitionPositions);
        }
        return partitionPositions;
    }

    private IntArrayList[] initPositions(Page page) {
        IntArrayList[] partitionPositions = new IntArrayList[this.partitionFunction.partitionCount()];
        for (int i = 0; i < partitionPositions.length; ++i) {
            partitionPositions[i] = new IntArrayList(PagePartitioner.initialPartitionSize(page.getPositionCount() / this.partitionFunction.partitionCount()));
        }
        return partitionPositions;
    }

    private static int initialPartitionSize(int averagePositionsPerPartition) {
        return (int)((double)averagePositionsPerPartition * 1.1) + 32;
    }

    private static boolean onlyRleBlocks(Page page) {
        for (int i = 0; i < page.getChannelCount(); ++i) {
            if (page.getBlock(i) instanceof RunLengthEncodedBlock) continue;
            return false;
        }
        return true;
    }

    private void partitionBySingleRleValue(Page page, int position, Page partitionFunctionArgs, IntArrayList[] partitionPositions) {
        if (this.nullChannel != -1 && page.getBlock(this.nullChannel).isNull(0)) {
            Verify.verify((boolean)(page.getBlock(this.nullChannel) instanceof RunLengthEncodedBlock), (String)"null channel is not RunLengthEncodedBlock, found instead: %s", (Object)page.getBlock(this.nullChannel));
            int[] allPositions = PagePartitioner.integersInRange(position, page.getPositionCount());
            for (IntArrayList partitionPosition : partitionPositions) {
                partitionPosition.addElements(position, allPositions);
            }
        } else {
            Page rlePage = PagePartitioner.extractRlePage(partitionFunctionArgs);
            int partition = this.partitionFunction.getPartition(rlePage, 0);
            IntArrayList positions = partitionPositions[partition];
            for (int i = position; i < page.getPositionCount(); ++i) {
                positions.add(i);
            }
        }
    }

    private static Page extractRlePage(Page page) {
        Block[] valueBlocks = new Block[page.getChannelCount()];
        for (int channel = 0; channel < valueBlocks.length; ++channel) {
            valueBlocks[channel] = ((RunLengthEncodedBlock)page.getBlock(channel)).getValue();
        }
        return new Page(valueBlocks);
    }

    private static int[] integersInRange(int start, int endExclusive) {
        int[] array = new int[endExclusive - start];
        int current = start;
        for (int i = 0; i < array.length; ++i) {
            array[i] = current++;
        }
        return array;
    }

    private static boolean isDictionaryProcessingFaster(Block block) {
        if (!(block instanceof DictionaryBlock)) {
            return false;
        }
        DictionaryBlock dictionaryBlock = (DictionaryBlock)block;
        return dictionaryBlock.getPositionCount() > dictionaryBlock.getDictionary().getPositionCount();
    }

    private void partitionBySingleDictionary(Page page, int position, Page partitionFunctionArgs, IntArrayList[] partitionPositions) {
        DictionaryBlock dictionaryBlock = (DictionaryBlock)partitionFunctionArgs.getBlock(0);
        ValueBlock dictionary = dictionaryBlock.getDictionary();
        int[] dictionaryPartitions = new int[dictionary.getPositionCount()];
        Page dictionaryPage = new Page(new Block[]{dictionary});
        for (int i = 0; i < dictionary.getPositionCount(); ++i) {
            dictionaryPartitions[i] = this.partitionFunction.getPartition(dictionaryPage, i);
        }
        this.partitionGeneric(page, position, aPosition -> dictionaryPartitions[dictionaryBlock.getId(aPosition)], partitionPositions);
    }

    private void partitionGeneric(Page page, int position, IntUnaryOperator partitionFunction, IntArrayList[] partitionPositions) {
        if (this.nullChannel != -1 && page.getBlock(this.nullChannel).mayHaveNull()) {
            this.partitionNullablePositions(page, position, partitionPositions, partitionFunction);
        } else {
            PagePartitioner.partitionNotNullPositions(page, position, partitionPositions, partitionFunction);
        }
    }

    private void partitionNullablePositions(Page page, int position, IntArrayList[] partitionPositions, IntUnaryOperator partitionFunction) {
        Block nullsBlock = page.getBlock(this.nullChannel);
        int[] nullPositions = new int[page.getPositionCount()];
        int[] nonNullPositions = new int[page.getPositionCount()];
        int nullCount = 0;
        int nonNullCount = 0;
        for (int i = position; i < page.getPositionCount(); ++i) {
            nullPositions[nullCount] = i;
            nonNullPositions[nonNullCount] = i;
            int isNull = nullsBlock.isNull(i) ? 1 : 0;
            nullCount += isNull;
            nonNullCount += isNull ^ 1;
        }
        for (IntArrayList positions : partitionPositions) {
            positions.addElements(position, nullPositions, 0, nullCount);
        }
        for (int i = 0; i < nonNullCount; ++i) {
            int nonNullPosition = nonNullPositions[i];
            int partition = partitionFunction.applyAsInt(nonNullPosition);
            partitionPositions[partition].add(nonNullPosition);
        }
    }

    private static void partitionNotNullPositions(Page page, int startingPosition, IntArrayList[] partitionPositions, IntUnaryOperator partitionFunction) {
        int position;
        int positionCount = page.getPositionCount();
        int[] partitionPerPosition = new int[positionCount];
        for (position = startingPosition; position < positionCount; ++position) {
            int partition;
            partitionPerPosition[position] = partition = partitionFunction.applyAsInt(position);
        }
        for (position = startingPosition; position < positionCount; ++position) {
            partitionPositions[partitionPerPosition[position]].add(position);
        }
    }

    private Page getPartitionFunctionArguments(Page page) {
        if (this.partitionConstantBlocks == null) {
            return page.getColumns(this.partitionChannels);
        }
        Block[] blocks = new Block[this.partitionChannels.length];
        for (int i = 0; i < blocks.length; ++i) {
            int channel = this.partitionChannels[i];
            blocks[i] = channel < 0 ? RunLengthEncodedBlock.create((Block)this.partitionConstantBlocks[i], (int)page.getPositionCount()) : page.getBlock(channel);
        }
        return new Page(page.getPositionCount(), blocks);
    }

    @Override
    public void close() {
        try {
            this.flushPositionsAppenders(true);
            this.outputSizeReportedBeforeRelease = 0L;
        }
        finally {
            Arrays.fill(this.positionsAppenders, null);
            this.memoryContext.close();
        }
    }

    private long flushPositionsAppenders(boolean force) {
        long outputSizeInBytes = 0L;
        for (int partition = 0; partition < this.positionsAppenders.length; ++partition) {
            PositionsAppenderPageBuilder partitionPageBuilder = this.positionsAppenders[partition];
            if (partitionPageBuilder.isEmpty() || !force && !partitionPageBuilder.isFull()) continue;
            Page pagePartition = partitionPageBuilder.build();
            outputSizeInBytes += pagePartition.getSizeInBytes();
            this.enqueuePage(pagePartition, partition);
        }
        return this.adjustFlushedOutputSizeWithEagerlyReportedBytes(outputSizeInBytes);
    }

    private void enqueuePage(Page pagePartition, int partition) {
        this.outputBuffer.enqueue(partition, this.splitAndSerializePage(pagePartition));
    }

    private List<Slice> splitAndSerializePage(Page page) {
        List<Page> split = PageSplitterUtil.splitPage(page, 0x100000L);
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)split.size());
        for (Page chunk : split) {
            builder.add((Object)this.serializer.serialize(chunk));
        }
        return builder.build();
    }

    private void updateMemoryUsage() {
        long retainedSizeInBytes = 0L;
        for (PositionsAppenderPageBuilder pageBuilder : this.positionsAppenders) {
            retainedSizeInBytes += pageBuilder.getRetainedSizeInBytes();
        }
        this.memoryContext.setBytes(retainedSizeInBytes += this.serializer.getRetainedSizeInBytes());
    }
}

