/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.output;

import io.trino.operator.output.PositionsAppender;
import io.trino.operator.output.RowPositionsAppender;
import io.trino.operator.output.TypedPositionsAppender;
import io.trino.operator.output.UnnestingPositionsAppender;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.RowBlock;
import io.trino.spi.block.VariableWidthBlock;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.type.BlockTypeOperators;
import java.util.Objects;
import java.util.Optional;

public class PositionsAppenderFactory {
    private final BlockTypeOperators blockTypeOperators;
    private static final int EXPECTED_VARIABLE_WIDTH_BYTES_PER_ENTRY = 32;

    public PositionsAppenderFactory(BlockTypeOperators blockTypeOperators) {
        this.blockTypeOperators = Objects.requireNonNull(blockTypeOperators, "blockTypeOperators is null");
    }

    public UnnestingPositionsAppender create(Type type, int expectedPositions, long maxPageSizeInBytes) {
        Optional<BlockTypeOperators.BlockPositionIsIdentical> distinctFromOperator = Optional.empty();
        if (type.isComparable()) {
            distinctFromOperator = Optional.of(this.blockTypeOperators.getIdenticalOperator(type));
        }
        return new UnnestingPositionsAppender(this.createPrimitiveAppender(type, expectedPositions, maxPageSizeInBytes), distinctFromOperator);
    }

    private PositionsAppender createPrimitiveAppender(Type type, int expectedPositions, long maxPageSizeInBytes) {
        if (type.getValueBlockType() == RowBlock.class) {
            return RowPositionsAppender.createRowAppender(this, (RowType)type, expectedPositions, maxPageSizeInBytes);
        }
        if (type.getValueBlockType() == VariableWidthBlock.class) {
            int expectedBytes = (int)Math.min((long)expectedPositions * 32L, maxPageSizeInBytes);
            expectedBytes = Math.min(expectedBytes, 0x7FFFFFF7);
            return new TypedPositionsAppender((BlockBuilder)new VariableWidthBlockBuilder(null, expectedPositions, expectedBytes));
        }
        return new TypedPositionsAppender(type, expectedPositions);
    }
}

