/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.project;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Ints;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.connector.SourcePage;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.ObjLongConsumer;

public class InputChannels {
    private final int[] inputChannels;
    @Nullable
    private final boolean[] eagerlyLoad;

    public InputChannels(int ... inputChannels) {
        this.inputChannels = (int[])inputChannels.clone();
        this.eagerlyLoad = null;
    }

    public InputChannels(List<Integer> inputChannels) {
        this.inputChannels = inputChannels.stream().mapToInt(Integer::intValue).toArray();
        this.eagerlyLoad = null;
    }

    public InputChannels(List<Integer> inputChannels, Set<Integer> eagerlyLoadedChannels) {
        this.inputChannels = inputChannels.stream().mapToInt(Integer::intValue).toArray();
        this.eagerlyLoad = new boolean[this.inputChannels.length];
        for (int i = 0; i < this.inputChannels.length; ++i) {
            this.eagerlyLoad[i] = eagerlyLoadedChannels.contains(this.inputChannels[i]);
        }
    }

    public int size() {
        return this.inputChannels.length;
    }

    public List<Integer> getInputChannels() {
        return Collections.unmodifiableList(Ints.asList((int[])this.inputChannels));
    }

    public SourcePage getInputChannels(SourcePage page) {
        return new InputChannelsSourcePage(page, this.inputChannels, this.eagerlyLoad);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)Arrays.toString(this.inputChannels)).toString();
    }

    private static final class InputChannelsSourcePage
    implements SourcePage {
        private final SourcePage sourcePage;
        private final int[] channels;
        private final Block[] blocks;

        private InputChannelsSourcePage(SourcePage sourcePage, int[] channels, @Nullable boolean[] eagerlyLoad) {
            Objects.requireNonNull(sourcePage, "sourcePage is null");
            Objects.requireNonNull(channels, "channels is null");
            this.sourcePage = sourcePage;
            this.channels = channels;
            this.blocks = new Block[channels.length];
            if (eagerlyLoad != null) {
                for (int channel = 0; channel < eagerlyLoad.length; ++channel) {
                    if (!eagerlyLoad[channel]) continue;
                    this.blocks[channel] = sourcePage.getBlock(channels[channel]).getLoadedBlock();
                }
            }
        }

        public int getPositionCount() {
            return this.sourcePage.getPositionCount();
        }

        public long getSizeInBytes() {
            return this.sourcePage.getSizeInBytes();
        }

        public long getRetainedSizeInBytes() {
            return this.sourcePage.getRetainedSizeInBytes();
        }

        public void retainedBytesForEachPart(ObjLongConsumer<Object> consumer) {
            for (Block block : this.blocks) {
                if (block == null) continue;
                block.retainedBytesForEachPart(consumer);
            }
        }

        public int getChannelCount() {
            return this.blocks.length;
        }

        public Block getBlock(int channel) {
            Block block = this.blocks[channel];
            if (block == null) {
                this.blocks[channel] = block = this.sourcePage.getBlock(this.channels[channel]);
            }
            return block;
        }

        public Page getPage() {
            for (int i = 0; i < this.blocks.length; ++i) {
                this.getBlock(i);
            }
            return new Page(this.getPositionCount(), this.blocks);
        }

        public Page getColumns(int[] channels) {
            Block[] blocks = new Block[channels.length];
            for (int i = 0; i < channels.length; ++i) {
                blocks[i] = this.getBlock(channels[i]);
            }
            return new Page(this.getPositionCount(), blocks);
        }

        public void selectPositions(int[] positions, int offset, int size) {
            this.sourcePage.selectPositions(positions, offset, size);
            for (int i = 0; i < this.blocks.length; ++i) {
                Block block = this.blocks[i];
                if (block == null) continue;
                this.blocks[i] = block.getPositions(positions, offset, size);
            }
        }
    }
}

