/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamptz;

import io.trino.spi.function.Constraint;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.TimeZoneKey;
import io.trino.type.DateTimes;
import io.trino.util.DateTimeZoneIndex;

public final class TimestampWithTimeZoneOperators {
    private TimestampWithTimeZoneOperators() {
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    public static final class TimestampMinusTimestamp {
        private TimestampMinusTimestamp() {
        }

        @LiteralParameters(value={"p"})
        @SqlType(value="interval day to second")
        public static long subtract(@SqlType(value="timestamp(p) with time zone") long left, @SqlType(value="timestamp(p) with time zone") long right) {
            return DateTimeEncoding.unpackMillisUtc((long)left) - DateTimeEncoding.unpackMillisUtc((long)right);
        }

        @LiteralParameters(value={"p"})
        @SqlType(value="interval day to second")
        public static long subtract(@SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone left, @SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone right) {
            long interval = left.getEpochMillis() - right.getEpochMillis();
            int deltaPicos = left.getPicosOfMilli() - right.getPicosOfMilli();
            if (deltaPicos < 0 && DateTimes.roundToNearest(-deltaPicos, 1000000000L) == 1000000000L) {
                --interval;
            } else if (deltaPicos > 0 && DateTimes.roundToNearest(deltaPicos, 1000000000L) == 1000000000L) {
                ++interval;
            }
            return interval;
        }
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    public static final class TimestampMinusIntervalDayToSecond {
        private TimestampMinusIntervalDayToSecond() {
        }

        @LiteralParameters(value={"p", "u"})
        @SqlType(value="timestamp(u) with time zone")
        @Constraint(variable="u", expression="max(3, p)")
        public static long subtract(@SqlType(value="timestamp(p) with time zone") long timestamp, @SqlType(value="interval day to second") long interval) {
            return TimestampPlusIntervalDayToSecond.add(timestamp, -interval);
        }

        @LiteralParameters(value={"p", "u"})
        @SqlType(value="timestamp(u) with time zone")
        @Constraint(variable="u", expression="max(3, p)")
        public static LongTimestampWithTimeZone subtract(@SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone timestamp, @SqlType(value="interval day to second") long interval) {
            return TimestampPlusIntervalDayToSecond.add(timestamp, -interval);
        }
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    public static final class TimestampMinusIntervalYearToMonth {
        private TimestampMinusIntervalYearToMonth() {
        }

        @LiteralParameters(value={"p"})
        @SqlType(value="timestamp(p) with time zone")
        public static long subtract(@SqlType(value="timestamp(p) with time zone") long timestamp, @SqlType(value="interval year to month") long interval) {
            return TimestampPlusIntervalYearToMonth.add(timestamp, -interval);
        }

        @LiteralParameters(value={"p"})
        @SqlType(value="timestamp(p) with time zone")
        public static LongTimestampWithTimeZone subtract(@SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone timestamp, @SqlType(value="interval year to month") long interval) {
            return TimestampPlusIntervalYearToMonth.add(timestamp, -interval);
        }
    }

    @ScalarOperator(value=OperatorType.ADD)
    public static final class IntervalYearToMonthPlusTimestamp {
        private IntervalYearToMonthPlusTimestamp() {
        }

        @LiteralParameters(value={"p"})
        @SqlType(value="timestamp(p) with time zone")
        public static long add(@SqlType(value="interval year to month") long interval, @SqlType(value="timestamp(p) with time zone") long timestamp) {
            return TimestampPlusIntervalYearToMonth.add(timestamp, interval);
        }

        @LiteralParameters(value={"p"})
        @SqlType(value="timestamp(p) with time zone")
        public static LongTimestampWithTimeZone add(@SqlType(value="interval year to month") long interval, @SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone timestamp) {
            return TimestampPlusIntervalYearToMonth.add(timestamp, interval);
        }
    }

    @ScalarOperator(value=OperatorType.ADD)
    public static final class TimestampPlusIntervalYearToMonth {
        private TimestampPlusIntervalYearToMonth() {
        }

        @LiteralParameters(value={"p"})
        @SqlType(value="timestamp(p) with time zone")
        public static long add(@SqlType(value="timestamp(p) with time zone") long packedEpochMillis, @SqlType(value="interval year to month") long interval) {
            long epochMillis = DateTimeEncoding.unpackMillisUtc((long)packedEpochMillis);
            long result = DateTimeZoneIndex.unpackChronology(packedEpochMillis).monthOfYear().add(epochMillis, interval);
            return DateTimeEncoding.packDateTimeWithZone((long)result, (TimeZoneKey)DateTimeEncoding.unpackZoneKey((long)packedEpochMillis));
        }

        @LiteralParameters(value={"p"})
        @SqlType(value="timestamp(p) with time zone")
        public static LongTimestampWithTimeZone add(@SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone timestamp, @SqlType(value="interval year to month") long interval) {
            long epochMillis = timestamp.getEpochMillis();
            long result = DateTimeZoneIndex.unpackChronology(timestamp.getTimeZoneKey()).monthOfYear().add(epochMillis, interval);
            return LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)result, (int)timestamp.getPicosOfMilli(), (short)timestamp.getTimeZoneKey());
        }
    }

    @ScalarOperator(value=OperatorType.ADD)
    public static final class IntervalDayToSecondPlusTimestamp {
        private IntervalDayToSecondPlusTimestamp() {
        }

        @LiteralParameters(value={"p", "u"})
        @SqlType(value="timestamp(u) with time zone")
        @Constraint(variable="u", expression="max(3, p)")
        public static long add(@SqlType(value="interval day to second") long interval, @SqlType(value="timestamp(p) with time zone") long timestamp) {
            return TimestampPlusIntervalDayToSecond.add(timestamp, interval);
        }

        @LiteralParameters(value={"p", "u"})
        @SqlType(value="timestamp(u) with time zone")
        @Constraint(variable="u", expression="max(3, p)")
        public static LongTimestampWithTimeZone add(@SqlType(value="interval day to second") long interval, @SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone timestamp) {
            return TimestampPlusIntervalDayToSecond.add(timestamp, interval);
        }
    }

    @ScalarOperator(value=OperatorType.ADD)
    public static final class TimestampPlusIntervalDayToSecond {
        private TimestampPlusIntervalDayToSecond() {
        }

        @LiteralParameters(value={"p", "u"})
        @SqlType(value="timestamp(u) with time zone")
        @Constraint(variable="u", expression="max(3, p)")
        public static long add(@SqlType(value="timestamp(p) with time zone") long packedEpochMillis, @SqlType(value="interval day to second") long interval) {
            return DateTimeEncoding.packDateTimeWithZone((long)(DateTimeEncoding.unpackMillisUtc((long)packedEpochMillis) + interval), (TimeZoneKey)DateTimeEncoding.unpackZoneKey((long)packedEpochMillis));
        }

        @LiteralParameters(value={"p", "u"})
        @SqlType(value="timestamp(u) with time zone")
        @Constraint(variable="u", expression="max(3, p)")
        public static LongTimestampWithTimeZone add(@SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone timestamp, @SqlType(value="interval day to second") long interval) {
            return LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)(timestamp.getEpochMillis() + interval), (int)timestamp.getPicosOfMilli(), (short)timestamp.getTimeZoneKey());
        }
    }
}

