/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timetz;

import io.airlift.slice.Slice;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.LongTimeWithTimeZone;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimeZoneNotSupportedException;
import io.trino.type.DateTimes;

@ScalarFunction(value="$at_timezone", hidden=true)
public final class AtTimeZone {
    private AtTimeZone() {
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="time(p) with time zone")
    public static long atTimeZone(ConnectorSession session, @SqlType(value="time(p) with time zone") long packedTime, @SqlType(value="varchar(x)") Slice zoneId) {
        TimeZoneKey zoneKey;
        try {
            zoneKey = TimeZoneKey.getTimeZoneKey((String)zoneId.toStringUtf8());
        }
        catch (TimeZoneNotSupportedException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("'%s' is not a valid time zone", zoneId));
        }
        int offsetMinutes = DateTimes.getOffsetMinutes(session.getStart(), zoneKey);
        long nanos = DateTimeEncoding.unpackTimeNanos((long)packedTime) - (long)(DateTimeEncoding.unpackOffsetMinutes((long)packedTime) - offsetMinutes) * 60000000000L;
        return DateTimeEncoding.packTimeWithTimeZone((long)Math.floorMod(nanos, 86400000000000L), (int)offsetMinutes);
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="time(p) with time zone")
    public static LongTimeWithTimeZone atTimeZone(ConnectorSession session, @SqlType(value="time(p) with time zone") LongTimeWithTimeZone time, @SqlType(value="varchar(x)") Slice zoneId) {
        TimeZoneKey zoneKey;
        try {
            zoneKey = TimeZoneKey.getTimeZoneKey((String)zoneId.toStringUtf8());
        }
        catch (TimeZoneNotSupportedException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("'%s' is not a valid time zone", zoneId));
        }
        int offsetMinutes = DateTimes.getOffsetMinutes(session.getStart(), zoneKey);
        long picos = time.getPicoseconds() - (long)(time.getOffsetMinutes() - offsetMinutes) * 60000000000000L;
        return new LongTimeWithTimeZone(Math.floorMod(picos, 86400000000000000L), offsetMinutes);
    }
}

