/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window;

import com.google.common.collect.Iterables;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.ValueWindowFunction;
import io.trino.spi.function.WindowFunctionSignature;
import java.util.List;

@WindowFunctionSignature(name="first_value", typeVariable="T", returnType="T", argumentTypes={"T"})
public class FirstValueFunction
extends ValueWindowFunction {
    private final int argumentChannel;
    private final boolean ignoreNulls;
    private int recordedFrameStart = -1;
    private int recordedValuePosition = -1;
    private int recordedNullPosition = -1;

    public FirstValueFunction(List<Integer> argumentChannels, boolean ignoreNulls) {
        this.argumentChannel = (Integer)Iterables.getOnlyElement(argumentChannels);
        this.ignoreNulls = ignoreNulls;
    }

    public void reset() {
        this.recordedFrameStart = -1;
        this.recordedValuePosition = -1;
        this.recordedNullPosition = -1;
    }

    public void processRow(BlockBuilder output, int frameStart, int frameEnd, int currentPosition) {
        int valuePosition;
        if (frameStart < 0) {
            output.appendNull();
            return;
        }
        if (!this.ignoreNulls) {
            this.windowIndex.appendTo(this.argumentChannel, frameStart, output);
            return;
        }
        if (this.recordedFrameStart >= 0 && frameStart >= this.recordedFrameStart) {
            if (this.recordedValuePosition >= 0 && frameStart <= this.recordedValuePosition) {
                if (frameEnd < this.recordedValuePosition) {
                    output.appendNull();
                    return;
                }
                this.windowIndex.appendTo(this.argumentChannel, this.recordedValuePosition, output);
                return;
            }
            if (this.recordedNullPosition >= 0 && frameStart <= this.recordedNullPosition && frameEnd <= this.recordedNullPosition) {
                output.appendNull();
                return;
            }
        }
        this.recordedFrameStart = frameStart;
        this.recordedValuePosition = -1;
        this.recordedNullPosition = -1;
        for (valuePosition = this.recordedFrameStart >= 0 && this.recordedNullPosition >= 0 && frameStart >= this.recordedFrameStart && frameStart <= this.recordedNullPosition ? this.recordedNullPosition : frameStart; valuePosition >= 0 && valuePosition <= frameEnd && this.windowIndex.isNull(this.argumentChannel, valuePosition); ++valuePosition) {
        }
        if (valuePosition > frameEnd) {
            this.recordedNullPosition = frameEnd;
            output.appendNull();
            return;
        }
        this.recordedValuePosition = valuePosition;
        this.windowIndex.appendTo(this.argumentChannel, valuePosition, output);
    }
}

