/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window.pattern;

import io.airlift.slice.Slices;
import io.trino.operator.DriverYieldSignal;
import io.trino.operator.Work;
import io.trino.operator.project.PageProjection;
import io.trino.operator.project.SelectedPositions;
import io.trino.operator.window.matcher.ArrayView;
import io.trino.operator.window.pattern.MatchAggregation;
import io.trino.operator.window.pattern.MatchAggregationPointer;
import io.trino.operator.window.pattern.PhysicalValueAccessor;
import io.trino.operator.window.pattern.PhysicalValuePointer;
import io.trino.operator.window.pattern.ProjectingPagesWindowIndex;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SourcePage;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public class MeasureComputation {
    private final PageProjection projection;
    private final List<PhysicalValueAccessor> expectedLayout;
    private final MatchAggregation[] aggregations;
    private final Block[] nulls;
    private final Type type;
    private final List<String> labelNames;
    private final ConnectorSession session;

    public MeasureComputation(PageProjection projection, List<PhysicalValueAccessor> expectedLayout, List<MatchAggregation> aggregations, Type type, List<String> labelNames, ConnectorSession session) {
        this.projection = Objects.requireNonNull(projection, "projection is null");
        this.expectedLayout = Objects.requireNonNull(expectedLayout, "expectedLayout is null");
        this.aggregations = aggregations.toArray(new MatchAggregation[0]);
        this.nulls = MeasureComputation.precomputeNulls(expectedLayout);
        this.type = Objects.requireNonNull(type, "type is null");
        this.labelNames = Objects.requireNonNull(labelNames, "labelNames is null");
        this.session = Objects.requireNonNull(session, "session is null");
    }

    public Type getType() {
        return this.type;
    }

    public Block compute(int currentRow, ArrayView matchedLabels, int partitionStart, int searchStart, int searchEnd, int patternStart, long matchNumber, ProjectingPagesWindowIndex windowIndex) {
        return MeasureComputation.compute(currentRow, matchedLabels, this.aggregations, partitionStart, searchStart, searchEnd, patternStart, matchNumber, windowIndex, this.projection, this.expectedLayout, this.nulls, this.labelNames, this.session);
    }

    public Block computeEmpty(long matchNumber) {
        Block[] blocks = new Block[this.expectedLayout.size()];
        for (int i = 0; i < this.expectedLayout.size(); ++i) {
            PhysicalValueAccessor accessor = this.expectedLayout.get(i);
            if (accessor instanceof PhysicalValuePointer) {
                PhysicalValuePointer pointer = (PhysicalValuePointer)accessor;
                if (pointer.getSourceChannel() == -2) {
                    blocks[i] = Utils.nativeValueToBlock((Type)BigintType.BIGINT, (Object)matchNumber);
                    continue;
                }
                blocks[i] = Utils.nativeValueToBlock((Type)pointer.getType(), null);
                continue;
            }
            MatchAggregation aggregation = this.aggregations[((MatchAggregationPointer)accessor).getIndex()];
            blocks[i] = aggregation.aggregateEmpty();
        }
        SourcePage page = SourcePage.create((Page)new Page(1, blocks));
        Work<Block> work = this.projection.project(this.session, new DriverYieldSignal(), this.projection.getInputChannels().getInputChannels(page), SelectedPositions.positionsRange(0, 1));
        boolean done = false;
        while (!done) {
            done = work.process();
        }
        return work.getResult();
    }

    public static Block compute(int currentRow, ArrayView matchedLabels, MatchAggregation[] aggregations, int partitionStart, int searchStart, int searchEnd, int patternStart, long matchNumber, ProjectingPagesWindowIndex windowIndex, PageProjection projection, List<PhysicalValueAccessor> expectedLayout, Block[] nulls, List<String> labelNames, ConnectorSession session) {
        Block[] blocks = new Block[expectedLayout.size()];
        for (int i = 0; i < expectedLayout.size(); ++i) {
            PhysicalValueAccessor accessor = expectedLayout.get(i);
            if (accessor instanceof PhysicalValuePointer) {
                PhysicalValuePointer pointer = (PhysicalValuePointer)accessor;
                int channel = pointer.getSourceChannel();
                if (channel == -2) {
                    blocks[i] = Utils.nativeValueToBlock((Type)BigintType.BIGINT, (Object)matchNumber);
                    continue;
                }
                int position = pointer.getLogicalIndexNavigation().resolvePosition(currentRow, matchedLabels, searchStart, searchEnd, patternStart);
                if (position >= 0) {
                    if (channel == -1) {
                        VarcharType type = VarcharType.VARCHAR;
                        if (position < patternStart || position >= patternStart + matchedLabels.length()) {
                            blocks[i] = Utils.nativeValueToBlock((Type)type, null);
                            continue;
                        }
                        blocks[i] = Utils.nativeValueToBlock((Type)type, (Object)Slices.utf8Slice((String)labelNames.get(matchedLabels.get(position - patternStart))));
                        continue;
                    }
                    blocks[i] = windowIndex.getSingleValueBlock(channel, position - partitionStart);
                    continue;
                }
                blocks[i] = nulls[i];
                continue;
            }
            MatchAggregation aggregation = aggregations[((MatchAggregationPointer)accessor).getIndex()];
            blocks[i] = aggregation.aggregate(currentRow, matchedLabels, matchNumber, windowIndex, partitionStart, patternStart);
        }
        SourcePage page = SourcePage.create((Page)new Page(1, blocks));
        Work<Block> work = projection.project(session, new DriverYieldSignal(), projection.getInputChannels().getInputChannels(page), SelectedPositions.positionsRange(0, 1));
        boolean done = false;
        while (!done) {
            done = work.process();
        }
        return work.getResult();
    }

    public static Block[] precomputeNulls(List<PhysicalValueAccessor> expectedLayout) {
        Block[] nulls = new Block[expectedLayout.size()];
        for (int i = 0; i < expectedLayout.size(); ++i) {
            PhysicalValueAccessor accessor = expectedLayout.get(i);
            if (!(accessor instanceof PhysicalValuePointer)) continue;
            nulls[i] = Utils.nativeValueToBlock((Type)((PhysicalValuePointer)accessor).getType(), null);
        }
        return nulls;
    }

    public static class MeasureComputationSupplier {
        private final Supplier<PageProjection> projection;
        private final List<PhysicalValueAccessor> expectedLayout;
        private final Type type;
        private final List<String> labelNames;
        private final ConnectorSession session;

        public MeasureComputationSupplier(Supplier<PageProjection> projection, List<PhysicalValueAccessor> expectedLayout, Type type, List<String> labelNames, ConnectorSession session) {
            this.projection = Objects.requireNonNull(projection, "projection is null");
            this.expectedLayout = Objects.requireNonNull(expectedLayout, "expectedLayout is null");
            this.type = Objects.requireNonNull(type, "type is null");
            this.labelNames = Objects.requireNonNull(labelNames, "labelNames is null");
            this.session = Objects.requireNonNull(session, "session is null");
        }

        public MeasureComputation get(List<MatchAggregation> aggregations) {
            return new MeasureComputation(this.projection.get(), this.expectedLayout, aggregations, this.type, this.labelNames, this.session);
        }
    }
}

