/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.base.Throwables;
import com.google.inject.Inject;
import io.airlift.jaxrs.JsonParsingException;
import io.trino.server.GoneException;
import io.trino.server.ServerConfig;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.ServerErrorException;
import jakarta.ws.rs.ServiceUnavailableException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.concurrent.TimeoutException;

public class ThrowableMapper
implements ExceptionMapper<Throwable> {
    private final boolean includeExceptionInResponse;

    @Inject
    public ThrowableMapper(ServerConfig config) {
        this.includeExceptionInResponse = config.isIncludeExceptionInResponse();
    }

    public Response toResponse(Throwable throwable) {
        Throwable throwable2 = throwable;
        Objects.requireNonNull(throwable2);
        Throwable throwable3 = throwable2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ForbiddenException.class, ServiceUnavailableException.class, NotFoundException.class, BadRequestException.class, InternalServerErrorException.class, ServerErrorException.class, GoneException.class, TimeoutException.class, WebApplicationException.class, JsonParsingException.class}, (Throwable)throwable3, n)) {
            case 0 -> {
                ForbiddenException forbiddenException = (ForbiddenException)throwable3;
                yield ThrowableMapper.plainTextError(Response.Status.FORBIDDEN).entity((Object)("Error 403 Forbidden: " + forbiddenException.getMessage())).build();
            }
            case 1 -> {
                ServiceUnavailableException serviceUnavailableException = (ServiceUnavailableException)throwable3;
                yield ThrowableMapper.plainTextError(Response.Status.SERVICE_UNAVAILABLE).entity((Object)("Error 503 Service Unavailable: " + serviceUnavailableException.getMessage())).build();
            }
            case 2 -> {
                NotFoundException notFoundException = (NotFoundException)throwable3;
                yield ThrowableMapper.plainTextError(Response.Status.NOT_FOUND).entity((Object)("Error 404 Not Found: " + notFoundException.getMessage())).build();
            }
            case 3 -> {
                BadRequestException badRequestException = (BadRequestException)throwable3;
                yield ThrowableMapper.plainTextError(Response.Status.BAD_REQUEST).entity((Object)("Error 400 Bad Request: " + badRequestException.getMessage())).build();
            }
            case 4 -> {
                InternalServerErrorException internalServerErrorException = (InternalServerErrorException)throwable3;
                yield ThrowableMapper.plainTextError(Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Error 500 Internal Server Error: " + internalServerErrorException.getMessage())).build();
            }
            case 5 -> {
                ServerErrorException serverErrorException = (ServerErrorException)throwable3;
                yield ThrowableMapper.plainTextError(Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Error 500 Internal Server Error: " + serverErrorException.getMessage())).build();
            }
            case 6 -> {
                GoneException goneException = (GoneException)((Object)throwable3);
                yield ThrowableMapper.plainTextError(Response.Status.GONE).entity((Object)("Error 410 Gone: " + goneException.getMessage())).build();
            }
            case 7 -> {
                TimeoutException timeoutException = (TimeoutException)throwable3;
                yield ThrowableMapper.plainTextError(Response.Status.REQUEST_TIMEOUT).entity((Object)("Error 408 Timeout: " + timeoutException.getMessage())).build();
            }
            case 8 -> {
                WebApplicationException webApplicationException = (WebApplicationException)throwable3;
                yield webApplicationException.getResponse();
            }
            case 9 -> {
                JsonParsingException parsingException = (JsonParsingException)throwable3;
                yield Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)Throwables.getStackTraceAsString((Throwable)parsingException)).build();
            }
            default -> {
                Response.ResponseBuilder responseBuilder = ThrowableMapper.plainTextError(Response.Status.INTERNAL_SERVER_ERROR);
                if (this.includeExceptionInResponse) {
                    responseBuilder.entity((Object)Throwables.getStackTraceAsString((Throwable)throwable));
                } else {
                    responseBuilder.entity((Object)"Exception processing request");
                }
                yield responseBuilder.build();
            }
        };
    }

    private static Response.ResponseBuilder plainTextError(Response.Status status) {
        return Response.status((Response.Status)status).header("Content-Type", (Object)"text/plain");
    }
}

